package com.ejianc.poc.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.cache.serializer.Serializer;
import com.ejianc.framework.cache.serializer.impl.DefaultJDKSerializer;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.poc.service.impl.ZtjApisService;
import com.ejianc.poc.vo.OrgVO;
import com.ejianc.poc.vo.UserVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.catalina.User;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.nio.charset.Charset;
import java.util.*;

/**
 * @author CJ
 * @Description:
 * @date 2021/4/14 15:07
 */
@RestController
@RequestMapping(value = "/employee/")
public class EmployeeManageController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ZtjApisService ztjApisService;

    @Autowired
    private CacheManager cacheManager;

    private final String userCachePrefix = "orgUserList::";

    public static final String DEFAULT_CHARSET = "UTF-8";

    private final static String ORG_LIST_KEY = "org_list_key";

    private Serializer serializer = new DefaultJDKSerializer();

    @GetMapping(value = "pageList")
    public CommonResponse<IPage<UserVO>> pageList(@RequestParam(value = "pageSize") int pageSize,
                                          @RequestParam(value = "pageNumber") int pageNumber,
                                          @RequestParam(value = "providerId", required = false) String providerId,
                                          @RequestParam(value = "orgId") String orgId,
                                          @RequestParam(value = "deptId", required = false) String deptId,
                                          @RequestParam(value = "searchText", required = false) String searchText) {

        logger.info("分页查询人员列表-参数：pageSize-{}，pageNumber-{}，providerId-{}，orgId-{}，deptId-{}", pageSize, pageNumber, providerId, orgId, deptId);
        long start = System.currentTimeMillis();

        String allOrgUsers = null;
        IPage<UserVO> pageUser = new Page<>();
        pageNumber = pageNumber - 1 <= 0 ? 1 : pageNumber;
        int from = (pageNumber - 1) * pageSize;
        int to = pageNumber * pageSize;
        int size = 0;
        List<UserVO> users = new ArrayList<>();
        List<UserVO> tmpUserList = null;
        JSONArray userOrgArr = null;
        String orgName = null;
        String deptName = null;

        pageUser.setSize(pageSize);
        pageUser.setCurrent(pageNumber);
        pageUser.setRecords(new ArrayList<>());

        if(OrgVO.rootOrgId.toString().equals(orgId)) {
            //获取所有二级集团单位信息
            JSONArray jsonArray = ztjApisService.getAllSecondOrgList();
            JSONObject objJson = null;
            JSONObject orgJson = null;

            for(Object obj : jsonArray) {
                objJson = JSONObject.parseObject(JSONObject.toJSONString(obj));
                orgJson = objJson.getJSONObject("root");

                if(StringUtils.isNotBlank(searchText)) {
                    //搜索每个二级集团下的用户
                    userOrgArr = ztjApisService.queryUsers(objJson.getString("id"), orgJson.getString("id"), searchText, false);

                    if(userOrgArr.size() > 0) {
                        long searchSize = 0;
                        //遍历返回的搜索结果
                        for(int i =0,len=userOrgArr.size(); i<len; i++) {
                            searchSize = userOrgArr.getJSONObject(i).getJSONArray("positions").size();
                            if(pageUser.getSize() <= pageUser.getRecords().size()) {
                                pageUser.setTotal(pageUser.getTotal() + searchSize);
                            } else {
                                handlerSearchUserJsonArr(pageUser, userOrgArr.getJSONObject(i), objJson.getString("id"), searchSize);
                            }
                        }
                    }
                } else {
                    allOrgUsers = ztjApisService.queryAllTreeOrgAndUsers(objJson.getString("id"), orgJson.getString("id"));

                    if(StringUtils.isNotBlank(allOrgUsers)) {
                        orgJson = JSONObject.parseObject(allOrgUsers);
                        userOrgArr = orgJson.getJSONArray("children");
                        orgName = orgJson.getString("name");

                        if(null != userOrgArr) {
                            if(pageUser.getSize() <= pageUser.getRecords().size()) {
                                countUser(userOrgArr, pageUser);
                            } else {
                                users.addAll(parseOrgUseJsonList(userOrgArr, null, orgName, null, pageUser, objJson.getString("id"), null));
                            }
                        }
                    }
                }
            }

            logger.info("查询所有的人员列表结果：{}", pageUser.getRecords());
        } else {
            if(StringUtils.isNotBlank(searchText)) {
                //搜索指定单位下的用户
                userOrgArr = ztjApisService.queryUsers(providerId, orgId, searchText, false);
                if(userOrgArr.size() > 0) {
                    long searchSize = 0;
                    for(int i =0,len=userOrgArr.size(); i<len; i++) {
                        searchSize = userOrgArr.getJSONObject(i).getJSONArray("positions").size();
                        if(searchSize <= pageUser.getRecords().size()) {
                            pageUser.setTotal(pageUser.getTotal() + searchSize);
                        } else {
                            handlerSearchUserJsonArr(pageUser, userOrgArr.getJSONObject(i), providerId, searchSize);
                        }
                    }
                }
            } else {
                allOrgUsers = ztjApisService.queryAllTreeOrgAndUsers(providerId, orgId);
                String lastNotVirtualPid = null;

                orgName = "";
                JSONObject orgJson = null;
                //当查询组织为部门时，用于判断循环节点是否在该部门树上的父级节点
                List<String> treeIdList = new ArrayList<>();
                //若为虚拟组织机构，则向上查询其最近的非虚拟上级
                JSONArray orgPathJsonArr = ztjApisService.getOrgPath(providerId, orgId);
                if(orgPathJsonArr.size() > 0) {
                    JSONObject tmpOrg = null;
                    for(Object obj : orgPathJsonArr) {
                        tmpOrg = (JSONObject)obj;
                        if("1".equals(tmpOrg.getString("type")) && !tmpOrg.getBoolean("virtual")) {
                            orgName = tmpOrg.getString("name") + orgName;
                            if(null == lastNotVirtualPid) {
                                lastNotVirtualPid = tmpOrg.getString("id");
                            }
                        }
                        treeIdList.add(tmpOrg.getString("id"));
                    }
                }
                if(StringUtils.isNotBlank(deptId)) {
                    treeIdList.add(deptId);
                }

                if(StringUtils.isNotBlank(allOrgUsers)) {
                    orgJson = JSONObject.parseObject(allOrgUsers);
                    userOrgArr = orgJson.getJSONArray("children");
                    if(null != userOrgArr) {
                        users.addAll(parseOrgUseJsonList(userOrgArr, deptId, orgName, null, pageUser, providerId, treeIdList));
                    }
                }
            }
            logger.info("查询指定组织的的人员列表结果：{}", JSONObject.toJSONString(pageUser.getRecords()));
        }

        if(StringUtils.isNotBlank(searchText)) {
            makeupUserInfo(pageUser);
        }

        long end = System.currentTimeMillis();
        logger.info("查询组织人员列表耗时：-{}毫秒", (end - start));

        return CommonResponse.success("分页查询成功！", pageUser);
    }


    private void makeupUserInfo(IPage<UserVO> pageUser) {
        StringBuilder orgName = new StringBuilder("");
        for(UserVO user : pageUser.getRecords()) {
            JSONArray orgPathJsonArr = ztjApisService.getOrgPath(user.getProviderId(), user.getPositionId());
            if(orgPathJsonArr.size() > 0) {
                JSONObject tmpOrg = null;
                for(Object obj : orgPathJsonArr) {
                    tmpOrg = (JSONObject)obj;
                    switch (tmpOrg.getString("type")) {
                        case "1":
                            if(!tmpOrg.getBoolean("virtual") ) {
                                orgName.insert(0, tmpOrg.getString("name"));
                            }
                            continue;
                        case "2":
                            user.setDeptName(tmpOrg.getString("name"));
                            continue;
                        case "3":
                            user.setPositionName(tmpOrg.getString("name"));
                            user.setPositionId(tmpOrg.getString("id"));
                            user.setPostName(tmpOrg.getString("name"));
                            user.setPostOrder(tmpOrg.getInteger("order"));
                            continue;
                        default:;
                    }
                }
                user.setOrgName(orgName.toString());
                orgName.delete(0, orgName.length());
            }
        }
    }

    private void handlerSearchUserJsonArr(IPage<UserVO> page, JSONObject searchUser, String providerId, long size) {
        long start = (page.getCurrent() - 1) * page.getSize();
        long limit = page.getSize() - (null != page.getRecords() ? page.getRecords().size() : 0);
        start = start > page.getTotal() ? start - page.getTotal() : 0;
        long to = start + limit;
        JSONArray postsArr = searchUser.getJSONArray("positions");
        UserVO user = null;
        List<UserVO> userVOS = new ArrayList<>();

        int curIdx = 0;
        if(!(size < start || limit <= 0)) {
            for(int i=0,len=postsArr.size(); i<len; i++) {
                if((curIdx < start) || (curIdx >= to)) {
                    curIdx++;
                    continue;
                }
                searchUser.getJSONObject("user").put("mainPosition", postsArr.getJSONObject(i).getBoolean("mainPosition"));
                user = pageUsers(searchUser.getJSONObject("user"), providerId, null, null, null, null);
                user.setPositionId(postsArr.getJSONObject(i).getString("id"));
                userVOS.add(user);
                curIdx++;
            }
            page.getRecords().addAll(userVOS);
            userVOS.clear();
        }
        page.setTotal(page.getTotal() + size);
    }


    private void cacheOrgUserInfo(JSONArray jsonArray, String cacheKey) {
        cacheManager.removeCache(cacheKey);
        if(jsonArray != null && jsonArray.size() > 0) {
            cacheManager.piplineExecute(pipeline -> {
                pipeline.multi();
                String key = cacheKey;
                byte[] keyBytes = ORG_LIST_KEY.getBytes(Charset.forName(DEFAULT_CHARSET));
                byte[] fieldBytes = key.getBytes(Charset.forName(DEFAULT_CHARSET));
                for (Object orgObj : jsonArray) {
                    byte[] contentBytes = serializer.marshalToByte(JSON.toJSONString(orgObj));
                    pipeline.hset(keyBytes, fieldBytes, contentBytes);
                }
                pipeline.exec();
            });
        }
    }

    @PostMapping(value = "employeeExport")
    public void exportExcel(@RequestBody JSONObject paramJson, HttpServletResponse response) {
        String orgId = paramJson.getString("orgId");
        String providerId = paramJson.getString("providerId");
        String deptId = paramJson.getString("deptId");
        logger.info("人员列表导出-参数：providerId-{}，orgId-{}，deptId-{}", providerId, orgId, deptId);

        String allOrgUsers = null;
        List<UserVO> users = new ArrayList<>();
        List<UserVO> tmpUserList = null;
        JSONArray userOrgArr = null;
        String orgName = null;
        String deptName = null;

        if(OrgVO.rootOrgId.toString().equals(orgId)) {
            //获取所有二级集团单位信息
            JSONArray jsonArray = ztjApisService.getAllSecondOrgList();
            JSONObject objJson = null;
            JSONObject orgJson = null;

            for(Object obj : jsonArray) {
                objJson = JSONObject.parseObject(JSONObject.toJSONString(obj));
                orgJson = objJson.getJSONObject("root");

                allOrgUsers = ztjApisService.queryAllTreeOrgAndUsers(objJson.getString("id"), orgJson.getString("id"));
                if(StringUtils.isNotBlank(allOrgUsers)) {
                    orgJson = JSONObject.parseObject(allOrgUsers);
                    userOrgArr = orgJson.getJSONArray("children");
                    orgName = orgJson.getString("name");

                    users.addAll(parseOrgUseJsonList(userOrgArr, null, orgName, null, null, "-99999", null));
                }
            }
        } else {
            allOrgUsers = ztjApisService.queryAllTreeOrgAndUsers(providerId, orgId);
            String lastNotVirtualPid = null;
            orgName = "";
            JSONObject orgJson = null;
            //当查询组织为部门时，用于判断循环节点是否在该部门树上的父级节点
            List<String> treeIdList = new ArrayList<>();
            //若为虚拟组织机构，则向上查询其最近的非虚拟上级
            JSONArray orgPathJsonArr = ztjApisService.getOrgPath(providerId, orgId);
            if(orgPathJsonArr.size() > 0) {
                JSONObject tmpOrg = null;
                for(Object obj : orgPathJsonArr) {
                    tmpOrg = (JSONObject)obj;
                    if("1".equals(tmpOrg.getString("type")) && !tmpOrg.getBoolean("virtual")) {
                        orgName = tmpOrg.getString("name") + orgName;
                        if(null == lastNotVirtualPid) {
                            lastNotVirtualPid = tmpOrg.getString("id");
                        }
                    }
                    treeIdList.add(tmpOrg.getString("id"));
                }
            }
            if(StringUtils.isNotBlank(deptId)) {
                treeIdList.add(deptId);
            }

            if(StringUtils.isNotBlank(allOrgUsers)) {
                orgJson = JSONObject.parseObject(allOrgUsers);
                userOrgArr = orgJson.getJSONArray("children");
                if(null != userOrgArr) {
                    users.addAll(parseOrgUseJsonList(userOrgArr, deptId, orgName, null, null, providerId, treeIdList));
                }
            }
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", users);
        ExcelExport.getInstance().export("employee-export.xlsx", beans, response);
    }

    public JSONArray getOrgUserInfoCache(String cacheKey) {
        JSONArray resp = new JSONArray();
        String content = cacheManager.hget(ORG_LIST_KEY, cacheKey);
        resp.add(JSON.parseObject(content));
        return resp;
    }

    private void countUser(JSONArray orgUserArr, IPage page) {
        String orgType = null;
        List<UserVO> oneOrgUserList = null;
        JSONObject json = null;

        for(Object obj : orgUserArr) {
            json = (JSONObject) obj;
            orgType = json.get("type").toString();
            switch (orgType) {
                case "1":
                case "2": {
                    if(null != json.get("children")) {
                        countUser(json.getJSONArray("children"), page);
                    }
                    continue;
                }
                case "3": {
                    if(null != json.get("users")) {
                        page.setTotal(page.getTotal() + json.getJSONArray("users").size());
                    }
                    continue;
                }
                default:
                    continue;
            }
        }
    }

    private List<UserVO> parseOrgUseJsonList(List<Object> orgUserArr, String deptId, String orgName, String deptName, IPage page,
                                             String providerId, List<String> treeIds) {
        List<UserVO> userList = new ArrayList<>();
        List<UserVO> tmpList = null;
        long takeNum = 0;

        String orgType = null;
        JSONArray jsonArr = null;
        JSONObject org = null;
        boolean isVirtual = false;

            for(Object obj : orgUserArr) {
                org = (JSONObject) obj;
                orgType = org.getString("type");
                isVirtual = null != org.get("virtual") ? org.getBoolean("virtual") : true;

                //如果查询的为部门下用户，那么如果当前组织节点Id不是指定的部门的父级则跳过
                if(StringUtils.isNotBlank(deptId) && !treeIds.contains(org.getString("id"))) {
                    continue;
                }

                switch (orgType) {
                    //单位
                    case "1":
                        jsonArr = org.getJSONArray("children");
                        if(null != jsonArr) {
                            tmpList = parseOrgUseJsonList(jsonArr, deptId,
                                    isVirtual ? orgName : orgName + org.getString("name"), deptName, page,providerId, treeIds);
                            if(tmpList.size() > 0) {
                                takeNum += tmpList.size();
                                userList.addAll(tmpList);
                            }
                        }
                        continue;
                    case "2": {
                        //部门
                        jsonArr = org.getJSONArray("children");
                        if(null != jsonArr) {
                            //如果当前部门是指定要查询的部门，则将传入的部门Id置为null，从而将该部门下所有用户录入
                            tmpList = parseOrgUseJsonList(jsonArr, org.getString("id").equals(deptId) ? null : deptId, orgName,
                                    StringUtils.isNotBlank(deptName) ? deptName + org.getString("name") : org.getString("name"),
                                    page,providerId, treeIds);
                            if(tmpList.size() > 0) {
                                userList.addAll(tmpList);
                                takeNum += tmpList.size();
                            }
                        }
                        continue;
                    }
                    case "3": {
                        if(null != page) {
                            long start = (page.getCurrent() - 1) * page.getSize();
                            long limit = page.getSize() - (null != page.getRecords() ? page.getRecords().size() : 0);
                            start = start > page.getTotal() ? start - page.getTotal() : 0;
                            long to = start + limit;

                            jsonArr = org.getJSONArray("users");
                            if(null != jsonArr) {
                                page.setTotal(page.getTotal() + jsonArr.size());
                                if(jsonArr.size() < start || limit <= 0) {
                                    continue;
                                }
                                tmpList = new ArrayList<>();
                                Integer postOrder = org.getInteger("order");
                                String postName = org.getString("name");
                                for(Object userObj : jsonArr.subList(Integer.valueOf(start+""), to > jsonArr.size() ? jsonArr.size() : Integer.valueOf(to+""))) {
                                    UserVO vo = pageUsers((JSONObject) userObj, providerId, postOrder, orgName, deptName, postName);
                                    vo.setPositionId(org.getString("id"));
                                    vo.setPositionName(org.getString("name"));
                                    tmpList.add(vo);
                                }
                                page.getRecords().addAll(tmpList);
                                takeNum += tmpList.size();
                            }
                        } else {
                            jsonArr = org.getJSONArray("users");
                            if(null != jsonArr) {
                                Integer postOrder = org.getInteger("order");
                                String postName = org.getString("name");
                                for(Object userObj : jsonArr) {
                                    UserVO vo = pageUsers((JSONObject) userObj, providerId, postOrder, orgName, deptName, postName);
                                    vo.setPositionId(org.getString("id"));
                                    vo.setPositionName(org.getString("name"));
                                    userList.add(vo);
                                }
                            }
                        }
                        continue;
                    }
                    default:
                        continue;
                }
            }

        return userList;
    }

    private UserVO pageUsers(JSONObject userJson, String curProviderId, Integer postOrder, String orgName, String deptName, String postName) {
        UserVO tmp = new UserVO();
        tmp.setType(4);
        tmp.setName(null != userJson.get("name") ? userJson.get("name").toString() : null);
        tmp.setOrder(null != userJson.get("order") ? Integer.valueOf(userJson.get("order").toString()) : 9999);
        tmp.setGender(null != userJson.get("gender") ? Integer.valueOf(userJson.get("gender").toString()) : 1);
        tmp.setCategory(null != userJson.get("category") ? Integer.valueOf(userJson.get("category").toString()) : 101301);
        tmp.setPositionStatus(null != userJson.get("positionStatus") ? Integer.valueOf(userJson.get("positionStatus").toString()) : 101401);
        tmp.setProviderId(curProviderId);
        tmp.setPostOrder(postOrder);
        tmp.setId(IdWorker.getId());
        tmp.setUserId(userJson.getString("id"));
        tmp.setMainPosition(null != userJson.get("mainPosition") ? Boolean.valueOf(userJson.get("mainPosition").toString()) : false);
        if(!tmp.getMainPosition()) {
            System.out.println(JSONObject.toJSONString(tmp));
        }
        tmp.setUniqSymbol(UUID.randomUUID().toString().replace("-",""));
        tmp.setChildren(null);
        tmp.setDeptName(deptName);
        tmp.setOrgName(orgName);
        tmp.setPostName(postName);
        return tmp;
    }
}
