/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.poc.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.CamelAndUnderLineConverter;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.poc.bean.LogEntity;
import com.ejianc.poc.service.ILogService;
import com.ejianc.poc.service.impl.ZtjApisService;
import com.ejianc.poc.vo.BaseFieldVO;
import com.ejianc.poc.vo.DeptVO;
import com.ejianc.poc.vo.LogVO;
import com.ejianc.poc.vo.OrgVO;
import com.ejianc.poc.vo.PostVO;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"log"})
public class LogController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String logId = "436575179625463852";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ILogService service;
    @Autowired
    private ZtjApisService ztjApisService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LogVO> saveOrUpdate(@RequestBody LogVO saveorUpdateVO) {
        LogEntity entity = (LogEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, LogEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        LogVO vo = (LogVO)BeanMapper.map((Object)((Object)entity), LogVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<LogVO> queryDetail(Long id) {
        LogEntity entity = (LogEntity)((Object)this.service.selectById(id));
        LogVO vo = (LogVO)BeanMapper.map((Object)((Object)entity), LogVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LogVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<LogVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        List<BaseFieldVO> tree = this.ztjApisService.getLogTreeRoot();
        if (ListUtil.isEmpty(tree)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01");
        }
        IPage page = null;
        if (tree.size() == 1) {
            BaseFieldVO baseFieldVO = tree.get(0);
            if (baseFieldVO instanceof OrgVO) {
                OrgVO orgVO = (OrgVO)baseFieldVO;
                if (!"root_org_code".equals(orgVO.getCode())) {
                    param.getParams().put("logOrgCode", new Parameter("like_left", (Object)orgVO.getCode()));
                }
            } else if (baseFieldVO instanceof PostVO) {
                PostVO orgVO = (PostVO)baseFieldVO;
                param.getParams().put("logOrgCode", new Parameter("like_left", (Object)orgVO.getCode()));
            } else if (baseFieldVO instanceof DeptVO) {
                DeptVO orgVO = (DeptVO)baseFieldVO;
                param.getParams().put("logOrgCode", new Parameter("like_left", (Object)orgVO.getCode()));
            }
            param.getOrderMap().put("createTime", "desc");
            page = this.service.queryPage(param, false);
        } else {
            page = this.service.queryPageSql(this.getSql(tree, param.getParams()), param.getPageIndex(), param.getPageSize());
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LogVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private String getSql(List<BaseFieldVO> tree, Map<String, Parameter> param) {
        StringBuilder sb = new StringBuilder(" ");
        for (int i = 0; i < tree.size(); ++i) {
            OrgVO orgVO;
            sb.append(" select * from ejc_ztjpoc_sys_log ").append("l").append(i).append(" where l").append(i).append(".dr = 0");
            BaseFieldVO baseFieldVO = tree.get(i);
            if (baseFieldVO instanceof OrgVO) {
                orgVO = (OrgVO)baseFieldVO;
                sb.append(" and  l").append(i).append(".log_org_code like '").append(orgVO.getCode()).append("%' ");
            } else if (baseFieldVO instanceof PostVO) {
                orgVO = (PostVO)baseFieldVO;
                sb.append(" and  l").append(i).append(".log_org_code like '").append(orgVO.getCode()).append("%' ");
            } else if (baseFieldVO instanceof DeptVO) {
                orgVO = (DeptVO)baseFieldVO;
                sb.append(" and  l").append(i).append(".log_org_code like '").append(orgVO.getCode()).append("%' ");
            }
            for (Map.Entry<String, Parameter> entry : param.entrySet()) {
                Parameter parameter = entry.getValue();
                if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) continue;
                sb.append(" and l").append(i).append(".").append(CamelAndUnderLineConverter.humpToLine((String)entry.getKey())).append(" like '%").append(parameter.getValue()).append("%'");
            }
            if (i >= tree.size() - 1) continue;
            sb.append(" union ");
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"exportLogList"})
    public void exportLogList(@RequestBody QueryParam param, HttpServletResponse response) {
        CommonResponse<IPage<LogVO>> commonResponse = this.queryList(param);
        if (!commonResponse.isSuccess()) throw new BusinessException("\u5bfc\u51fa\u5931\u8d25\uff1a" + commonResponse.getMsg());
        IPage page = (IPage)commonResponse.getData();
        List rec = page.getRecords();
        HashMap<String, List> beans = new HashMap<String, List>();
        if (!ListUtil.isNotEmpty((List)rec)) throw new BusinessException("\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e\uff01");
        for (LogVO logVO : rec) {
            logVO.setOpUserId(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)logVO.getCreateTime()));
        }
        beans.put("records", rec);
        ExcelExport.getInstance().export("logs-export.xlsx", beans, response);
    }
}

