package com.ejianc.business.ztpc.billcode.hystrix;

import com.ejianc.business.ztpc.billcode.api.IBillCodeRuleApi;
import com.ejianc.business.ztpc.billcode.bean.BillCodeApiVO;
import com.ejianc.business.ztpc.billcode.bean.BillCodeRuleSNVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
public class BillCodeRuleHystrix implements IBillCodeRuleApi {

    @Override
    public CommonResponse<BillCodeApiVO> generateBillCode(BillCodeApiVO apiVO) {
        return CommonResponse.error("取号失败。");
    }

    @Override
    public CommonResponse commitBillCode(BillCodeApiVO apiVO) {
        return CommonResponse.error("提交号码失败。");
    }

    @Override
    public CommonResponse releaseBillCode(Map<String, Object> generateBillCode) {
        return CommonResponse.error("还号失败。");
    }
}
