package com.ejianc.ztpc.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 施工方案编制计划表
 * 
 * @author generator
 * 
 */
public class ConSchemePlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 项目组织ID
    private String orgCode; // 项目组织编码
    private String orgName; // 项目组织名称
    private Long parentOrgId; // 父级组织ID
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private String billCode; // 文件编码
    private Long engineeringTypeId; // 工程类别
    private String fileName; // 施工方案名称
    private Long projectLeave; // 项目分级(自定义档案)
    private String supervisor; // 监理单位
    private Long chiefEngineerId; // 项目总工
    private String chiefEngineer; // 项目总工名称
    private String designer; // 设计单位
    private Long projectManagementId; // 项目经理id
    private String projectManagementName; // 项目经理
    private Long constructId; // 建设单位id
    private String constructName; // 建设单位
    private String classification; // 专业分类
    private String executeState; // 执行状态
    private String reviewRequirement; // 审查要求
    private String edition; // 版次
    private Long compilePerson; // 编制人
    private String compilePersonName; // 编制人名称
    private Long checkPerson; // 审核人
    private String checkPersonName; // 审核人名称
    private Long approverPerson; // 批准人
    private String approverPersonName; // 批准人名称
    private Long constructionSchemeType; // 施工方案类别
    private Long companyId; // 编制单位
    private String companyName; // 编制单位名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date constructionDate; // 施工时段
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date compileDate; // 编制时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishDate; // 完成时间
    private String engineerCharacters; // 分项工程特点
    private String keyPoints; // 关注要点
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "pro-market-project-001")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }
    @ReferDeserialTransfer
    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }
    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getProjectLeave() {
        return projectLeave;
    }
    @ReferDeserialTransfer
    public void setProjectLeave(Long projectLeave) {
        this.projectLeave = projectLeave;
    }
    public String getSupervisor() {
        return supervisor;
    }

    public void setSupervisor(String supervisor) {
        this.supervisor = supervisor;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getChiefEngineerId() {
        return chiefEngineerId;
    }
    @ReferDeserialTransfer
    public void setChiefEngineerId(Long chiefEngineerId) {
        this.chiefEngineerId = chiefEngineerId;
    }
    public String getChiefEngineer() {
        return chiefEngineer;
    }

    public void setChiefEngineer(String chiefEngineer) {
        this.chiefEngineer = chiefEngineer;
    }
    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectManagementId() {
        return projectManagementId;
    }
    @ReferDeserialTransfer
    public void setProjectManagementId(Long projectManagementId) {
        this.projectManagementId = projectManagementId;
    }
    public String getProjectManagementName() {
        return projectManagementName;
    }

    public void setProjectManagementName(String projectManagementName) {
        this.projectManagementName = projectManagementName;
    }
    @ReferSerialTransfer(referCode="support-customer,support-supplier")
    public Long getConstructId() {
        return constructId;
    }
    @ReferDeserialTransfer
    public void setConstructId(Long constructId) {
        this.constructId = constructId;
    }
    public String getConstructName() {
        return constructName;
    }

    public void setConstructName(String constructName) {
        this.constructName = constructName;
    }
    public String getClassification() {
        return classification;
    }

    public void setClassification(String classification) {
        this.classification = classification;
    }
    public String getExecuteState() {
        return executeState;
    }

    public void setExecuteState(String executeState) {
        this.executeState = executeState;
    }
    public String getReviewRequirement() {
        return reviewRequirement;
    }

    public void setReviewRequirement(String reviewRequirement) {
        this.reviewRequirement = reviewRequirement;
    }
    public String getEdition() {
        return edition;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getCompilePerson() {
        return compilePerson;
    }
    @ReferDeserialTransfer
    public void setCompilePerson(Long compilePerson) {
        this.compilePerson = compilePerson;
    }
    public String getCompilePersonName() {
        return compilePersonName;
    }

    public void setCompilePersonName(String compilePersonName) {
        this.compilePersonName = compilePersonName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getCheckPerson() {
        return checkPerson;
    }
    @ReferDeserialTransfer
    public void setCheckPerson(Long checkPerson) {
        this.checkPerson = checkPerson;
    }
    public String getCheckPersonName() {
        return checkPersonName;
    }

    public void setCheckPersonName(String checkPersonName) {
        this.checkPersonName = checkPersonName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getApproverPerson() {
        return approverPerson;
    }
    @ReferDeserialTransfer
    public void setApproverPerson(Long approverPerson) {
        this.approverPerson = approverPerson;
    }
    public String getApproverPersonName() {
        return approverPersonName;
    }

    public void setApproverPersonName(String approverPersonName) {
        this.approverPersonName = approverPersonName;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getConstructionSchemeType() {
        return constructionSchemeType;
    }
    @ReferDeserialTransfer
    public void setConstructionSchemeType(Long constructionSchemeType) {
        this.constructionSchemeType = constructionSchemeType;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getCompanyId() {
        return companyId;
    }
    @ReferDeserialTransfer
    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public Date getConstructionDate() {
        return constructionDate;
    }

    public void setConstructionDate(Date constructionDate) {
        this.constructionDate = constructionDate;
    }
    public Date getCompileDate() {
        return compileDate;
    }

    public void setCompileDate(Date compileDate) {
        this.compileDate = compileDate;
    }
    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }
    public String getEngineerCharacters() {
        return engineerCharacters;
    }

    public void setEngineerCharacters(String engineerCharacters) {
        this.engineerCharacters = engineerCharacters;
    }
    public String getKeyPoints() {
        return keyPoints;
    }

    public void setKeyPoints(String keyPoints) {
        this.keyPoints = keyPoints;
    }
    
}
