package com.ejianc.ztpc.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 施工组织设计表
 * 
 * @author generator
 * 
 */
public class CtConOrgDesignVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 项目组织ID
    private String orgCode; // 项目组织编码
    private String orgName; // 项目组织名称
    private Long parentOrgId; // 父级组织ID
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private String code; // 单据编码
    private String name; // 单据名称
    private Long engineeringTypeId; // 工程类别
    private Long projectLeave; // 项目分级(自定义档案)
    private Long compilePerson; // 编制人
    private String compilePersonName; // 编制人名称
    private Long approverPerson; // 批准人
    private String approverPersonName; // 批准人名称
    private Long orgDesignPlanId; // 施工组织设计清单id
    private String orgDesignPlanName; // 施工组织设计清单name
    private Long conOrgDesignType; // 施工组织设计类型--字典ct_design_plan_type
    private String textAttachment; // 正文附件
    private Long projectManageType; // 项目管理分类--字典ct_project_manage_type
    private String state; // 状态
    private String stateName; // 状态名称
    private String fileState; // 文件状态（Y：有效，N：无效）
    private Integer fileVersion; // 文件版本

    private List<OpinionInfoVO> opinionInfoList; // 意见栏
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "pro-market-project-001")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }

    @ReferDeserialTransfer
    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getProjectLeave() {
        return projectLeave;
    }

    @ReferDeserialTransfer
    public void setProjectLeave(Long projectLeave) {
        this.projectLeave = projectLeave;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getCompilePerson() {
        return compilePerson;
    }

    @ReferDeserialTransfer
    public void setCompilePerson(Long compilePerson) {
        this.compilePerson = compilePerson;
    }
    public String getCompilePersonName() {
        return compilePersonName;
    }

    public void setCompilePersonName(String compilePersonName) {
        this.compilePersonName = compilePersonName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getApproverPerson() {
        return approverPerson;
    }

    @ReferDeserialTransfer
    public void setApproverPerson(Long approverPerson) {
        this.approverPerson = approverPerson;
    }
    public String getApproverPersonName() {
        return approverPersonName;
    }

    public void setApproverPersonName(String approverPersonName) {
        this.approverPersonName = approverPersonName;
    }
    @ReferSerialTransfer(referCode="org-design-plan-ref")
    public Long getOrgDesignPlanId() {
        return orgDesignPlanId;
    }

    @ReferDeserialTransfer
    public void setOrgDesignPlanId(Long orgDesignPlanId) {
        this.orgDesignPlanId = orgDesignPlanId;
    }
    public String getOrgDesignPlanName() {
        return orgDesignPlanName;
    }

    public void setOrgDesignPlanName(String orgDesignPlanName) {
        this.orgDesignPlanName = orgDesignPlanName;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getConOrgDesignType() {
        return conOrgDesignType;
    }

    @ReferDeserialTransfer
    public void setConOrgDesignType(Long conOrgDesignType) {
        this.conOrgDesignType = conOrgDesignType;
    }
    public String getTextAttachment() {
        return textAttachment;
    }

    public void setTextAttachment(String textAttachment) {
        this.textAttachment = textAttachment;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getProjectManageType() {
        return projectManageType;
    }

    @ReferDeserialTransfer
    public void setProjectManageType(Long projectManageType) {
        this.projectManageType = projectManageType;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getStateName() {
        return stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public List<OpinionInfoVO> getOpinionInfoList() {
        return opinionInfoList;
    }

    public void setOpinionInfoList(List<OpinionInfoVO> opinionInfoList) {
        this.opinionInfoList = opinionInfoList;
    }

    public String getFileState() {
        return fileState;
    }

    public void setFileState(String fileState) {
        this.fileState = fileState;
    }

    public Integer getFileVersion() {
        return fileVersion;
    }

    public void setFileVersion(Integer fileVersion) {
        this.fileVersion = fileVersion;
    }
}
