package com.ejianc.ztpc.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 图纸会检表
 * 
 * @author generator
 * 
 */
public class DrawingCheckVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 项目组织ID
    private String orgCode; // 项目组织编码
    private String orgName; // 项目组织名称
    private Long parentOrgId; // 父级组织ID
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private String billCode; // 文件编码
    private Long engineeringTypeId; // 工程类别
    private Long projectLeave; // 项目分级(自定义档案)
    private String supervisor; // 监理单位
    private Long chiefEngineerId; // 项目总工
    private String chiefEngineer; // 项目总工名称
    private String designer; // 设计单位
    private Long projectManagementId; // 项目经理id
    private String projectManagementName; // 项目经理
    private Long constructId; // 建设单位id
    private String constructName; // 建设单位
    private String memo; // 工程范围
    private String classification; // 专业分类
    private String edition; // 版次
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date arriveDate; // 到图日期
    private String drawingCheck; // 图纸会检
    private String drawingNumber; // 图纸号
    private String drawingName; // 图纸名称
    private String drawingType; // 图纸类型
    private String drawingVersion; // 图纸版本
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "pro-market-project-001")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }
    @ReferDeserialTransfer
    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getProjectLeave() {
        return projectLeave;
    }
    @ReferDeserialTransfer
    public void setProjectLeave(Long projectLeave) {
        this.projectLeave = projectLeave;
    }
    public String getSupervisor() {
        return supervisor;
    }

    public void setSupervisor(String supervisor) {
        this.supervisor = supervisor;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getChiefEngineerId() {
        return chiefEngineerId;
    }
    @ReferDeserialTransfer
    public void setChiefEngineerId(Long chiefEngineerId) {
        this.chiefEngineerId = chiefEngineerId;
    }
    public String getChiefEngineer() {
        return chiefEngineer;
    }

    public void setChiefEngineer(String chiefEngineer) {
        this.chiefEngineer = chiefEngineer;
    }
    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectManagementId() {
        return projectManagementId;
    }
    @ReferDeserialTransfer
    public void setProjectManagementId(Long projectManagementId) {
        this.projectManagementId = projectManagementId;
    }
    public String getProjectManagementName() {
        return projectManagementName;
    }

    public void setProjectManagementName(String projectManagementName) {
        this.projectManagementName = projectManagementName;
    }
    @ReferSerialTransfer(referCode="support-customer,support-supplier")
    public Long getConstructId() {
        return constructId;
    }
    @ReferDeserialTransfer
    public void setConstructId(Long constructId) {
        this.constructId = constructId;
    }
    public String getConstructName() {
        return constructName;
    }

    public void setConstructName(String constructName) {
        this.constructName = constructName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getClassification() {
        return classification;
    }

    public void setClassification(String classification) {
        this.classification = classification;
    }
    public String getEdition() {
        return edition;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }
    public Date getArriveDate() {
        return arriveDate;
    }

    public void setArriveDate(Date arriveDate) {
        this.arriveDate = arriveDate;
    }
    public String getDrawingCheck() {
        return drawingCheck;
    }

    public void setDrawingCheck(String drawingCheck) {
        this.drawingCheck = drawingCheck;
    }
    public String getDrawingNumber() {
        return drawingNumber;
    }

    public void setDrawingNumber(String drawingNumber) {
        this.drawingNumber = drawingNumber;
    }
    public String getDrawingName() {
        return drawingName;
    }

    public void setDrawingName(String drawingName) {
        this.drawingName = drawingName;
    }
    public String getDrawingType() {
        return drawingType;
    }

    public void setDrawingType(String drawingType) {
        this.drawingType = drawingType;
    }
    public String getDrawingVersion() {
        return drawingVersion;
    }

    public void setDrawingVersion(String drawingVersion) {
        this.drawingVersion = drawingVersion;
    }
    
}
