package com.ejianc.ztpc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.ztpc.bean.ConOrgDesignPlanEntity;
import com.ejianc.ztpc.bean.CtConOrgDesignEntity;
import com.ejianc.ztpc.enumUtils.ConOrgDesignStateEnum;
import com.ejianc.ztpc.service.IConOrgDesignPlanService;
import com.ejianc.ztpc.service.ICtConOrgDesignService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Objects;

@Service("ctConOrgDesign")
public class CtConOrgDesignBpmServiceImpl implements ICommonBusinessService {
    /**
     * 日志
     */
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IConOrgDesignPlanService conOrgDesignPlanService;
    @Autowired
    private ICtConOrgDesignService ctConOrgDesignService;
    @Autowired
    private SessionManager sessionManager;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        if (logger.isInfoEnabled()) {
            logger.info("afterSubmitProcessor，开始回写状态，billId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode);
        }
        CtConOrgDesignEntity entity = ctConOrgDesignService.selectById(billId);
        if (Objects.isNull(entity)) {
            return CommonResponse.error("单据信息未找到！");
        }
        /*
         * 施工组织设计清单-更改状态为“正在编制”
         */
        conOrgDesignPlanService.update(
                new UpdateWrapper<ConOrgDesignPlanEntity>()
                        .lambda()
                        .set(ConOrgDesignPlanEntity::getState, ConOrgDesignStateEnum.ONE.getCode())
                        .set(ConOrgDesignPlanEntity::getStateName, ConOrgDesignStateEnum.ONE.getName())
                        .eq(ConOrgDesignPlanEntity::getDr, 0)
                        .eq(ConOrgDesignPlanEntity::getId, entity.getOrgDesignPlanId())
        );
        /*
         * 施工组织设计-更改状态为“正在编制”
         */
        ctConOrgDesignService.update(
                new UpdateWrapper<CtConOrgDesignEntity>()
                        .lambda()
                        .set(CtConOrgDesignEntity::getState, ConOrgDesignStateEnum.ONE.getCode())
                        .set(CtConOrgDesignEntity::getStateName, ConOrgDesignStateEnum.ONE.getName())
                        .eq(CtConOrgDesignEntity::getDr, 0)
                        .eq(CtConOrgDesignEntity::getId, entity.getId())
        );
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        if (logger.isInfoEnabled()) {
            logger.info("afterHasBpmBack，开始回写状态，billId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode);
        }
        CtConOrgDesignEntity entity = ctConOrgDesignService.selectById(billId);
        if (Objects.isNull(entity)) {
            return CommonResponse.error("单据信息未找到！");
        }
        /*
         * 施工组织设计清单-更改状态为“正在编制”
         */
        conOrgDesignPlanService.update(
                new UpdateWrapper<ConOrgDesignPlanEntity>()
                        .lambda()
                        .set(ConOrgDesignPlanEntity::getState, ConOrgDesignStateEnum.ONE.getCode())
                        .set(ConOrgDesignPlanEntity::getStateName, ConOrgDesignStateEnum.ONE.getName())
                        .eq(ConOrgDesignPlanEntity::getDr, 0)
                        .eq(ConOrgDesignPlanEntity::getId, entity.getOrgDesignPlanId())
        );
        /*
         * 施工组织设计-更改状态为“正在编制”
         */
        ctConOrgDesignService.update(
                new UpdateWrapper<CtConOrgDesignEntity>()
                        .lambda()
                        .set(CtConOrgDesignEntity::getState, ConOrgDesignStateEnum.ONE.getCode())
                        .set(CtConOrgDesignEntity::getStateName, ConOrgDesignStateEnum.ONE.getName())
                        .eq(CtConOrgDesignEntity::getDr, 0)
                        .eq(CtConOrgDesignEntity::getId, entity.getId())
        );
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId       //单据id
     * @param state        //单据状态
     * @param billTypeCode //单据类型code
     * @param taskId       //该流程id
     * @param isEnd        //该节点是否结束
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        if (logger.isInfoEnabled()) {
            logger.info("afterInApprovalBack，开始回写状态，billId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode +
                    "   taskId:" + taskId + "   isEnd:" + isEnd + "   sign:" + sign + "   other:" + JSONObject.toJSONString(other));
        }
        CtConOrgDesignEntity entity = ctConOrgDesignService.selectById(billId);
        if (Objects.isNull(entity)) {
            return CommonResponse.error("单据信息未找到！");
        }
        if ("fqr_node".equals(sign)) {
            /*
             * 施工组织设计清单-更改状态为“已编制”
             */
            conOrgDesignPlanService.update(
                    new UpdateWrapper<ConOrgDesignPlanEntity>()
                            .lambda()
                            .set(ConOrgDesignPlanEntity::getState, ConOrgDesignStateEnum.TWO.getCode())
                            .set(ConOrgDesignPlanEntity::getStateName, ConOrgDesignStateEnum.TWO.getName())
                            .eq(ConOrgDesignPlanEntity::getDr, 0)
                            .eq(ConOrgDesignPlanEntity::getId, entity.getOrgDesignPlanId())
            );
            /*
             * 施工组织设计-更改状态为“已编制”
             */
            ctConOrgDesignService.update(
                    new UpdateWrapper<CtConOrgDesignEntity>()
                            .lambda()
                            .set(CtConOrgDesignEntity::getState, ConOrgDesignStateEnum.TWO.getCode())
                            .set(CtConOrgDesignEntity::getStateName, ConOrgDesignStateEnum.TWO.getName())
                            .set(CtConOrgDesignEntity::getCompilePerson, sessionManager.getUserContext().getUserId())
                            .set(CtConOrgDesignEntity::getCompilePersonName, sessionManager.getUserContext().getUserName())
                            .eq(CtConOrgDesignEntity::getDr, 0)
                            .eq(CtConOrgDesignEntity::getId, entity.getId())
            );
        }
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (logger.isInfoEnabled()) {
            logger.info("afterApprovalProcessor，开始回写状态，billId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode);
        }
        CtConOrgDesignEntity entity = ctConOrgDesignService.selectById(billId);
        if (Objects.isNull(entity)) {
            return CommonResponse.error("单据信息未找到！");
        }
        /*
         * 施工组织设计清单-更改状态为“批准生效”
         */
        conOrgDesignPlanService.update(
                new UpdateWrapper<ConOrgDesignPlanEntity>()
                        .lambda()
                        .set(ConOrgDesignPlanEntity::getState, ConOrgDesignStateEnum.THREE.getCode())
                        .set(ConOrgDesignPlanEntity::getStateName, ConOrgDesignStateEnum.THREE.getName())
                        .eq(ConOrgDesignPlanEntity::getDr, 0)
                        .eq(ConOrgDesignPlanEntity::getId, entity.getOrgDesignPlanId())
        );
        /*
         * 施工组织设计-更改状态为“批准生效”
         */
        ctConOrgDesignService.update(
                new UpdateWrapper<CtConOrgDesignEntity>()
                        .lambda()
                        .set(CtConOrgDesignEntity::getState, ConOrgDesignStateEnum.THREE.getCode())
                        .set(CtConOrgDesignEntity::getStateName, ConOrgDesignStateEnum.THREE.getName())
                        .set(CtConOrgDesignEntity::getApproverPerson, sessionManager.getUserContext().getUserId())
                        .set(CtConOrgDesignEntity::getApproverPersonName, sessionManager.getUserContext().getUserName())
                        .set(CtConOrgDesignEntity::getFileState, "Y")
                        .eq(CtConOrgDesignEntity::getDr, 0)
                        .eq(CtConOrgDesignEntity::getId, entity.getId())
        );
        /*
         * 更新旧版数据的文件状态为”无效“
         */
        CtConOrgDesignEntity oldEntity = ctConOrgDesignService.getOne(
                new QueryWrapper<CtConOrgDesignEntity>()
                        .lambda()
                        .eq(CtConOrgDesignEntity::getDr, 0)
                        .eq(CtConOrgDesignEntity::getOrgDesignPlanId, entity.getOrgDesignPlanId())
                        .ne(CtConOrgDesignEntity::getId, entity.getId())
                        .orderByDesc(CtConOrgDesignEntity::getCreateTime)
                        .last("LIMIT 1")
        );
        if (Objects.nonNull(oldEntity)) {
            ctConOrgDesignService.update(
                    new UpdateWrapper<CtConOrgDesignEntity>()
                            .lambda()
                            .set(CtConOrgDesignEntity::getFileState, "N")
                            .eq(CtConOrgDesignEntity::getId, oldEntity.getId())
            );
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
