package com.ejianc.ztpc.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 项目交底表
 * 
 * @author generator
 * 
 */
public class ProjectDisclosureVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 编码
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 项目组织ID
    private String orgCode; // 项目组织编码
    private String orgName; // 项目组织名称
    private Long parentOrgId; // 父级组织ID
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private Long consSchemeId; // 施工方案ID
    private String consSchemeCode; // 施工方案编码
    private String consSchemeName; // 施工方案名称
    private String consSchemeFileVersion; // 施工方案文件版次
    private String internalCode; // 内部编码
    private Long mgrp; // 机组--字典mgrp
    private Long specialty; // 专业--字典specialty
    private Long buildUnit; // 施工单位
    private Long buildLeader; // 施工负责人
    private Long redactUser; // 编制人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date redactDate; // 编制日期
    private Long auditUser; // 审核人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date auditDate; // 审核日期
    private String place; // 地点
    private String disclosureName; // 交底名称
    private Long disclosureType; // 交底类型
    private String disclosureVersion; // 交底版本
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date disclosureDate; // 交底时间
    private Long disclosureUser; // 交底人
    private Long byDisclosureDept; // 被交底部门/班组
    private String remark; // 备注
    private String disclosureRecordFile; // 交底记录附件
    private Long engineeringTypeId; // 工程类别
    private Long projectLeave; // 项目分级(自定义档案)
    

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode = "construction-scheme-ref")
    public Long getConsSchemeId() {
        return consSchemeId;
    }

    @ReferDeserialTransfer
    public void setConsSchemeId(Long consSchemeId) {
        this.consSchemeId = consSchemeId;
    }
    public String getConsSchemeCode() {
        return consSchemeCode;
    }

    public void setConsSchemeCode(String consSchemeCode) {
        this.consSchemeCode = consSchemeCode;
    }
    public String getConsSchemeName() {
        return consSchemeName;
    }

    public void setConsSchemeName(String consSchemeName) {
        this.consSchemeName = consSchemeName;
    }
    public String getConsSchemeFileVersion() {
        return consSchemeFileVersion;
    }

    public void setConsSchemeFileVersion(String consSchemeFileVersion) {
        this.consSchemeFileVersion = consSchemeFileVersion;
    }
    public String getInternalCode() {
        return internalCode;
    }

    public void setInternalCode(String internalCode) {
        this.internalCode = internalCode;
    }
    @ReferSerialTransfer(referCode = "data-dictionary")
    public Long getMgrp() {
        return mgrp;
    }

    @ReferDeserialTransfer
    public void setMgrp(Long mgrp) {
        this.mgrp = mgrp;
    }
    @ReferSerialTransfer(referCode = "data-dictionary")
    public Long getSpecialty() {
        return specialty;
    }

    @ReferDeserialTransfer
    public void setSpecialty(Long specialty) {
        this.specialty = specialty;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getBuildUnit() {
        return buildUnit;
    }

    @ReferDeserialTransfer
    public void setBuildUnit(Long buildUnit) {
        this.buildUnit = buildUnit;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getBuildLeader() {
        return buildLeader;
    }

    @ReferDeserialTransfer
    public void setBuildLeader(Long buildLeader) {
        this.buildLeader = buildLeader;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getRedactUser() {
        return redactUser;
    }

    @ReferDeserialTransfer
    public void setRedactUser(Long redactUser) {
        this.redactUser = redactUser;
    }
    public Date getRedactDate() {
        return redactDate;
    }

    public void setRedactDate(Date redactDate) {
        this.redactDate = redactDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getAuditUser() {
        return auditUser;
    }

    @ReferDeserialTransfer
    public void setAuditUser(Long auditUser) {
        this.auditUser = auditUser;
    }
    public Date getAuditDate() {
        return auditDate;
    }

    public void setAuditDate(Date auditDate) {
        this.auditDate = auditDate;
    }
    public String getPlace() {
        return place;
    }

    public void setPlace(String place) {
        this.place = place;
    }
    public String getDisclosureName() {
        return disclosureName;
    }

    public void setDisclosureName(String disclosureName) {
        this.disclosureName = disclosureName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getDisclosureType() {
        return disclosureType;
    }

    @ReferDeserialTransfer
    public void setDisclosureType(Long disclosureType) {
        this.disclosureType = disclosureType;
    }
    public String getDisclosureVersion() {
        return disclosureVersion;
    }

    public void setDisclosureVersion(String disclosureVersion) {
        this.disclosureVersion = disclosureVersion;
    }
    public Date getDisclosureDate() {
        return disclosureDate;
    }

    public void setDisclosureDate(Date disclosureDate) {
        this.disclosureDate = disclosureDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getDisclosureUser() {
        return disclosureUser;
    }

    @ReferDeserialTransfer
    public void setDisclosureUser(Long disclosureUser) {
        this.disclosureUser = disclosureUser;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getByDisclosureDept() {
        return byDisclosureDept;
    }

    @ReferDeserialTransfer
    public void setByDisclosureDept(Long byDisclosureDept) {
        this.byDisclosureDept = byDisclosureDept;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getDisclosureRecordFile() {
        return disclosureRecordFile;
    }

    public void setDisclosureRecordFile(String disclosureRecordFile) {
        this.disclosureRecordFile = disclosureRecordFile;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }

    @ReferDeserialTransfer
    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProjectLeave() {
        return projectLeave;
    }

    @ReferDeserialTransfer
    public void setProjectLeave(Long projectLeave) {
        this.projectLeave = projectLeave;
    }
}
