package com.ejianc.ztpc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.ztpc.bean.ConSchemePlanEntity;
import com.ejianc.ztpc.bean.ConstructionSchemeEntity;
import com.ejianc.ztpc.bean.CtConOrgDesignEntity;
import com.ejianc.ztpc.enumUtils.ConOrgDesignStateEnum;
import com.ejianc.ztpc.service.IConSchemePlanService;
import com.ejianc.ztpc.service.IConstructionSchemeService;
import com.ejianc.ztpc.vo.ConOrgDesignPlanVO;
import com.ejianc.ztpc.vo.ConSchemePlanImportVO;
import com.ejianc.ztpc.vo.ConSchemePlanVO;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 施工方案编制计划表
 *
 * @author generator
 */
@Controller
@RequestMapping("conSchemePlan")
public class ConSchemePlanController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IConSchemePlanService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IConstructionSchemeService constructionSchemeService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ConSchemePlanVO> saveOrUpdate(@RequestBody ConSchemePlanVO saveOrUpdateVO) {
        // 施工时段
        if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getConsTimeFrameList())) {
            saveOrUpdateVO.setConsTimeFrame(saveOrUpdateVO.getConsTimeFrameList().get(0) + "~" + saveOrUpdateVO.getConsTimeFrameList().get(1));
        }
        ConSchemePlanEntity entity = BeanMapper.map(saveOrUpdateVO, ConSchemePlanEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        ConSchemePlanVO vo = BeanMapper.map(entity, ConSchemePlanVO.class);
        // 施工时段
        if (StringUtils.isNotBlank(vo.getConsTimeFrame())) {
            vo.setConsTimeFrameList(Arrays.asList(vo.getConsTimeFrame().split("~")));
        }
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConSchemePlanVO> queryDetail(Long id) {
        ConSchemePlanEntity entity = service.selectById(id);
        ConSchemePlanVO vo = BeanMapper.map(entity, ConSchemePlanVO.class);
        // 施工时段
        if (StringUtils.isNotBlank(vo.getConsTimeFrame())) {
            vo.setConsTimeFrameList(Arrays.asList(vo.getConsTimeFrame().split("~")));
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConSchemePlanVO> vos) {
        List<Long> ids = vos.stream().map(ConSchemePlanVO::getId).collect(Collectors.toList());
        List<ConstructionSchemeEntity> constructionSchemeList = constructionSchemeService.list(
                new QueryWrapper<ConstructionSchemeEntity>()
                        .lambda()
                        .eq(ConstructionSchemeEntity::getDr, 0)
                        .in(ConstructionSchemeEntity::getConsSchemeId, ids)
        );
        if (CollectionUtils.isNotEmpty(constructionSchemeList)) {
            return CommonResponse.error("删除失败！不能删除已经被施工方案引用的数据。");
        }
        service.removeByIds(vos.stream().map(ConSchemePlanVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ConSchemePlanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("consSchemeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ConSchemePlanEntity> page = service.queryPage(param, false);
        IPage<ConSchemePlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConSchemePlanVO.class));
        pageData.getRecords().forEach(a -> {
            try {
                // 施工时段
                if (StringUtils.isNotBlank(a.getConsTimeFrame())) {
                    String startDate = DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(
                            DateUtils.parseDate(a.getConsTimeFrame().split("~")[0], "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
                    );
                    String endDate = DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(
                            DateUtils.parseDate(a.getConsTimeFrame().split("~")[1], "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
                    );
                    a.setConsTimeFrameList(Arrays.asList(a.getConsTimeFrame().split("~")));
                    a.setConsTimeFrame(startDate + "~" + endDate);
                }
            } catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("施工方案编辑计划清单 转换施工时段 失败！");
                }
            }
        });
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ConSchemePlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ConSchemePlan-export.xlsx", beans, response);
    }

    /**
     * 参照
     *
     * @param pageNumber   页码
     * @param pageSize     每页条数
     * @param condition    相关参数
     * @param searchObject 单独表字段搜索参数
     * @param searchText   查询关键字
     * @return 返回结果
     */
    @RequestMapping(value = "/refConSchemePlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ConSchemePlanVO>> refConSchemePlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (Objects.nonNull(_con.get("projectId"))) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
        }
        // 状态为空、null、正在编制、已编制
        param.getParams().put("state", new Parameter(QueryParam.SQL, "(execute_state IS NULL OR execute_state = '' OR execute_state = " + ConOrgDesignStateEnum.ONE.getCode() + " OR execute_state = " + ConOrgDesignStateEnum.TWO.getCode() + ")"));

        IPage<ConSchemePlanEntity> page = service.queryPage(param, false);
        IPage<ConSchemePlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConSchemePlanVO.class));
        pageData.getRecords().forEach(a -> {
            try {
                // 施工时段
                if (StringUtils.isNotBlank(a.getConsTimeFrame())) {
                    String startDate = DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(
                            DateUtils.parseDate(a.getConsTimeFrame().split("~")[0], "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
                    );
                    String endDate = DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(
                            DateUtils.parseDate(a.getConsTimeFrame().split("~")[1], "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
                    );
                    a.setConsTimeFrameList(Arrays.asList(a.getConsTimeFrame().split("~")));
                    a.setConsTimeFrame(startDate + "~" + endDate);
                }
            } catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("施工方案编辑计划清单 转换施工时段 失败！");
                }
            }
        });
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 卷册信息导入模板下载
     *
     * @param request  请求头对象
     * @param response 返回体对象
     */
    @RequestMapping(value = "/downloadConSchemePlanTemplate")
    @ResponseBody
    public void downloadConSchemePlanTemplate(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "con-scheme-plan-import.xlsx", "施工方案编制计划清单导入模板");
    }

    /**
     * 导入-校验数据
     *
     * @param request 请求头对象
     * @return 返回对象
     */
    @RequestMapping(value = "/excelConSchemePlanImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelConSchemePlanImport(HttpServletRequest request) {
        return service.excelConSchemePlanImport(request);
    }

    /**
     * 导入-保存
     *
     * @param importVos 待保存的数据
     * @return
     */
    @RequestMapping(value = "/saveImportExcelConSchemePlan", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Void> saveImportExcelConSchemePlan(@RequestBody List<ConSchemePlanImportVO> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error("导入的数据为空！");
        }
        List<ConSchemePlanEntity> list = Lists.newArrayList();

        importVos.forEach(importVO -> {
            /*
             * 施工时段 补充日期格式
             */
            String startDate = importVO.getConsTimeFrameList().get(0) + "T16:00:00.000Z";
            String endDate = importVO.getConsTimeFrameList().get(1) + "T16:00:00.000Z";
            importVO.setConsTimeFrame(startDate + "~" + endDate);
            ConSchemePlanEntity entity = BeanMapper.map(importVO, ConSchemePlanEntity.class);
            entity.setId(IdWorker.getId());
            /*
             * 生成单据编码
             */
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), importVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            list.add(entity);
        });
        // 保存
        service.saveBatch(list, list.size());
        return CommonResponse.success("保存成功！");
    }
}
