package com.ejianc.ztpc.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;
import java.util.List;


/**
 * 施工方案表
 *
 * @author generator
 */
public class ConstructionSchemeVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String code; // 编码
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 项目组织ID
    private String orgCode; // 项目组织编码
    private String orgName; // 项目组织名称
    private Long parentOrgId; // 父级组织ID
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private Long consSchemeId; // 施工方案ID
    private String consSchemeName; // 施工方案名称
    private Long consSchemeType; // 施工方案类别--字典ct_cons_scheme_type
    private Long engineeringTypeId; // 工程类别
    private Long specialtyType; // 专业分类--字典ct_specialty_type
    private Long projectLeave; // 项目分级(自定义档案)
    private String executeState; // 执行状态
    private String executeStateName; // 执行状态名称
    private Long approvalPower; // 批准权限
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planRedactDate; // 计划编制时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date redactFinishDate; // 编制完成时间
    private String orgExpertExamine; // 组织专家审查要求（Y：是，N：否）
    private String consTimeFrame; // 施工时段
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishConsSchemeDate; // 完成施工方案时间
    private Long projectTrait; // 分部分项工程特征--字典ct_project_trait
    private String keyPointExplain; // 专项施工方案关注重点
    private String fileVersion; // 文件版次
    private String textAttachment; // 正文附件
    private Long projectManageType; // 项目管理分类--字典ct_project_manage_type
    private String fileState; // 文件状态（Y：有效，N：无效）
    private String expertArgumentFile; // 专项方案专家论证报告附件
    private Long certificationNoticeFileId;//认证通知附件id
    private Long certificationQualificationsFileId;//认证资质附件id
    private Long certificationReportFileId;//认证报告附件id
    private Long certificationOpinionFileId;//认证意见附件id
    private Long certifiedConstructionPlanFileId;//认证后施工方案附件id
    private Long otherAttachmentFileId;//其他附件id

    private List<String> consTimeFrameList; // 施工时段数组

    private List<OpinionInfoVO> opinionInfoList; // 意见栏

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getConsSchemeName() {
        return consSchemeName;
    }

    public void setConsSchemeName(String consSchemeName) {
        this.consSchemeName = consSchemeName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getConsSchemeType() {
        return consSchemeType;
    }

    @ReferDeserialTransfer
    public void setConsSchemeType(Long consSchemeType) {
        this.consSchemeType = consSchemeType;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }

    @ReferDeserialTransfer
    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getSpecialtyType() {
        return specialtyType;
    }

    @ReferDeserialTransfer
    public void setSpecialtyType(Long specialtyType) {
        this.specialtyType = specialtyType;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProjectLeave() {
        return projectLeave;
    }

    @ReferDeserialTransfer
    public void setProjectLeave(Long projectLeave) {
        this.projectLeave = projectLeave;
    }

    public String getExecuteState() {
        return executeState;
    }

    public void setExecuteState(String executeState) {
        this.executeState = executeState;
    }

    public String getExecuteStateName() {
        return executeStateName;
    }

    public void setExecuteStateName(String executeStateName) {
        this.executeStateName = executeStateName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getApprovalPower() {
        return approvalPower;
    }

    @ReferDeserialTransfer
    public void setApprovalPower(Long approvalPower) {
        this.approvalPower = approvalPower;
    }

    public Date getPlanRedactDate() {
        return planRedactDate;
    }

    public void setPlanRedactDate(Date planRedactDate) {
        this.planRedactDate = planRedactDate;
    }

    public Date getRedactFinishDate() {
        return redactFinishDate;
    }

    public void setRedactFinishDate(Date redactFinishDate) {
        this.redactFinishDate = redactFinishDate;
    }

    public String getOrgExpertExamine() {
        return orgExpertExamine;
    }

    public void setOrgExpertExamine(String orgExpertExamine) {
        this.orgExpertExamine = orgExpertExamine;
    }

    public String getConsTimeFrame() {
        return consTimeFrame;
    }

    public void setConsTimeFrame(String consTimeFrame) {
        this.consTimeFrame = consTimeFrame;
    }

    public Date getFinishConsSchemeDate() {
        return finishConsSchemeDate;
    }

    public void setFinishConsSchemeDate(Date finishConsSchemeDate) {
        this.finishConsSchemeDate = finishConsSchemeDate;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProjectTrait() {
        return projectTrait;
    }

    @ReferDeserialTransfer
    public void setProjectTrait(Long projectTrait) {
        this.projectTrait = projectTrait;
    }

    public String getKeyPointExplain() {
        return keyPointExplain;
    }

    public void setKeyPointExplain(String keyPointExplain) {
        this.keyPointExplain = keyPointExplain;
    }

    @ReferSerialTransfer(referCode = "con-scheme-plan-ref")
    public Long getConsSchemeId() {
        return consSchemeId;
    }

    @ReferDeserialTransfer
    public void setConsSchemeId(Long consSchemeId) {
        this.consSchemeId = consSchemeId;
    }

    public String getFileVersion() {
        return fileVersion;
    }

    public void setFileVersion(String fileVersion) {
        this.fileVersion = fileVersion;
    }

    public String getTextAttachment() {
        return textAttachment;
    }

    public void setTextAttachment(String textAttachment) {
        this.textAttachment = textAttachment;
    }

    public List<String> getConsTimeFrameList() {
        return consTimeFrameList;
    }

    public void setConsTimeFrameList(List<String> consTimeFrameList) {
        this.consTimeFrameList = consTimeFrameList;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProjectManageType() {
        return projectManageType;
    }

    @ReferDeserialTransfer
    public void setProjectManageType(Long projectManageType) {
        this.projectManageType = projectManageType;
    }

    public List<OpinionInfoVO> getOpinionInfoList() {
        return opinionInfoList;
    }

    public void setOpinionInfoList(List<OpinionInfoVO> opinionInfoList) {
        this.opinionInfoList = opinionInfoList;
    }

    public String getFileState() {
        return fileState;
    }

    public void setFileState(String fileState) {
        this.fileState = fileState;
    }

    public String getExpertArgumentFile() {
        return expertArgumentFile;
    }

    public void setExpertArgumentFile(String expertArgumentFile) {
        this.expertArgumentFile = expertArgumentFile;
    }

    public Long getCertificationNoticeFileId() {
        return certificationNoticeFileId;
    }

    public void setCertificationNoticeFileId(Long certificationNoticeFileId) {
        this.certificationNoticeFileId = certificationNoticeFileId;
    }

    public Long getCertificationQualificationsFileId() {
        return certificationQualificationsFileId;
    }

    public void setCertificationQualificationsFileId(Long certificationQualificationsFileId) {
        this.certificationQualificationsFileId = certificationQualificationsFileId;
    }

    public Long getCertificationReportFileId() {
        return certificationReportFileId;
    }

    public void setCertificationReportFileId(Long certificationReportFileId) {
        this.certificationReportFileId = certificationReportFileId;
    }

    public Long getCertificationOpinionFileId() {
        return certificationOpinionFileId;
    }

    public void setCertificationOpinionFileId(Long certificationOpinionFileId) {
        this.certificationOpinionFileId = certificationOpinionFileId;
    }

    public Long getCertifiedConstructionPlanFileId() {
        return certifiedConstructionPlanFileId;
    }

    public void setCertifiedConstructionPlanFileId(Long certifiedConstructionPlanFileId) {
        this.certifiedConstructionPlanFileId = certifiedConstructionPlanFileId;
    }

    public Long getOtherAttachmentFileId() {
        return otherAttachmentFileId;
    }

    public void setOtherAttachmentFileId(Long otherAttachmentFileId) {
        this.otherAttachmentFileId = otherAttachmentFileId;
    }
}
