/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.ztpc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.ztpc.bean.BillcodeCategoryEntity;
import com.ejianc.ztpc.bean.ConSchemePlanEntity;
import com.ejianc.ztpc.bean.ConstructionSchemeEntity;
import com.ejianc.ztpc.enumUtils.ConOrgDesignStateEnum;
import com.ejianc.ztpc.service.IBillcodeCategoryService;
import com.ejianc.ztpc.service.IBillcodeRuleSnService;
import com.ejianc.ztpc.service.IConSchemePlanService;
import com.ejianc.ztpc.service.IConstructionSchemeService;
import com.ejianc.ztpc.vo.BillcodeApiVO;
import com.ejianc.ztpc.vo.BillcodeRuleSnVO;
import com.ejianc.ztpc.vo.ConSchemePlanImportVO;
import com.ejianc.ztpc.vo.ConSchemePlanVO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"conSchemePlan"})
public class ConSchemePlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IConSchemePlanService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IConstructionSchemeService constructionSchemeService;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private IBillcodeCategoryService billcodeCategoryService;
    @Autowired
    private IBillcodeRuleSnService billcodeRuleSnService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ConSchemePlanVO> saveOrUpdate(@RequestBody ConSchemePlanVO saveOrUpdateVO) {
        ConSchemePlanEntity entity;
        if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getConsTimeFrameList())) {
            saveOrUpdateVO.setConsTimeFrame(saveOrUpdateVO.getConsTimeFrameList().get(0) + "~" + saveOrUpdateVO.getConsTimeFrameList().get(1));
        }
        if ((entity = (ConSchemePlanEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ConSchemePlanEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        BillcodeApiVO billcodeApi = this.getBillcodeApi(saveOrUpdateVO);
        CommonResponse<BillcodeApiVO> billcodeApiVOCommonResponse = null;
        if (billcodeApi != null) {
            try {
                billcodeApiVOCommonResponse = this.billcodeRuleSnService.generateBillcode(billcodeApi);
                if (billcodeApiVOCommonResponse.isSuccess()) {
                    List<BillcodeRuleSnVO> snList = ((BillcodeApiVO)billcodeApiVOCommonResponse.getData()).getSnList();
                    for (BillcodeRuleSnVO codeSnVO : snList) {
                        entity.setOutsideCode(codeSnVO.getGenerateBillCode());
                    }
                }
            }
            catch (Exception e) {
                this.logger.info(e.getMessage());
            }
        }
        if (billcodeApiVOCommonResponse != null && (billcodeApiVOCommonResponse.getCode() == 999 || billcodeApiVOCommonResponse.isSuccess())) {
            boolean b = this.service.saveOrUpdate((Object)entity, false);
            if (b && billcodeApiVOCommonResponse.isSuccess()) {
                BillcodeApiVO responseData = (BillcodeApiVO)billcodeApiVOCommonResponse.getData();
                this.billcodeRuleSnService.commitBillcode(responseData);
            }
        } else {
            if (billcodeApiVOCommonResponse == null) {
                return CommonResponse.error((String)"\u53d6\u53f7\u5931\u8d25");
            }
            return CommonResponse.error((String)("\u53d6\u53f7\u5931\u8d25:" + billcodeApiVOCommonResponse.getMsg()));
        }
        ConSchemePlanVO vo = (ConSchemePlanVO)((Object)BeanMapper.map((Object)((Object)entity), ConSchemePlanVO.class));
        if (StringUtils.isNotBlank((CharSequence)vo.getConsTimeFrame())) {
            vo.setConsTimeFrameList(Arrays.asList(vo.getConsTimeFrame().split("~")));
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    public BillcodeApiVO getBillcodeApi(ConSchemePlanVO vo) {
        BillcodeApiVO billcodeApiVO = new BillcodeApiVO();
        billcodeApiVO.setProjectId(vo.getProjectId());
        billcodeApiVO.setProjectCode(vo.getProjectCode());
        billcodeApiVO.setProjectName(vo.getProjectName());
        BillcodeCategoryEntity category = (BillcodeCategoryEntity)((Object)this.billcodeCategoryService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).eq(BillcodeCategoryEntity::getEnableStatus, (Object)1)).eq(BillcodeCategoryEntity::getCode, (Object)"ct_con_scheme_plan")));
        if (category == null) {
            return null;
        }
        billcodeApiVO.setCategoryId(category.getId());
        ArrayList<BillcodeRuleSnVO> snVOList = new ArrayList<BillcodeRuleSnVO>();
        billcodeApiVO.setSnList(snVOList);
        BillcodeRuleSnVO billcodeRuleSnVO = new BillcodeRuleSnVO();
        snVOList.add(billcodeRuleSnVO);
        billcodeRuleSnVO.setSourcePid(vo.getId());
        billcodeRuleSnVO.setSourceCode(vo.getCode());
        billcodeRuleSnVO.setSourceType("BT230725000000001");
        billcodeRuleSnVO.setSourceTypeName("\u65bd\u5de5\u65b9\u6848\u7f16\u5236\u8ba1\u5212");
        try {
            if (vo.getMgrp() != null) {
                JSONArray mgrpReferValue = ReferObjectUtil.getReferEntityValue((String)(vo.getMgrp() + ""), (String)"data-dictionary");
                JSONObject mgrpRef = (JSONObject)mgrpReferValue.get(0);
                billcodeRuleSnVO.setRule01(mgrpRef.getString("code"));
            }
            if (vo.getLocationCode() != null) {
                JSONArray locationReferValue = ReferObjectUtil.getReferEntityValue((String)(vo.getLocationCode() + ""), (String)"data-dictionary-category");
                JSONObject locationRef = (JSONObject)locationReferValue.get(0);
                billcodeRuleSnVO.setRule02(locationRef.getString("code"));
            }
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
            throw new BusinessException("referCode\u8f6c\u6362\u9519\u8bef");
        }
        return billcodeApiVO;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ConSchemePlanVO> queryDetail(Long id) {
        ConSchemePlanEntity entity = (ConSchemePlanEntity)((Object)this.service.selectById(id));
        ConSchemePlanVO vo = (ConSchemePlanVO)((Object)BeanMapper.map((Object)((Object)entity), ConSchemePlanVO.class));
        if (StringUtils.isNotBlank((CharSequence)vo.getConsTimeFrame())) {
            vo.setConsTimeFrameList(Arrays.asList(vo.getConsTimeFrame().split("~")));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConSchemePlanVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        List constructionSchemeList = this.constructionSchemeService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).in(ConstructionSchemeEntity::getConsSchemeId, ids));
        if (CollectionUtils.isNotEmpty((Collection)constructionSchemeList)) {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff01\u4e0d\u80fd\u5220\u9664\u5df2\u7ecf\u88ab\u65bd\u5de5\u65b9\u6848\u5f15\u7528\u7684\u6570\u636e\u3002");
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ConSchemePlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("cons_scheme_name");
        fuzzyFields.add("org_name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        Parameter orgId = (Parameter)param.getParams().get("orgId");
        long parentOrgId = 0L;
        if (orgId != null) {
            parentOrgId = Long.parseLong(orgId.getValue().toString());
            param.getParams().remove("orgId");
        } else {
            parentOrgId = InvocationInfoProxy.getOrgId();
        }
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(Long.valueOf(parentOrgId)), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ConSchemePlanVO.class));
        Map<String, Long> totalMap = this.queryTotalBaseOnConsSchemeType(param);
        pageData.getRecords().forEach(a -> {
            block3: {
                a.setTotalMap(totalMap);
                try {
                    if (StringUtils.isNotBlank((CharSequence)a.getConsTimeFrame())) {
                        String startDate = DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(DateUtils.parseDate((String)a.getConsTimeFrame().split("~")[0], (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"}));
                        String endDate = DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(DateUtils.parseDate((String)a.getConsTimeFrame().split("~")[1], (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"}));
                        a.setConsTimeFrameList(Arrays.asList(a.getConsTimeFrame().split("~")));
                        a.setConsTimeFrame(startDate + "~" + endDate);
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("\u65bd\u5de5\u65b9\u6848\u7f16\u8f91\u8ba1\u5212\u6e05\u5355 \u8f6c\u6362\u65bd\u5de5\u65f6\u6bb5 \u5931\u8d25\uff01");
                }
            }
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public Map<String, Long> queryTotalBaseOnConsSchemeType(QueryParam param) {
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        CommonResponse consSchemeTypeDefdoc = this.iDefdocApi.getDefDocByDefCode("ct_cons_scheme_type");
        if (!consSchemeTypeDefdoc.isSuccess()) {
            return resultMap;
        }
        List<Map<String, Long>> list = this.service.queryTotalBaseOnConsSchemeType(param);
        for (Map<String, Long> map : list) {
            Long typeId = map.get("consSchemeType");
            if (typeId == null || typeId == 0L) continue;
            for (DefdocDetailVO datum : (List)consSchemeTypeDefdoc.getData()) {
                if (!typeId.equals(datum.getId())) continue;
                resultMap.put(datum.getCode(), map.get("total"));
            }
        }
        return resultMap;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ConSchemePlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refConSchemePlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ConSchemePlanVO>> refConSchemePlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        if (StringUtils.isNotEmpty((CharSequence)condition) && Objects.nonNull((_con = JSONObject.parseObject((String)condition)).get((Object)"projectId"))) {
            param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
        }
        param.getParams().put("state", new Parameter("sql", (Object)("(execute_state IS NULL OR execute_state = '' OR execute_state = " + ConOrgDesignStateEnum.ONE.getCode() + " OR execute_state = " + ConOrgDesignStateEnum.TWO.getCode() + ")")));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ConSchemePlanVO.class));
        pageData.getRecords().forEach(a -> {
            block3: {
                try {
                    if (StringUtils.isNotBlank((CharSequence)a.getConsTimeFrame())) {
                        String startDate = DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(DateUtils.parseDate((String)a.getConsTimeFrame().split("~")[0], (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"}));
                        String endDate = DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(DateUtils.parseDate((String)a.getConsTimeFrame().split("~")[1], (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"}));
                        a.setConsTimeFrameList(Arrays.asList(a.getConsTimeFrame().split("~")));
                        a.setConsTimeFrame(startDate + "~" + endDate);
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("\u65bd\u5de5\u65b9\u6848\u7f16\u8f91\u8ba1\u5212\u6e05\u5355 \u8f6c\u6362\u65bd\u5de5\u65f6\u6bb5 \u5931\u8d25\uff01");
                }
            }
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/downloadConSchemePlanTemplate"})
    @ResponseBody
    public void downloadConSchemePlanTemplate(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"con-scheme-plan-import.xlsx", (String)"\u65bd\u5de5\u65b9\u6848\u7f16\u5236\u8ba1\u5212\u6e05\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelConSchemePlanImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelConSchemePlanImport(HttpServletRequest request) {
        return this.service.excelConSchemePlanImport(request);
    }

    @RequestMapping(value={"/saveImportExcelConSchemePlan"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Void> saveImportExcelConSchemePlan(@RequestBody List<ConSchemePlanImportVO> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList list = Lists.newArrayList();
        importVos.forEach(importVO -> {
            if (importVO.getConsTimeFrameList() != null) {
                String startDate = importVO.getConsTimeFrameList().get(0) + "T16:00:00.000Z";
                String endDate = importVO.getConsTimeFrameList().get(1) + "T16:00:00.000Z";
                importVO.setConsTimeFrame(startDate + "~" + endDate);
            }
            ConSchemePlanEntity entity = (ConSchemePlanEntity)((Object)((Object)BeanMapper.map((Object)importVO, ConSchemePlanEntity.class)));
            entity.setId(IdWorker.getId());
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)importVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            list.add(entity);
        });
        this.service.saveBatch(list, list.size());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }
}

