package com.ejianc.ztpc.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 收尾管理表
 * 
 * @author generator
 * 
 */
public class ProjectEndingVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long constructId; // 建设单位id
    private String constructName; // 建设单位
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long projectLeave; // 项目分级(自定义档案)
    private Long orgId; // 项目组织ID
    private String orgCode; // 项目组织编码
    private String orgName; // 项目组织名称
    private Long parentOrgId; // 父级组织ID
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private String billCode; // 文件编码
    private Long fileType; // 文件类别
    private Long engineeringTypeId; // 工程类别
    private String area; // 地区
    private String areaName; // 地区
    private String address; // 地址
    private String supervisor; // 监理单位
    private String designer; // 设计单位
    private Long projectManageType; // 项目管理分类--字典ct_project_manage_type
    private Long projectManagementId; // 项目经理id
    private String projectManagementName; // 项目经理
    private Long chiefEngineerId; // 项目总工
    private String chiefEngineer; // 项目总工名称
    private String remark; // 备注
    private String closingPlan; // 收尾实施计划附件
    private String lackSurplusPlan; // 消缺及剩余工程清单附件
    private String completionPlan; // 竣工资料编制计划附件
    private String engineeringSummary; // 工程总结
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String fileState; // 文件状态（Y：有效，N：无效）
    private List<OpinionInfoVO> opinionInfoList; // 意见栏

    @ReferSerialTransfer(referCode="support-customer,support-supplier")
    public Long getConstructId() {
        return constructId;
    }

    @ReferDeserialTransfer
    public void setConstructId(Long constructId) {
        this.constructId = constructId;
    }
    public String getConstructName() {
        return constructName;
    }

    public void setConstructName(String constructName) {
        this.constructName = constructName;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProjectLeave() {
        return projectLeave;
    }

    @ReferDeserialTransfer
    public void setProjectLeave(Long projectLeave) {
        this.projectLeave = projectLeave;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFileType() {
        return fileType;
    }
    @ReferDeserialTransfer
    public void setFileType(Long fileType) {
        this.fileType = fileType;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }

    @ReferDeserialTransfer
    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public String getSupervisor() {
        return supervisor;
    }

    public void setSupervisor(String supervisor) {
        this.supervisor = supervisor;
    }
    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProjectManageType() {
        return projectManageType;
    }

    @ReferDeserialTransfer
    public void setProjectManageType(Long projectManageType) {
        this.projectManageType = projectManageType;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectManagementId() {
        return projectManagementId;
    }

    @ReferDeserialTransfer
    public void setProjectManagementId(Long projectManagementId) {
        this.projectManagementId = projectManagementId;
    }
    public String getProjectManagementName() {
        return projectManagementName;
    }

    public void setProjectManagementName(String projectManagementName) {
        this.projectManagementName = projectManagementName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getChiefEngineerId() {
        return chiefEngineerId;
    }
    @ReferDeserialTransfer
    public void setChiefEngineerId(Long chiefEngineerId) {
        this.chiefEngineerId = chiefEngineerId;
    }
    public String getChiefEngineer() {
        return chiefEngineer;
    }

    public void setChiefEngineer(String chiefEngineer) {
        this.chiefEngineer = chiefEngineer;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getClosingPlan() {
        return closingPlan;
    }

    public void setClosingPlan(String closingPlan) {
        this.closingPlan = closingPlan;
    }
    public String getLackSurplusPlan() {
        return lackSurplusPlan;
    }

    public void setLackSurplusPlan(String lackSurplusPlan) {
        this.lackSurplusPlan = lackSurplusPlan;
    }
    public String getCompletionPlan() {
        return completionPlan;
    }

    public void setCompletionPlan(String completionPlan) {
        this.completionPlan = completionPlan;
    }
    public String getEngineeringSummary() {
        return engineeringSummary;
    }

    public void setEngineeringSummary(String engineeringSummary) {
        this.engineeringSummary = engineeringSummary;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getFileState() {
        return fileState;
    }

    public void setFileState(String fileState) {
        this.fileState = fileState;
    }

    public List<OpinionInfoVO> getOpinionInfoList() {
        return opinionInfoList;
    }

    public void setOpinionInfoList(List<OpinionInfoVO> opinionInfoList) {
        this.opinionInfoList = opinionInfoList;
    }


}
