package com.ejianc.ztpc.enumUtils;

import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @ClassName SchemeStateEnum
 * @Description 施工方案的状态枚举
 * @Author WC
 * @Date 2023/7/21 14:50
 * @Version 1.0
 **/
public enum SchemeStateEnum {
    // 待实施
    ONE("1", "待实施"),
    // 实施中
    TWO("2", "实施中"),
    // 已验收
    THREE("3", "已验收");

    private final String code;
    private final String name;
    private static final Map<String, SchemeStateEnum> enumMap;
    private static final Map<String, SchemeStateEnum> enumNameMap;

    private SchemeStateEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static SchemeStateEnum getEnumByCode(String code) {
        return enumMap.get(code);
    }

    public static SchemeStateEnum getEnumByName(String name) {
        return enumNameMap.get(name);
    }

    static {
        enumMap = EnumSet.allOf(SchemeStateEnum.class).stream().collect(Collectors.toMap(SchemeStateEnum::getCode, Function.identity(), (k1, k2) -> k2));
        enumNameMap = EnumSet.allOf(SchemeStateEnum.class).stream().collect(Collectors.toMap(SchemeStateEnum::getName, Function.identity(), (k1, k2) -> k2));
    }
}
