package com.ejianc.ztpc.mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.ztpc.bean.DrawingCheckEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 图纸会检表
 *
 * @author generator
 */
@Mapper
public interface DrawingCheckMapper extends BaseCrudMapper<DrawingCheckEntity> {
    /**
     * 更新图纸信息的会检状态
     *
     * @param ids 主键ID
     * @return 成功条数
     */
    int updateDrawInfoCheckState(@Param("ids") List<Long> ids);

    /**
     * 查询图纸信息
     *
     * @param ids 主键ID
     * @return 图纸编号
     */
    List<String> selectDrawCode(@Param("ids") List<Long> ids);

    /**
     * 导入查询列表信息
     *
     * @return
     */
    List<Map<String, Object>> queryMapProjAll();
}
