package com.ejianc.ztpc.util;

import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

import java.io.BufferedInputStream;
import java.io.IOException;

/**
 * @author yqls
 * @date 2021-08-14 16:15:06
 */
public class DetailIndexExcelReader {
    /**
     * 获取excel文件页签数
     *
     * @param file
     * @return
     */
    public static Integer getNumberOfSheets(MultipartFile file) {
        String originalFileName = new String(file.getOriginalFilename());
        String extName = null;
        originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
        originalFileName.replaceAll("00.", "");
        extName = FileUtils.getFileExt(originalFileName, false);
        if ("xls".equals(extName)) {
            HSSFWorkbook hwb;
            try {
                hwb = new HSSFWorkbook(new BufferedInputStream(file.getInputStream()));
            } catch (IOException var17) {
                throw new BusinessException(var17.getMessage());
            }
            return hwb.getNumberOfSheets();
        } else if ("xlsx".equals(extName)) {
            XSSFWorkbook xwb;
            try {
                xwb = new XSSFWorkbook(new BufferedInputStream(file.getInputStream()));
            } catch (IOException var17) {
                throw new BusinessException(var17.getMessage());
            }
            return xwb.getNumberOfSheets();
        } else {
            throw new BusinessException("不支持的文件类型");
        }
    }
}
