package com.ejianc.ztpc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.ztpc.bean.CheckDrawInfoEntity;
import com.ejianc.ztpc.bean.DrawingCheckEntity;
import com.ejianc.ztpc.mapper.DrawingCheckMapper;
import com.ejianc.ztpc.service.IDrawingCheckService;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service("drawingCheck") 
public class DrawingCheckBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IDrawingCheckService drawingCheckService;
	@Autowired
	private DrawingCheckMapper drawingCheckMapper;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		if (logger.isInfoEnabled()) {
			logger.info("afterSubmitProcessor，开始回写状态，billId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode);
		}
		DrawingCheckEntity entity = drawingCheckService.selectById(billId);
		if (Objects.nonNull(entity) && CollectionUtils.isNotEmpty(entity.getCheckDrawInfoList())) {
			List<String> drawCodeList = drawingCheckMapper.selectDrawCode(entity.getCheckDrawInfoList().stream().map(CheckDrawInfoEntity::getDrawId).collect(Collectors.toList()));
			if (CollectionUtils.isNotEmpty(drawCodeList)) {
				return CommonResponse.error(String.format("图纸信息已会签，会检的图纸[%s]", JSONObject.toJSONString(drawCodeList)));
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("afterApprovalProcessor，开始回写状态，billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		DrawingCheckEntity entity = drawingCheckService.selectById(billId);
		if (Objects.nonNull(entity) && CollectionUtils.isNotEmpty(entity.getCheckDrawInfoList())) {
			drawingCheckMapper.updateDrawInfoCheckState(entity.getCheckDrawInfoList().stream().map(CheckDrawInfoEntity::getDrawId).collect(Collectors.toList()));
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
