package com.ejianc.ztpc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.ztpc.billcode.api.IBillCodeRuleApi;
import com.ejianc.business.ztpc.billcode.bean.DataDictionaryVO;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.bpm.vo.BpmApproveHistoryInfo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.ztpc.bean.ConSchemePlanEntity;
import com.ejianc.ztpc.service.IConSchemePlanService;
import com.ejianc.ztpc.util.DetailIndexExcelReader;
import com.ejianc.ztpc.util.EJCDateUtil;
import com.ejianc.ztpc.util.ToolUtil;
import com.ejianc.ztpc.util.UpSumUtil;
import com.ejianc.ztpc.vo.ConSchemePlanImportVO;
import com.ejianc.ztpc.vo.ConstructionSchemeImportVO;
import com.ejianc.ztpc.vo.ConstructionSchemeVO;
import com.ejianc.ztpcdata.api.IExternalApi;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.ztpc.mapper.ConstructionSchemeMapper;
import com.ejianc.ztpc.bean.ConstructionSchemeEntity;
import com.ejianc.ztpc.service.IConstructionSchemeService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 施工方案表
 * 
 * @author generator
 * 
 */
@Service("constructionSchemeService")
public class ConstructionSchemeServiceImpl extends BaseServiceImpl<ConstructionSchemeMapper, ConstructionSchemeEntity> implements IConstructionSchemeService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ConstructionSchemeMapper mapper;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExternalApi iExternalApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    IConSchemePlanService conSchemePlanService;
    @Autowired
    private IBillCodeRuleApi billCodeRuleApi;
    @Autowired
    private IBpmApi bpmApi;
    @Autowired
    private IExternalApi externalApi;
    @Autowired
    private UpSumUtil upSumUtil;
    @Override
    public CommonResponse<JSONObject> excelConstructionSchemeImport(HttpServletRequest request) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();

        MultipartFile mf = null;
        List<ConstructionSchemeImportVO> successList = new ArrayList<>();
        List<ConstructionSchemeImportVO> errorList = new ArrayList<>();
        List<ConstructionSchemeImportVO> rtErrorList = new ArrayList<>();

        boolean isFailed = false;
        for (Map.Entry<String, MultipartFile> entry : fileMap.entrySet()) {
            mf = entry.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {

            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size != 1) {
                return CommonResponse.error("文件页签不完整，请下载最新模板！");
            }
            List<List<String>> result = ExcelReader.readExcel(mf);

            if (result != null && result.size() > 0) {
                if (result.size() > 10000) {
                    return CommonResponse.error("施工方案信息超过10000条，请分批上传！");
                }
                Map<String, Map<String, Object>> projDataMapAll = mapper.queryMapProjAll().stream().collect(
                        Collectors.toMap(e -> String.valueOf(e.get("projectId")), Function.identity(), (e1, e2) -> e2)
                );
                List<Map<String, Object>> mapProjLocal = Lists.newArrayList();
                CommonResponse<List<Map<String, Object>>> response = iExternalApi.getMapProjLocal();
                if (response.isSuccess()) {
                    mapProjLocal = response.getData();
                }
                Map<String, Map<String,Object>> projDataMap = mapProjLocal.stream().collect(
                        Collectors.toMap(e->String.valueOf(e.get("name")), Function.identity(),(e1,e2)->e2)
                );
                //专业分类自定义档案
                CommonResponse<List<DefdocDetailVO>> ctSpecialtyType = iDefdocApi.getDefDocByDefCode("ct_specialty_type");
                CommonResponse<List<DefdocDetailVO>> ctConsSchemeType = iDefdocApi.getDefDocByDefCode("ct_cons_scheme_type");
                CommonResponse<List<DefdocDetailVO>> ctProjectManageType = iDefdocApi.getDefDocByDefCode("ct_project_manage_type");

                for (int i = 0; i < result.size(); i++) {
                    boolean flag = true;
                    List<String> datas = result.get(i);
                    StringBuilder errorMessage = new StringBuilder("");
                    ConstructionSchemeImportVO vo = new ConstructionSchemeImportVO();
                    vo.setId(IdWorker.getId());

                    // 工程名称
                    String projectName = datas.get(0);
                    Map<String, Object> projectNameMap = projDataMap.get(projectName);
                    if (StringUtils.isBlank(projectName) || MapUtils.isEmpty(projectNameMap)) {
                        errorMessage.append("[工程名称]").append(projectName).append(":错误参照无法获取;");
                        flag = false;
                    } else {
                        vo.setProjectName((String) projectNameMap.get("name"));
                        vo.setProjectCode((String) projectNameMap.get("code"));
                        Object id = projectNameMap.get("id");
                        if (id instanceof String) {
                            vo.setProjectId(Long.parseLong((String) id));
                        } else {
                            vo.setProjectId((Long) id);
                        }
                        /*
                         * 项目信息自动带出的数据
                         */
                        // 工程类别
                        Object engineeringTypeId = projectNameMap.get("engineering_type_id");
                        if (engineeringTypeId instanceof String) {
                            vo.setEngineeringTypeId(Long.parseLong((String) engineeringTypeId));
                        } else {
                            vo.setEngineeringTypeId((Long) engineeringTypeId);
                        }
                        // 项目分级
                        Object projectLeave = projectNameMap.get("project_rank");
                        if (projectLeave instanceof String) {
                            vo.setProjectLeave(Long.parseLong((String) projectLeave));
                        } else {
                            vo.setProjectLeave((Long) projectLeave);
                        }
                    }



                    //施工方案编制计划清单
                    String consSchemeIdName = datas.get(1);
                    ConSchemePlanEntity conSchemePlanEntity = conSchemePlanService.getOne(
                            new QueryWrapper<ConSchemePlanEntity>().lambda().eq(ConSchemePlanEntity::getProjectId, vo.getProjectId())
                                    .eq(ConSchemePlanEntity::getConsSchemeName, consSchemeIdName)
                                    .eq(ConSchemePlanEntity::getDr, 0)
                                    .last(" LIMIT 1 ")
                    );
                    if (conSchemePlanEntity == null){
                        errorMessage.append("[施工方案编制计划清单]" + consSchemeIdName + ":未找到");
                        flag = false;
                    }else {
                        Date planRedactDate = conSchemePlanEntity.getPlanRedactDate();//计划编制时间
                        Date redactFinishDate = conSchemePlanEntity.getRedactFinishDate();//编制完成时间
                        Long specialtyType = conSchemePlanEntity.getSpecialtyType();//专业分类
                        Long consSchemeType = conSchemePlanEntity.getConsSchemeType();//施工方案类别
                        String orgExpertExamine = conSchemePlanEntity.getOrgExpertExamine();//组织专家审查要求
                        String consTimeFrame = conSchemePlanEntity.getConsTimeFrame();//施工时段
                        Long projectTrait = conSchemePlanEntity.getProjectTrait();//分部分项工程特征
                        String keyPointExplain = conSchemePlanEntity.getKeyPointExplain();//专项施工方案关注重点
                        Date finishConsSchemeDate = conSchemePlanEntity.getFinishConsSchemeDate();//完成施工方案时间
                        vo.setConsSchemeId(conSchemePlanEntity.getId());
                        vo.setPlanRedactDate(planRedactDate);
                        vo.setRedactFinishDate(redactFinishDate);
                        vo.setSpecialtyType(specialtyType);
                        vo.setConsSchemeType(consSchemeType);
                        vo.setOrgExpertExamine(orgExpertExamine);
                        vo.setProjectTrait(projectTrait);
                        vo.setKeyPointExplain(keyPointExplain);
                        vo.setFinishConsSchemeDate(finishConsSchemeDate);
                        if(ToolUtil.isNotEmpty(consTimeFrame)) {
                            try {
                                List<String> consTimeFrameList = Arrays.asList(consTimeFrame.split("~"));
                                DateUtils.parseDate(consTimeFrameList.get(0), "yyyy-MM-dd");
                                DateUtils.parseDate(consTimeFrameList.get(1), "yyyy-MM-dd");
                                vo.setConsTimeFrame(consTimeFrame);
                                vo.setConsTimeFrameList(consTimeFrameList);
                            } catch (Exception e) {
                                errorMessage.append(consTimeFrame + "日期转换错误");
                                flag = false;
                                logger.info("日期转换错误");
                            }
                        }
                    }

                    //施工方案名称
                    String consSchemeName = datas.get(2);
                    if (ToolUtil.isEmpty(consSchemeName)){
                        errorMessage.append("[施工方案名称]").append("为空;");
                        flag = false;
                    }else {
                        vo.setConsSchemeName(consSchemeName);
                    }

                    //文件编码
                    String code = datas.get(3);
                    if (ToolUtil.isNotEmpty(code)){
                        vo.setCode(code);
                    }else {
                        errorMessage.append("[文件编码]为空;");
                        flag = false;
                    }

                    //外部编码
                    String outsideCode = datas.get(4);
                    if (ToolUtil.isNotEmpty(outsideCode)){
                        vo.setOutsideCode(outsideCode);
                    }
                    


                    //版次
                    String fileVersion = datas.get(5);
                    vo.setFileVersion(fileVersion);

                    //计划编制时间
                    String planRedactDateStr = datas.get(6);
                    if (ToolUtil.isNotEmpty(planRedactDateStr)) {
                        Date parse = EJCDateUtil.parseDate(planRedactDateStr, EJCDateUtil.DATE);
                        if (ToolUtil.isNotEmpty(parse)) {
                            vo.setPlanRedactDate(parse);
                        } else {
                            errorMessage.append("[计划编制时间]" + planRedactDateStr + ":格式错误");
                            flag = false;
                        }
                    } else {
//                        errorMessage.append("[计划编制时间]为空;");
//                        flag = false;
                    }
                    
                    //专业分类
                    String specialtyTypeName = datas.get(7);
                    if (ToolUtil.isEmpty(specialtyTypeName)) {
                        if (ToolUtil.isEmpty(vo.getSpecialtyType())){
                            errorMessage.append("[专业分类]为空;");
                            flag = false;
                        }
                    } else if (!ctSpecialtyType.isSuccess() || CollectionUtils.isEmpty(ctSpecialtyType.getData())) {
                        errorMessage.append("[专业分类]").append(specialtyTypeName).append(":错误参照无法获取;");
                        flag = false;
                    } else {
                        Long defdocDetailId = ctSpecialtyType.getData().stream().filter(a -> specialtyTypeName.equals(a.getName())).map(DefdocDetailVO::getId).findFirst().orElse(null);
                        if (defdocDetailId == null){
                            errorMessage.append("[专业分类]:未找到对应参照;");
                            flag = false;
                        }else {
                            vo.setSpecialtyType(defdocDetailId);
                        }
                    }

                    //施工方案类别
                    String consSchemeTypeName = datas.get(8);
                    if (ToolUtil.isEmpty(consSchemeTypeName)) {
                        if (ToolUtil.isEmpty(vo.getConsSchemeType())) {
                            errorMessage.append("[施工方案类别]为空;");
                            flag = false;
                        }
                    } else if (!ctConsSchemeType.isSuccess() || CollectionUtils.isEmpty(ctConsSchemeType.getData())) {
                        errorMessage.append("[施工方案类别]").append(consSchemeTypeName).append(":错误参照无法获取;");
                        flag = false;
                    } else {
                        Long defdocDetailId = ctConsSchemeType.getData().stream().filter(a -> consSchemeTypeName.equals(a.getName())).map(DefdocDetailVO::getId).findFirst().orElse(null);
                        if (defdocDetailId == null){
                            errorMessage.append("[施工方案类别]:未找到对应参照;");
                            flag = false;
                        }else {
                            vo.setConsSchemeType(defdocDetailId);
                        }
                    }

                    //组织专家审查要求
                    String orgExpertExamine = datas.get(9);
                    if (ToolUtil.isNotEmpty(orgExpertExamine)){
                        if ("是".equals(orgExpertExamine)){
                            vo.setOrgExpertExamine("Y");
                        }else if ("否".equals(orgExpertExamine)){
                            vo.setOrgExpertExamine("N");
                        }else {
                            errorMessage.append("[组织专家审查要求]:格式错误;");
                            flag = false;
                        }
                    }

                    //施工时段
                    String consTimeFrameStr = datas.get(10);
                    if (ToolUtil.isEmpty(consTimeFrameStr)){
                        if (ToolUtil.isEmpty(vo.getConsTimeFrame())){
                            errorMessage.append("[施工时段]为空;");
                            flag = false;
                        }
                    }else {
                        try {
                            List<String> consTimeFrameList = Arrays.asList(consTimeFrameStr.split("~"));
                            DateUtils.parseDate(consTimeFrameList.get(0), "yyyy-MM-dd");
                            DateUtils.parseDate(consTimeFrameList.get(1), "yyyy-MM-dd");
                            vo.setConsTimeFrame(consTimeFrameStr);
                            vo.setConsTimeFrameList(consTimeFrameList);
                        } catch (Exception e) {
                            errorMessage.append("[施工时段]日期格式错误;");
                            flag = false;
                            if (logger.isErrorEnabled()) {
                                logger.error("施工方案编制计划清单 导入-校验数据 失败！编制完成时间的日期格式错误");
                            }
                        }
                    }

                    //项目管理分类
                    String projectManageTypeName = datas.get(11);
                    if (ToolUtil.isEmpty(projectManageTypeName)) {
                        if (ToolUtil.isEmpty(vo.getConsSchemeType())) {
                            errorMessage.append("[项目管理分类]为空;");
                            flag = false;
                        }
                    } else if (!ctProjectManageType.isSuccess() || CollectionUtils.isEmpty(ctProjectManageType.getData())) {
                        errorMessage.append("[项目管理分类]").append(projectManageTypeName).append(":错误参照无法获取;");
                        flag = false;
                    } else {
                        Long defdocDetailId = ctProjectManageType.getData().stream().filter(a -> projectManageTypeName.equals(a.getName())).map(DefdocDetailVO::getId).findFirst().orElse(null);
                        if (defdocDetailId == null){
                            errorMessage.append("[项目管理分类]:未找到对应参照;");
                            flag = false;
                        }else {
                            vo.setProjectManageType(defdocDetailId);
                        }
                    }

                    //完成施工方案时间
                    String finishConsSchemeDateStr = datas.get(12);
                    if (ToolUtil.isNotEmpty(finishConsSchemeDateStr)) {
                        Date parse = EJCDateUtil.parseDate(finishConsSchemeDateStr, EJCDateUtil.DATE);
                        if (ToolUtil.isNotEmpty(parse)) {
                            vo.setFinishConsSchemeDate(parse);
                        } else {
                            errorMessage.append("[完成施工方案时间]" + finishConsSchemeDateStr + ":格式错误");
                            flag = false;
                        }
                    } else {
//                        errorMessage.append("[完成施工方案时间]为空;");
//                        flag = false;
                    }

                    //区域定位码
                    String locationCodeName = datas.get(13);
                    if (ToolUtil.isNotEmpty(locationCodeName)){
                        Map<String, String> map = new HashMap<>();
                        map.put("categoryName", locationCodeName);
                        CommonResponse<Map<String, Long>> mapCommonResponse = billCodeRuleApi.materialClassificationTree(map);
                        if (mapCommonResponse.isSuccess()) {
                            Map<String, Long> data = mapCommonResponse.getData();
                            if (ToolUtil.isNotEmpty(data)) {
                                Long id = data.get("name");
                                vo.setLocationCode(id);
                            }
                        }
                    }

                    //机组
                    String mgrpName = datas.get(14);
                    Map<String,String> dictionaryQueryMap = new HashMap<>();
                    if (ToolUtil.isNotEmpty(mgrpName)) {
                        dictionaryQueryMap.put("projectId", vo.getProjectId() + "");
                        dictionaryQueryMap.put("categoryCode", "mgrp");
                        CommonResponse<List<DataDictionaryVO>> mgrpCommonResponse = billCodeRuleApi.queryUnitBumber(dictionaryQueryMap);
                        if (mgrpCommonResponse.isSuccess()) {
                            List<DataDictionaryVO> data = mgrpCommonResponse.getData();
                            if (data != null) {
                                DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> mgrpName.equals(a.getDictionaryName())).findFirst().orElse(null);
                                if (dataDictionaryVO == null) {
                                    errorMessage.append("[机组]").append(mgrpName).append(":错误参照无法获取;");
                                    flag = false;
                                } else {
                                    vo.setMgrp(dataDictionaryVO.getId());
                                }
                            }
                        }
                    }

                    vo.setRowIndex((i + 2));
                    Map<String, Object> stringStringMap = projDataMapAll.get(String.valueOf(vo.getProjectId()));
                    CommonResponse<OrgVO> orgVO = iOrgApi.getOneById((Long) stringStringMap.get("orgId"));
                    if (!orgVO.isSuccess()) {
                        errorMessage.append("[项目无对应组织]");
                    }
                    vo.setOrgId((Long) stringStringMap.get("orgId"));
                    vo.setOrgCode(orgVO.getData().getCode());
                    vo.setOrgName(orgVO.getData().getName());
                    vo.setParentOrgId((Long) stringStringMap.get("parentOrgId"));
                    vo.setParentOrgCode((String) stringStringMap.get("parentOrgCode"));
                    vo.setParentOrgName((String) stringStringMap.get("parentOrgName"));
                    if (flag) {
                        successList.add(vo);
                    } else {
                        vo.setErrorMessage(errorMessage.toString());
                        errorList.add(vo);
                    }
                }
            }
        }

        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList.stream().sorted(Comparator.comparing(ConstructionSchemeImportVO::getRowIndex)).collect(Collectors.toList()));
        return CommonResponse.success(json);
    }


    public CommonResponse<List<Map<String, Object>>> statistics(String startDate , String endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        try {
            start = sdf.parse(startDate);
        } catch (ParseException e) {
            logger.info("startDate转换错误:"+startDate);
        }
        Date end = null;
        try {
            end = sdf.parse(endDate);
        } catch (ParseException e) {
            logger.info("endDate转换错误:"+endDate);
        }
        CommonResponse<List<DefdocDetailVO>> consSchemeTypeDefdoc = iDefdocApi.getDefDocByDefCode("ct_cons_scheme_type");
        if (!consSchemeTypeDefdoc.isSuccess()){
            return CommonResponse.error("获取施工方案参照错误");
        }
        QueryParam param = new QueryParam();
        /*UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        long parentOrgId = 0;
        if (orgId != null){
            parentOrgId = orgId;
        }else {
            parentOrgId = InvocationInfoProxy.getOrgId();
        }
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(parentOrgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            *//** 要求主表有orgId字段，保存单据所属组织 *//*
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            *//** 要求主表有projectDepartmentId字段，保存单据所属项目部 *//*
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }*/
        param.getParams().put("billState",new Parameter(QueryParam.IN,Arrays.asList(1,3)));

        List<ConstructionSchemeEntity> constructionSchemeEntities = queryList(param);

        //筛选审批时间在时间段内的单据
        if (start != null && end != null) {
            for (int i = 0; i < constructionSchemeEntities.size(); i++) {
                ConstructionSchemeEntity constructionSchemeEntity = constructionSchemeEntities.get(i);
                CommonResponse<List<BpmApproveHistoryInfo>> history = bpmApi.queryHistoryById(constructionSchemeEntity.getId());
                if (!history.isSuccess()) {
                    throw new BusinessException(history.getMsg());
                }
                if (history.getData().size() == 0) {
                    continue;
                }
                BpmApproveHistoryInfo historyInfo = history.getData().get(history.getData().size() - 1);
                String processTime = historyInfo.getProcessTime();
                Date lastApproveDate = null;
                try {
                    lastApproveDate = sdf.parse(processTime);
                } catch (ParseException e) {
                    logger.info("lastApproveDate转换错误:"+processTime);
                }

                if (lastApproveDate != null){
                    if (!(lastApproveDate.after(start) && lastApproveDate.before(end))){
                        constructionSchemeEntities.remove(i);
                        i--;
                        continue;
                    }
                }
            }
        }
        Map<Long,Map<String,String>> dataMap = new HashMap<>();

        //组装统计数据
        for (ConstructionSchemeEntity entity : constructionSchemeEntities) {
            Long keyOrgId = entity.getParentOrgId();
            if (keyOrgId == null){
                continue;
            }
            Map<String, String> data = dataMap.get(keyOrgId);
            if (data == null){
                data = new HashMap<>();
                data.put("orgId",keyOrgId+"");
                data.put("orgName",entity.getParentOrgName());
                for (DefdocDetailVO datum : consSchemeTypeDefdoc.getData()) {
                    if (datum.getId().equals(entity.getConsSchemeType())){
                        data.put(datum.getCode(),"1");
                    }else {
                        data.put(datum.getCode(), "0");
                    }
                }
                dataMap.put(keyOrgId,data);
            }else {
                for (DefdocDetailVO datum : consSchemeTypeDefdoc.getData()) {
                    String code = datum.getCode();
                    if (datum.getId().equals(entity.getConsSchemeType())){
                        data.put(code,Integer.parseInt(data.get(code))+1+"");
                    }
                }
            }

        }

        CommonResponse<List<OrgVO>> orgListResponse = externalApi.getOrgList(null, null, InvocationInfoProxy.getOrgId());
        if (!orgListResponse.isSuccess()){
            return CommonResponse.error("获取组织数据错误");
        }
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(orgListResponse, true, "查询失败，获取组织数据错误");
        for (int i = 0; i < orgVOList.size(); i++) {
            OrgVO orgVO = orgVOList.get(i);
            if (orgVO.getOrgType() == 5){
                orgVOList.remove(i);
                i--;
            }
        }
        List<Map> mapList = BeanMapper.mapList(orgVOList, Map.class);
        for (Map map : mapList) {
            Long id = Long.parseLong(map.get("id").toString());
            Map<String, String> stringStringMap = dataMap.get(id);
            if (stringStringMap == null){
                continue;
            }
            for (DefdocDetailVO datum : consSchemeTypeDefdoc.getData()) {
                String value = stringStringMap.get(datum.getCode());
                map.put(datum.getCode(), value == null ? 0 : Long.valueOf(value));
            }
        }
        List<Map<String, Object>> treeData = ResultAsTree.createTreeData(mapList);
        List<Map<String, Object>> result = upSumUtil.upSum(treeData,"A","B","C");
//        orgVOList = BeanMapper.mapList(treeData,OrgVO.class);

        return CommonResponse.success(result);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
}
