package com.ejianc.ztpc.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;
import java.util.List;


/**
 * 图纸会检表
 *
 * @author generator
 */
public class DrawingCheckVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String code; // 编码
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 项目组织ID
    private String orgCode; // 项目组织编码
    private String orgName; // 项目组织名称
    private Long parentOrgId; // 父级组织ID
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private Long compere; // 主持人
    private Long mgrp; // 机组--字典mgrp
    private Long sys; // 系统--字典sys
    private Long specialty; // 专业--字典specialty
    private String constructionOpinion; // 施工图纸会审意见
    private String jointTrialCode; // 会审编码
    private String jointTrialPlace; // 会审地点
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date jointTrialDate; // 会审日期
    private Long jointTrialType; // 会审类别--字典ct_joint_trial_type
    private String jointTrialOpinion; // 会审意见闭环
    private String effectiveness; // 有效性（Y：有效，N：无效）
    private String outsideCode;//外部编码
    private Long locationCode;//区域定位码

    private List<CheckDrawInfoVO> checkDrawInfoList; // 图纸会检-图纸信息
    private List<CheckParticipantVO> checkParticipantList; // 图纸会检-参加人

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getCompere() {
        return compere;
    }

    @ReferDeserialTransfer
    public void setCompere(Long compere) {
        this.compere = compere;
    }

    @ReferSerialTransfer(referCode = "data-dictionary")
    public Long getMgrp() {
        return mgrp;
    }

    @ReferDeserialTransfer
    public void setMgrp(Long mgrp) {
        this.mgrp = mgrp;
    }

    @ReferSerialTransfer(referCode = "data-dictionary")
    public Long getSys() {
        return sys;
    }

    @ReferDeserialTransfer
    public void setSys(Long sys) {
        this.sys = sys;
    }

    @ReferSerialTransfer(referCode = "data-dictionary")
    public Long getSpecialty() {
        return specialty;
    }

    @ReferDeserialTransfer
    public void setSpecialty(Long specialty) {
        this.specialty = specialty;
    }

    public String getConstructionOpinion() {
        return constructionOpinion;
    }

    public void setConstructionOpinion(String constructionOpinion) {
        this.constructionOpinion = constructionOpinion;
    }

    public String getJointTrialCode() {
        return jointTrialCode;
    }

    public void setJointTrialCode(String jointTrialCode) {
        this.jointTrialCode = jointTrialCode;
    }

    public String getJointTrialPlace() {
        return jointTrialPlace;
    }

    public void setJointTrialPlace(String jointTrialPlace) {
        this.jointTrialPlace = jointTrialPlace;
    }

    public Date getJointTrialDate() {
        return jointTrialDate;
    }

    public void setJointTrialDate(Date jointTrialDate) {
        this.jointTrialDate = jointTrialDate;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getJointTrialType() {
        return jointTrialType;
    }

    @ReferDeserialTransfer
    public void setJointTrialType(Long jointTrialType) {
        this.jointTrialType = jointTrialType;
    }

    public String getJointTrialOpinion() {
        return jointTrialOpinion;
    }

    public void setJointTrialOpinion(String jointTrialOpinion) {
        this.jointTrialOpinion = jointTrialOpinion;
    }

    public List<CheckDrawInfoVO> getCheckDrawInfoList() {
        return checkDrawInfoList;
    }

    public void setCheckDrawInfoList(List<CheckDrawInfoVO> checkDrawInfoList) {
        this.checkDrawInfoList = checkDrawInfoList;
    }

    public List<CheckParticipantVO> getCheckParticipantList() {
        return checkParticipantList;
    }

    public void setCheckParticipantList(List<CheckParticipantVO> checkParticipantList) {
        this.checkParticipantList = checkParticipantList;
    }

    public String getEffectiveness() {
        return effectiveness;
    }

    public void setEffectiveness(String effectiveness) {
        this.effectiveness = effectiveness;
    }

    public String getOutsideCode() {
        return outsideCode;
    }

    public void setOutsideCode(String outsideCode) {
        this.outsideCode = outsideCode;
    }

    @ReferSerialTransfer(referCode = "data-dictionary-category")
    public Long getLocationCode() {
        return locationCode;
    }
    @ReferDeserialTransfer
    public void setLocationCode(Long locationCode) {
        this.locationCode = locationCode;
    }
}
