package com.ejianc.ztpc.vo.enumvo;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum RuleElemType {
    常量("1", "constants"),
    流水号("2", "sn"),
    自定义流水依据("3", "ref");


    private String code;

    private String name;
    private String className;

    private static Map<String, RuleElemType> enumMap = new HashMap();

    private RuleElemType(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }



    public static void setEnumMap(Map<String, RuleElemType> enumMap) {
        RuleElemType.enumMap = enumMap;
    }

    public static RuleElemType getByCode(String code) {
        return (RuleElemType)enumMap.get(code);
    }

    static {
        enumMap = (Map) EnumSet.allOf(RuleElemType.class).stream().collect(Collectors.toMap(RuleElemType::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
