package com.ejianc.design.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 设计管理技术规范书表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_design_technical_specification")
public class DesignTechnicalSpecificationEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 项目组织ID
    @TableField(value="org_code")
    private String orgCode; // 项目组织编码
    @TableField(value="org_name")
    private String orgName; // 项目组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织ID
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="bill_code")
    private String billCode; // 文件编码
    @TableField(value="file_name")
    private String fileName; // 文件名称
    @TableField(value="engineering_type_id")
    private Long engineeringTypeId; // 工程类别
    @TableField(value="area")
    private String area; // 地区
    @TableField(value="area_name")
    private String areaName; // 地区
    @TableField(value="address")
    private String address; // 地址
    @TableField(value="construct_name")
    private String constructName; // 建设单位
    @TableField(value="supervisor")
    private String supervisor; // 监理单位
    @TableField(value="designer")
    private String designer; // 编制单位
    @TableField(value="text_attachment")
    private String textAttachment; // 正文附件
    @TableField(value="text_attachment_id")
    private Long textAttachmentId; // 正文附件id
    @TableField(value="create_user_name")
    private String createUserName; // 创建人名称
    @TableField(value="submit_type")
    private Long submitType; // 文件报审类型
    @TableField(value="file_type")
    private Long fileType; // 文件分类
    @TableField(value="construct_id")
    private Long constructId; // 建设单位id
    @TableField(value="contract_manager")
    private Long contractManager;//epc总承包中心负责人

    @TableField(exist = false)
    @SubEntity(serviceName = "designOpinionInfoService")
    private List<DesignOpinionInfoEntity> opinionInfoList; // 意见栏
    
    
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }

    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public String getConstructName() {
        return constructName;
    }

    public void setConstructName(String constructName) {
        this.constructName = constructName;
    }
    public String getSupervisor() {
        return supervisor;
    }

    public void setSupervisor(String supervisor) {
        this.supervisor = supervisor;
    }
    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }
    public String getTextAttachment() {
        return textAttachment;
    }

    public void setTextAttachment(String textAttachment) {
        this.textAttachment = textAttachment;
    }
    public Long getTextAttachmentId() {
        return textAttachmentId;
    }

    public void setTextAttachmentId(Long textAttachmentId) {
        this.textAttachmentId = textAttachmentId;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getSubmitType() {
        return submitType;
    }

    public void setSubmitType(Long submitType) {
        this.submitType = submitType;
    }
    public Long getFileType() {
        return fileType;
    }

    public void setFileType(Long fileType) {
        this.fileType = fileType;
    }

    public List<DesignOpinionInfoEntity> getOpinionInfoList() {
        return opinionInfoList;
    }

    public void setOpinionInfoList(List<DesignOpinionInfoEntity> opinionInfoList) {
        this.opinionInfoList = opinionInfoList;
    }

    public Long getConstructId() {
        return constructId;
    }

    public void setConstructId(Long constructId) {
        this.constructId = constructId;
    }

    public Long getContractManager() {
        return contractManager;
    }

    public void setContractManager(Long contractManager) {
        this.contractManager = contractManager;
    }
}
