package com.ejianc.ztpc.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.ztpc.bean.BillcodeCategoryEntity;
import com.ejianc.ztpc.bean.ConSchemePlanEntity;
import com.ejianc.ztpc.service.IBillcodeCategoryService;
import com.ejianc.ztpc.service.IBillcodeRuleSnService;
import com.ejianc.ztpc.vo.*;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.ztpc.bean.DrawingCheckEntity;
import com.ejianc.ztpc.service.IDrawingCheckService;

/**
 * 图纸会检表
 *
 * @author generator
 */
@Controller
@RequestMapping("drawingCheck")
public class DrawingCheckController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZTPCCT_DRAWINGCHECK";//此处需要根据实际修改

    @Autowired
    private IDrawingCheckService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillcodeCategoryService billcodeCategoryService;
    @Autowired
    private IBillcodeRuleSnService billcodeRuleSnService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DrawingCheckVO> saveOrUpdate(@RequestBody DrawingCheckVO saveOrUpdateVO) {
        DrawingCheckEntity entity = BeanMapper.map(saveOrUpdateVO, DrawingCheckEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setEffectiveness("N");
        }
        BillcodeApiVO billcodeApi = getBillcodeApi(saveOrUpdateVO);
        CommonResponse<BillcodeApiVO> billcodeApiVOCommonResponse = null;
        if (billcodeApi != null){
            try {
                billcodeApiVOCommonResponse = billcodeRuleSnService.generateBillcode(billcodeApi);
                if (billcodeApiVOCommonResponse.isSuccess()){
                    List<BillcodeRuleSnVO> snList = billcodeApiVOCommonResponse.getData().getSnList();
                    for (BillcodeRuleSnVO codeSnVO : snList) {
                        entity.setOutsideCode(codeSnVO.getGenerateBillCode());
                    }
                }
            }catch (Exception e){
                logger.info(e.getMessage());
            }
        }
        if (billcodeApiVOCommonResponse != null && (billcodeApiVOCommonResponse.getCode() == 999  || billcodeApiVOCommonResponse.isSuccess())) {
            boolean b = service.saveOrUpdate(entity, false);
            if (b && billcodeApiVOCommonResponse.isSuccess()) {
                //业务单据保持成功后，提交取号
                BillcodeApiVO responseData = billcodeApiVOCommonResponse.getData();
                billcodeRuleSnService.commitBillcode(responseData);
            }
        }else {
            if (billcodeApiVOCommonResponse == null) {
                return CommonResponse.error("取号失败");
            }else {
                return CommonResponse.error("取号失败:"+billcodeApiVOCommonResponse.getMsg());
            }
        }
        DrawingCheckVO vo = BeanMapper.map(entity, DrawingCheckVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    public BillcodeApiVO getBillcodeApi(DrawingCheckVO vo){
        BillcodeApiVO billcodeApiVO = new BillcodeApiVO();
        billcodeApiVO.setProjectId(vo.getProjectId());
        billcodeApiVO.setProjectCode(vo.getProjectCode());
        billcodeApiVO.setProjectName(vo.getProjectName());
        BillcodeCategoryEntity category = billcodeCategoryService.getOne(
                new QueryWrapper<BillcodeCategoryEntity>().lambda()
                        .eq(BillcodeCategoryEntity::getDr, 0)
                        .eq(BillcodeCategoryEntity::getEnableStatus, 1)
                        .eq(BillcodeCategoryEntity::getCode, "ct_drawing_check")
        );
        if (category == null){
            return null;
        }
        billcodeApiVO.setCategoryId(category.getId());

        List<BillcodeRuleSnVO> snVOList  = new ArrayList<>();
        billcodeApiVO.setSnList(snVOList);
        BillcodeRuleSnVO billcodeRuleSnVO = new BillcodeRuleSnVO();
        snVOList.add(billcodeRuleSnVO);
        billcodeRuleSnVO.setSourcePid(vo.getId());
        billcodeRuleSnVO.setSourceCode(vo.getCode());
        billcodeRuleSnVO.setSourceType("BT230725000000003");
        billcodeRuleSnVO.setSourceTypeName("图纸会检");
        try {
            if (vo.getMgrp() != null){
                JSONArray mgrpReferValue = ReferObjectUtil.getReferEntityValue(vo.getMgrp() + "", "data-dictionary");
                JSONObject mgrpRef = (JSONObject) mgrpReferValue.get(0);
                billcodeRuleSnVO.setRule01(mgrpRef.getString("code"));//机组
            }
            if (vo.getLocationCode() != null) {
                JSONArray locationReferValue = ReferObjectUtil.getReferEntityValue(vo.getLocationCode() + "", "data-dictionary-category");
                JSONObject locationRef = (JSONObject) locationReferValue.get(0);
                billcodeRuleSnVO.setRule02(locationRef.getString("code"));//区域定位码
            }
        }catch (Exception e){
            logger.info(e.getMessage());
            throw new BusinessException("referCode转换错误");
        }
        return billcodeApiVO;
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DrawingCheckVO> queryDetail(Long id) {
        DrawingCheckEntity entity = service.selectById(id);
        DrawingCheckVO vo = BeanMapper.map(entity, DrawingCheckVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DrawingCheckVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DrawingCheckVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DrawingCheckVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DrawingCheckVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("jointTrialCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("jointTrialPlace");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        Parameter orgId = param.getParams().get("orgId");
        long parentOrgId = 0;
        if (orgId != null){
            parentOrgId = Long.parseLong(orgId.getValue().toString());
            param.getParams().remove("orgId");
        }else {
            parentOrgId = InvocationInfoProxy.getOrgId();
        }
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(parentOrgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parent_org_id", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<DrawingCheckEntity> page = service.queryPage(param, false);
        IPage<DrawingCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DrawingCheckVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DrawingCheckEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DrawingCheck-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refDrawingCheckData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DrawingCheckVO>> refDrawingCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DrawingCheckEntity> page = service.queryPage(param, false);
        IPage<DrawingCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DrawingCheckVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 确认
     *
     * @param ids 主键ID
     * @return 返回对象
     */
    @PostMapping("/affirm")
    @ResponseBody
    public CommonResponse<Void> affirm(@RequestBody List<Long> ids) {
        service.update(
                new UpdateWrapper<DrawingCheckEntity>()
                        .lambda()
                        .set(DrawingCheckEntity::getEffectiveness, "Y")
                        .eq(DrawingCheckEntity::getDr, 0)
                        .in(DrawingCheckEntity::getId, ids)
        );
        return CommonResponse.success();
    }

    /**
     * 图表会签导入模板下载
     *
     * @param request  请求头对象
     * @param response 返回体对象
     */
    @RequestMapping(value = "/downloadDrawingCheckTemplate")
    @ResponseBody
    public void downloadDrawingCheckTemplate(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "drawing-check-import.xlsx", "图表会签导入模板");
    }

    /**
     * 图表会签导入-校验数据
     *
     * @param request 请求头对象
     * @return 返回对象
     */
    @RequestMapping(value = "/excelDrawingCheckImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelDrawingCheckImport(HttpServletRequest request) {
        return service.excelDrawingCheckImport(request);
    }

    /**
     * 图表会签导入-保存
     *
     * @param importVos 待保存的数据
     * @return
     */
    @RequestMapping(value = "/saveImportExcelDrawingCheck", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Void> saveImportExcelDrawingCheck(@RequestBody List<DrawingCheckImportVO> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error("导入的数据为空！");
        }
        List<DrawingCheckEntity> list = Lists.newArrayList();

        importVos.forEach(importVO -> {
            DrawingCheckEntity entity = BeanMapper.map(importVO, DrawingCheckEntity.class);
            entity.setId(IdWorker.getId());
            /*
             * 生成单据编码
             */
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), importVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            list.add(entity);
        });
        // 保存
        service.saveBatch(list, list.size());
        return CommonResponse.success("保存成功！");
    }
}
