package com.ejianc.ztpc.service.impl;

import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.bpm.vo.BpmApproveHistoryInfo;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.ztpc.bean.ConstructionSchemeEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.ztpc.mapper.OpinionInfoMapper;
import com.ejianc.ztpc.bean.OpinionInfoEntity;
import com.ejianc.ztpc.service.IOpinionInfoService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 意见栏
 * 
 * @author generator
 * 
 */
@Service("opinionInfoService")
public class OpinionInfoServiceImpl extends BaseServiceImpl<OpinionInfoMapper, OpinionInfoEntity> implements IOpinionInfoService{

    @Autowired
    private IBpmApi bpmApi;

    @Override
    public Map<String, Object> toWordMap(ConstructionSchemeEntity entity, List<Long> ids) {
        CommonResponse<List<BpmApproveHistoryInfo>> response = bpmApi.queryHistoryById(entity.getId());
        if (!response.isSuccess()){
            throw new BusinessException(response.getMsg());
        }
        Map<String, Object> map = new HashMap<>();
        map.put("projectName", entity.getProjectName());
        map.put("consSchemeName", entity.getConsSchemeName());
        List<Map<String,Object>> listSubs=new ArrayList<>();
        if(entity.getOpinionInfoList()!=null){
            if(entity.getOpinionInfoList().size()!=0) {
                for (int i = 0; i < entity.getOpinionInfoList().size(); i++) {
                    if (ids.contains(entity.getOpinionInfoList().get(i).getId())) {
                        Map<String, Object> map1 = new HashMap();
                        OpinionInfoEntity info = entity.getOpinionInfoList().get(i);
                        map1.put("relativeChapter", info.getRelativeChapter());
                        map1.put("originalContent", info.getOriginalContent());
                        map1.put("editOpinion", info.getEditOpinion());
                        map1.put("reminderContentId", info.getReminderContentId()==null?null:info.getReminderContentId()==0?"必改项":"建议项");
                        map1.put("whetherAccept", StringUtils.isEmpty(info.getWhetherAccept()) ? "" : "Y".equals(info.getWhetherAccept()) ? "是":"否");
                        map1.put("proposeUserName", info.getProposeUserName());
                        Integer conclusionId = info.getCertificationConclusionId();
                        map1.put("certificationConclusionId",
                                conclusionId == null ? "":conclusionId.equals(0) ? "通过":conclusionId.equals(2) ? "修改后通过":"不通过"
                        );
                        map1.put("index", i + 1);
                        listSubs.add(map1);
                    }
                }
            }
        }

        List<Map<String,Object>> approverList =new ArrayList<>();
        for (int i = 0; i < response.getData().size(); i++) {
            Map<String, Object> historyMap = new HashMap<>();
            BpmApproveHistoryInfo historyInfo = response.getData().get(i);
            historyMap.put("approver",historyInfo.getApprover());
            historyMap.put("index",i+1);
            historyMap.put("approveInfo",historyInfo.getApproveInfo());
            historyMap.put("approvalOutcome",historyInfo.getApprovalOutcome());
            approverList.add(historyMap);
        }
        map.put("approverList",approverList);

        map.put("list",listSubs);

        for (String s : map.keySet()) {
            map.putIfAbsent(s, "");
        }

        return map;
    }
}
