package com.ejianc.ztpc.controller;

import cn.afterturn.easypoi.entity.ImageEntity;
import cn.afterturn.easypoi.word.WordExportUtil;
import cn.afterturn.easypoi.word.entity.MyXWPFDocument;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.ztpc.bean.*;
import com.ejianc.ztpc.enumUtils.ConOrgDesignStateEnum;
import com.ejianc.ztpc.mapper.UserSignatureMapper;
import com.ejianc.ztpc.service.IConOrgDesignPlanService;
import com.ejianc.ztpc.service.ICtConOrgDesignService;
import com.ejianc.ztpc.service.IOpinionInfoService;
import com.ejianc.ztpc.service.ISignatureUserService;
import com.ejianc.ztpc.util.DocOpinionExportUtil;
import com.ejianc.ztpc.vo.ApproverVO;
import com.ejianc.ztpc.vo.CtConOrgDesignVO;
import com.ejianc.ztpc.vo.ExportApproverVO;
import com.ejianc.ztpc.vo.SignatureDataVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 施工组织设计表
 *
 * @author generator
 */
@Controller
@RequestMapping("ctConOrgDesign")
public class CtConOrgDesignController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZTPCCT_CTCONORGDESIGN";//此处需要根据实际修改

    @Autowired
    private ICtConOrgDesignService service;
    @Autowired
    private IOpinionInfoService opinionInfoService;
    private DocOpinionExportUtil opinionExportUtil = DocOpinionExportUtil.getDocOpinionExportUtil();
    @Autowired
    private IBpmApi bpmApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private UserSignatureMapper userSignatureMapper;
    @Autowired
    private ISignatureUserService signatureUserService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IConOrgDesignPlanService conOrgDesignPlanService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CtConOrgDesignVO> saveOrUpdate(@RequestBody CtConOrgDesignVO saveOrUpdateVO) {
        /*
         * 1.判断该施工组织设计清单是否使用
         */
//        ConOrgDesignPlanEntity conOrgDesignPlanEntity = conOrgDesignPlanService.getOne(
//                new QueryWrapper<ConOrgDesignPlanEntity>()
//                        .lambda()
//                        .eq(ConOrgDesignPlanEntity::getDr, 0)
//                        .eq(ConOrgDesignPlanEntity::getId, saveOrUpdateVO.getOrgDesignPlanId())
////                        .eq(ConOrgDesignPlanEntity::getState, ConOrgDesignStateEnum.THREE.getCode())
//                        .last("LIMIT 1")
//        );
        if (saveOrUpdateVO.getBillState() == null || saveOrUpdateVO.getBillState() == 0) {
            CtConOrgDesignEntity ctConOrgDesignEntity = service.getOne(
                    new QueryWrapper<CtConOrgDesignEntity>().lambda()
                            .eq(CtConOrgDesignEntity::getOrgDesignPlanId, saveOrUpdateVO.getOrgDesignPlanId())
                            .ne(CtConOrgDesignEntity::getId, saveOrUpdateVO.getId())
                            .eq(CtConOrgDesignEntity::getDr, 0)
                            .last(" LIMIT 1 ")
            );
            if (Objects.nonNull(ctConOrgDesignEntity)) {
                return CommonResponse.error("该施工组织设计清单已使用！");
            }
        }
        CtConOrgDesignEntity entity = BeanMapper.map(saveOrUpdateVO, CtConOrgDesignEntity.class);
        entity.setFileState("N");
        /*
         * 2.生成单据编码
         */
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 3.保存
        service.saveOrUpdate(entity, false);
        CtConOrgDesignVO vo = BeanMapper.map(entity, CtConOrgDesignVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CtConOrgDesignVO> queryDetail(Long id) {
        CtConOrgDesignEntity entity = service.selectById(id);
        CtConOrgDesignVO vo = BeanMapper.map(entity, CtConOrgDesignVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CtConOrgDesignVO> vos) {
        service.removeByIds(vos.stream().map(CtConOrgDesignVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CtConOrgDesignVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgDesignPlanName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        Parameter orgId = param.getParams().get("orgId");
        long parentOrgId = 0;
        if (orgId != null) {
            parentOrgId = Long.parseLong(orgId.getValue().toString());
            param.getParams().remove("orgId");
        } else {
            parentOrgId = InvocationInfoProxy.getOrgId();
        }
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(parentOrgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<CtConOrgDesignEntity> page = service.queryPage(param, false);
        IPage<CtConOrgDesignVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CtConOrgDesignVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CtConOrgDesignEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CtConOrgDesign-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refCtConOrgDesignData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CtConOrgDesignVO>> refCtConOrgDesignData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CtConOrgDesignEntity> page = service.queryPage(param, false);
        IPage<CtConOrgDesignVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CtConOrgDesignVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 升版
     *
     * @param vo 待升版的数据
     * @return 返回结果
     */
    @PostMapping("/upgrade")
    @ResponseBody
    public CommonResponse<Boolean> upgrade(@RequestBody CtConOrgDesignVO vo) {
        CtConOrgDesignEntity entity = BeanMapper.map(vo, CtConOrgDesignEntity.class);
        entity.setId(null);
        entity.setCreateUserCode(null);
        entity.setCreateTime(null);
        entity.setFileState("N");
        entity.setState(null);
        entity.setStateName(null);
        entity.setBillState(null);
        entity.setCompilePerson(null);
        entity.setCompilePersonName(null);
        entity.setApproverPerson(null);
        entity.setApproverPersonName(null);
        entity.setOpinionInfoList(null);
        return CommonResponse.success(service.saveOrUpdate(entity, false));
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExportOpinion", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportOpinion(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        List<OpinionInfoEntity> list = opinionInfoService.queryList(param);
        //todo:字段翻译等等
        CtConOrgDesignEntity entity = null;
        Map<String, Object> wordMap = null;
        if (list == null || list.size() == 0) {
            return;
        }
        entity = service.selectById(list.get(0).getPid());
        String id = "";
        if (param.getParams().get("id") != null) {
            id = param.getParams().get("id").getValue().toString();
        }
        if (id == null || id == "") {
            return;
        }
        String[] idStrings = id.substring(1, id.length() - 1).split(",");
        List<Long> ids = new ArrayList<>();
        for (String str : idStrings) {
            try {
                ids.add(Long.parseLong(str.trim()));
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        opinionExportUtil.exportDoc(entity, response, ids, "/excel/ctConOrgDesign-opinion-export.docx", bpmApi, "name", entity.getId());
    }

    /**
     * @param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExportSignature", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSignature(@RequestBody ExportApproverVO approver, @RequestParam Integer type, HttpServletResponse response) {
        int height = 40;
        int width = 80;
        CtConOrgDesignEntity entity = service.selectById(approver.getId());
        List<SignatureUserEntity> list = signatureUserService.list(
                new QueryWrapper<SignatureUserEntity>().lambda()
                        .eq(SignatureUserEntity::getDr, 0)
        );
        Map<String, Object> wordMap = BeanMapper.map(entity, Map.class);
        String resource = "";
        if (type == 1) {
            resource = "/excel/con-org-design-signature.docx";
        } else if (type == 2) {
            boolean contains = approver.getApproverList().stream().anyMatch(value -> "办公室审批".equals(value.getActivityName()) || "办公室".equals(value.getActivityName()));
            if (contains) {
                resource = "/excel/con-org-design-signature-stamp.docx";
            } else {
                throw new BusinessException("印章未经办公室审批");
            }
        } else if (type == 3) {
            resource = "/excel/con-org-design-signature-unit.docx";
        } else if (type == 4) {
            boolean contains = approver.getApproverList().stream().anyMatch(value -> "办公室审批".equals(value.getActivityName()) || "办公室".equals(value.getActivityName()));
            if (contains) {
                resource = "/excel/con-org-design-signature-unit-stamp.docx";
            } else {
                throw new BusinessException("印章未经办公室审批");
            }
        }

        for (ApproverVO approverVO : approver.getApproverList()) {
            Long approveUserId = approverVO.getApproveUserId();
            String approveUserName = approverVO.getApproveUserName();
            String approveUserDeptName = approverVO.getApproveUserDeptName();
            String activityName = approverVO.getActivityName();
            if ("项目管理部".equals(activityName)) {
                if ("单官伟".equals(approveUserName)) {
                    CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(approveUserId);
                    if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                        UserVO user = userByUserId.getData();
                        SignatureDataVO dataByUserCode = userSignatureMapper.getDataByUserCode(user.getUserCode());
                        ImageEntity image = new ImageEntity();
                        image.setHeight(height);
                        image.setWidth(width);
                        if (dataByUserCode != null) {
                            image.setData(dataByUserCode.getImage());
                        }
                        image.setType(ImageEntity.Data);
                        wordMap.put("xmglb", image);
                    }
                }
            } else if ("QHSE部".equals(activityName)) {
                for (SignatureUserEntity signatureUserEntity : list) {
                    if (signatureUserEntity.getUserId().equals(approveUserId)) {
                        if ("QHSE部（质量）".equals(signatureUserEntity.getDeptName())) {
                            CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(approveUserId);
                            if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                                UserVO user = userByUserId.getData();
                                SignatureDataVO dataByUserCode = userSignatureMapper.getDataByUserCode(user.getUserCode());
                                ImageEntity image = new ImageEntity();
                                image.setHeight(height);
                                image.setWidth(width);
                                if (dataByUserCode != null) {
                                    image.setData(dataByUserCode.getImage());
                                }
                                image.setType(ImageEntity.Data);
                                wordMap.put("quality", image);
                            }
                        } else if ("QHSE部（安全）".equals(signatureUserEntity.getDeptName())) {
                            CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(approveUserId);
                            if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                                UserVO user = userByUserId.getData();
                                SignatureDataVO dataByUserCode = userSignatureMapper.getDataByUserCode(user.getUserCode());
                                ImageEntity image = new ImageEntity();
                                image.setHeight(height);
                                image.setWidth(width);
                                if (dataByUserCode != null) {
                                    image.setData(dataByUserCode.getImage());
                                }
                                image.setType(ImageEntity.Data);
                                wordMap.put("safe", image);
                            }
                        }
                    }
                }
            } else if ("分管领导".equals(activityName)) {
                CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(approveUserId);
                if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                    UserVO user = userByUserId.getData();
                    SignatureDataVO dataByUserCode = userSignatureMapper.getDataByUserCode(user.getUserCode());
                    ImageEntity image = new ImageEntity();
                    image.setHeight(height);
                    image.setWidth(width);
                    if (dataByUserCode != null) {
                        image.setData(dataByUserCode.getImage());
                    }
                    image.setType(ImageEntity.Data);
                    wordMap.put("leader", image);
                }
            }
        }


        try {
            try (

                    InputStream resourceAsStream = getClass().getResourceAsStream(resource);
            ) {
                XWPFDocument document = new MyXWPFDocument(resourceAsStream);
                WordExportUtil.exportWord07(document, wordMap);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    document.write(out);
                    out.close();

                } catch (IOException e) {
                    e.printStackTrace();
                }

                // 获取二进制数据
                byte[] fileData = out.toByteArray();

                // 设置HTTP响应头，告诉前端返回的是一个Word文档
                response.setContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
                String fileName = "封面.docx";
                response.setHeader("Content-Disposition", "attachment; filename=" + fileName);

                // 将字节数组写入到response的输出流中
                try (ByteArrayInputStream bais = new ByteArrayInputStream(fileData)) {
                    byte[] buffer = new byte[1024];
                    int bytesRead;
                    while ((bytesRead = bais.read(buffer)) != -1) {
                        response.getOutputStream().write(buffer, 0, bytesRead);
                    }
                    response.flushBuffer();
                } catch (IOException e) {
                    e.printStackTrace();
                    // 处理异常，确保资源被正确关闭等
                    // 这里你可能需要返回一个错误响应给前端
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
