package com.ejianc.ztpc.controller;

import java.io.*;

import cn.afterturn.easypoi.entity.ImageEntity;
import cn.afterturn.easypoi.word.WordExportUtil;
import cn.afterturn.easypoi.word.entity.MyXWPFDocument;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.ztpc.bean.OpinionInfoEntity;
import com.ejianc.ztpc.bean.ProjectManagePlanEntity;
import com.ejianc.ztpc.mapper.UserSignatureMapper;
import com.ejianc.ztpc.service.IOpinionInfoService;
import com.ejianc.ztpc.service.ISignatureUserService;
import com.ejianc.ztpc.util.DocOpinionExportUtil;
import com.ejianc.ztpc.vo.ApproverVO;
import com.ejianc.ztpc.vo.ExportApproverVO;
import com.ejianc.ztpc.vo.SignatureDataVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.ztpc.bean.ProjectImplementPlanEntity;
import com.ejianc.ztpc.service.IProjectImplementPlanService;
import com.ejianc.ztpc.vo.ProjectImplementPlanVO;

/**
 * 项目实施计划表
 *
 * @author generator
 */
@Controller
@RequestMapping("projectImplementPlan")
public class ProjectImplementPlanController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZTPCCT_PROJECTIMPPLAN";//此处需要根据实际修改

    @Autowired
    private IProjectImplementPlanService service;
    @Autowired
    private IOpinionInfoService opinionInfoService;
    private DocOpinionExportUtil opinionExportUtil = DocOpinionExportUtil.getDocOpinionExportUtil();
    @Autowired
    private IBpmApi bpmApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private UserSignatureMapper userSignatureMapper;
    @Autowired
    private ISignatureUserService signatureUserService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectImplementPlanVO> saveOrUpdate(@RequestBody ProjectImplementPlanVO saveOrUpdateVO) {
        ProjectImplementPlanEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectImplementPlanEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        ProjectImplementPlanVO vo = BeanMapper.map(entity, ProjectImplementPlanVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectImplementPlanVO> queryDetail(Long id) {
        ProjectImplementPlanEntity entity = service.selectById(id);
        ProjectImplementPlanVO vo = BeanMapper.map(entity, ProjectImplementPlanVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectImplementPlanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjectImplementPlanVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ProjectImplementPlanVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectImplementPlanVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        Parameter orgId = param.getParams().get("orgId");
        long parentOrgId = 0;
        if (orgId != null) {
            parentOrgId = Long.parseLong(orgId.getValue().toString());
            param.getParams().remove("orgId");
        } else {
            parentOrgId = InvocationInfoProxy.getOrgId();
        }
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(parentOrgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ProjectImplementPlanEntity> page = service.queryPage(param, false);
        IPage<ProjectImplementPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectImplementPlanVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProjectImplementPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectImplementPlan-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refProjectImplementPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectImplementPlanVO>> refProjectImplementPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                     String condition,
                                                                                     String searchObject,
                                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProjectImplementPlanEntity> page = service.queryPage(param, false);
        IPage<ProjectImplementPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectImplementPlanVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExportOpinion", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportOpinion(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        List<OpinionInfoEntity> list = opinionInfoService.queryList(param);
        //todo:字段翻译等等
        ProjectImplementPlanEntity entity = null;
        Map<String, Object> wordMap = null;
        if (list == null || list.size() == 0) {
            return;
        }
        entity = service.selectById(list.get(0).getPid());
        String id = "";
        if (param.getParams().get("id") != null) {
            id = param.getParams().get("id").getValue().toString();
        }
        if (id == null || id == "") {
            return;
        }
        String[] idStrings = id.substring(1, id.length() - 1).split(",");
        List<Long> ids = new ArrayList<>();
        for (String str : idStrings) {
            try {
                ids.add(Long.parseLong(str.trim()));
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        opinionExportUtil.exportDoc(entity, response, ids, "/excel/projectImplementPlan-opinion-export.docx", bpmApi, "fileName", entity.getId());
    }

    /**
     * @param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExportSignature", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSignature(@RequestBody ExportApproverVO approver, @RequestParam Integer type, HttpServletResponse response) {
        int height = 40;
        int width = 80;
        ProjectImplementPlanEntity entity = service.selectById(approver.getId());
        Map<String, Object> wordMap = BeanMapper.map(entity, Map.class);
        String resource = "";
        if (type == 1) {
            resource = "/excel/project-implement-plan-signature.docx";
        } else if (type == 2) {
            boolean contains = approver.getApproverList().stream().anyMatch(value -> "办公室审批".equals(value.getActivityName()));
            if (contains) {
                resource = "/excel/project-implement-plan-signature-stamp.docx";
            } else {
                throw new BusinessException("印章未经办公室审批");
            }
        } else if (type == 3) {
            resource = "/excel/project-implement-plan-signature-unit.docx";
        } else if (type == 4) {
            boolean contains = approver.getApproverList().stream().anyMatch(value -> "办公室审批".equals(value.getActivityName()));
            if (contains) {
                resource = "/excel/project-implement-plan-signature-unit-stamp.docx";
            } else {
                throw new BusinessException("印章未经办公室审批");
            }
        }

        for (ApproverVO approverVO : approver.getApproverList()) {
            Long approveUserId = approverVO.getApproveUserId();
            String approveUserName = approverVO.getApproveUserName();
            String approveUserDeptName = approverVO.getApproveUserDeptName();
            String activityName = approverVO.getActivityName();
            if ("项目管理部".equals(activityName)) {
                if ("熊心韬".equals(approveUserName)) {
                    CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(approveUserId);
                    if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                        UserVO user = userByUserId.getData();
                        SignatureDataVO dataByUserCode = userSignatureMapper.getDataByUserCode(user.getUserCode());
                        ImageEntity image = new ImageEntity();
                        image.setHeight(height);
                        image.setWidth(width);
                        if (dataByUserCode != null) {
                            image.setData(dataByUserCode.getImage());
                        }
                        image.setType(ImageEntity.Data);
                        wordMap.put("xmglb", image);
                    }
                }
            } else if ("党群工作部".equals(activityName)) {
                CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(approveUserId);
                if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                    UserVO user = userByUserId.getData();
                    SignatureDataVO dataByUserCode = userSignatureMapper.getDataByUserCode(user.getUserCode());
                    ImageEntity image = new ImageEntity();
                    image.setHeight(height);
                    image.setWidth(width);
                    if (dataByUserCode != null) {
                        image.setData(dataByUserCode.getImage());
                    }
                    image.setType(ImageEntity.Data);
                    wordMap.put("dqgzb", image);
                }

            } else if ("财务产权部".equals(activityName)) {
                CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(approveUserId);
                if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                    UserVO user = userByUserId.getData();
                    SignatureDataVO dataByUserCode = userSignatureMapper.getDataByUserCode(user.getUserCode());
                    ImageEntity image = new ImageEntity();
                    image.setHeight(height);
                    image.setWidth(width);
                    if (dataByUserCode != null) {
                        image.setData(dataByUserCode.getImage());
                    }
                    image.setType(ImageEntity.Data);
                    wordMap.put("cwcqb", image);
                }

            } else if ("EPC总承包中心".equals(activityName)) {
                CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(approveUserId);
                if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                    UserVO user = userByUserId.getData();
                    SignatureDataVO dataByUserCode = userSignatureMapper.getDataByUserCode(user.getUserCode());
                    ImageEntity image = new ImageEntity();
                    image.setHeight(height);
                    image.setWidth(width);
                    if (dataByUserCode != null) {
                        image.setData(dataByUserCode.getImage());
                    }
                    image.setType(ImageEntity.Data);
                    wordMap.put("epc", image);
                }

            } else if ("采购管理部".equals(activityName)) {
                CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(approveUserId);
                if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                    UserVO user = userByUserId.getData();
                    SignatureDataVO dataByUserCode = userSignatureMapper.getDataByUserCode(user.getUserCode());
                    ImageEntity image = new ImageEntity();
                    image.setHeight(height);
                    image.setWidth(width);
                    if (dataByUserCode != null) {
                        image.setData(dataByUserCode.getImage());
                    }
                    image.setType(ImageEntity.Data);
                    wordMap.put("cgglb", image);
                }

            } else if ("法务审计部".equals(activityName)) {
                CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(approveUserId);
                if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                    UserVO user = userByUserId.getData();
                    SignatureDataVO dataByUserCode = userSignatureMapper.getDataByUserCode(user.getUserCode());
                    ImageEntity image = new ImageEntity();
                    image.setHeight(height);
                    image.setWidth(width);
                    if (dataByUserCode != null) {
                        image.setData(dataByUserCode.getImage());
                    }
                    image.setType(ImageEntity.Data);
                    wordMap.put("fwsjb", image);
                }

            } else if ("安全监察部".equals(activityName)) {
                CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(approveUserId);
                if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                    UserVO user = userByUserId.getData();
                    SignatureDataVO dataByUserCode = userSignatureMapper.getDataByUserCode(user.getUserCode());
                    ImageEntity image = new ImageEntity();
                    image.setHeight(height);
                    image.setWidth(width);
                    if (dataByUserCode != null) {
                        image.setData(dataByUserCode.getImage());
                    }
                    image.setType(ImageEntity.Data);
                    wordMap.put("aqjcb", image);
                }

            }else if ("QA/QC部".equals(activityName)) {
                CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(approveUserId);
                if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                    UserVO user = userByUserId.getData();
                    SignatureDataVO dataByUserCode = userSignatureMapper.getDataByUserCode(user.getUserCode());
                    ImageEntity image = new ImageEntity();
                    image.setHeight(height);
                    image.setWidth(width);
                    if (dataByUserCode != null) {
                        image.setData(dataByUserCode.getImage());
                    }
                    image.setType(ImageEntity.Data);
                    wordMap.put("qaqc", image);
                }

            }else if ("QHSE部".equals(activityName)) {
                //兼容历史数据
                if(!wordMap.containsKey("qaqc")){
                    CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(approveUserId);
                    if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                        UserVO user = userByUserId.getData();
                        SignatureDataVO dataByUserCode = userSignatureMapper.getDataByUserCode(user.getUserCode());
                        ImageEntity image = new ImageEntity();
                        image.setHeight(height);
                        image.setWidth(width);
                        if (dataByUserCode != null) {
                            image.setData(dataByUserCode.getImage());
                        }
                        image.setType(ImageEntity.Data);
                        wordMap.put("qaqc", image);
                    }
                }
            } else if ("合同管理部".equals(activityName)) {
                CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(approveUserId);
                if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                    UserVO user = userByUserId.getData();
                    SignatureDataVO dataByUserCode = userSignatureMapper.getDataByUserCode(user.getUserCode());
                    ImageEntity image = new ImageEntity();
                    image.setHeight(height);
                    image.setWidth(width);
                    if (dataByUserCode != null) {
                        image.setData(dataByUserCode.getImage());
                    }
                    image.setType(ImageEntity.Data);
                    wordMap.put("htglb", image);
                }

            } else if ("人力资源部".equals(activityName)) {
                CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(approveUserId);
                if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                    UserVO user = userByUserId.getData();
                    SignatureDataVO dataByUserCode = userSignatureMapper.getDataByUserCode(user.getUserCode());
                    ImageEntity image = new ImageEntity();
                    image.setHeight(height);
                    image.setWidth(width);
                    if (dataByUserCode != null) {
                        image.setData(dataByUserCode.getImage());
                    }
                    image.setType(ImageEntity.Data);
                    wordMap.put("rlzyb", image);
                }

            } else if ("办公室".equals(activityName)) {
                CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(approveUserId);
                if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                    UserVO user = userByUserId.getData();
                    SignatureDataVO dataByUserCode = userSignatureMapper.getDataByUserCode(user.getUserCode());
                    ImageEntity image = new ImageEntity();
                    image.setHeight(height);
                    image.setWidth(width);
                    if (dataByUserCode != null) {
                        image.setData(dataByUserCode.getImage());
                    }
                    image.setType(ImageEntity.Data);
                    wordMap.put("bgs", image);
                }
            } else if ("分管领导".equals(activityName)) {
                CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(approveUserId);
                if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                    UserVO user = userByUserId.getData();
                    SignatureDataVO dataByUserCode = userSignatureMapper.getDataByUserCode(user.getUserCode());
                    ImageEntity image = new ImageEntity();
                    image.setHeight(height);
                    image.setWidth(width);
                    if (dataByUserCode != null) {
                        image.setData(dataByUserCode.getImage());
                    }
                    image.setType(ImageEntity.Data);
                    wordMap.put("leader", image);
                }
            }
        }


        try {
            try (

                    InputStream resourceAsStream = getClass().getResourceAsStream(resource);
            ) {
                XWPFDocument document = new MyXWPFDocument(resourceAsStream);
                WordExportUtil.exportWord07(document, wordMap);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    document.write(out);
                    out.close();

                } catch (IOException e) {
                    e.printStackTrace();
                }

                // 获取二进制数据
                byte[] fileData = out.toByteArray();

                // 设置HTTP响应头，告诉前端返回的是一个Word文档
                response.setContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
                String fileName = "封面.docx";
                response.setHeader("Content-Disposition", "attachment; filename=" + fileName);

                // 将字节数组写入到response的输出流中
                try (ByteArrayInputStream bais = new ByteArrayInputStream(fileData)) {
                    byte[] buffer = new byte[1024];
                    int bytesRead;
                    while ((bytesRead = bais.read(buffer)) != -1) {
                        response.getOutputStream().write(buffer, 0, bytesRead);
                    }
                    response.flushBuffer();
                } catch (IOException e) {
                    e.printStackTrace();
                    // 处理异常，确保资源被正确关闭等
                    // 这里你可能需要返回一个错误响应给前端
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
