package com.ejianc.ztpc.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * 施工方案编制计划表
 *
 * @author generator
 */
public class ConSchemePlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String code; // 编码
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 项目组织ID
    private String orgCode; // 项目组织编码
    private String orgName; // 项目组织名称
    private Long parentOrgId; // 父级组织ID
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private String consSchemeName; // 施工方案名称
    private Long consSchemeType; // 施工方案类别--字典ct_cons_scheme_type
    private Long engineeringTypeId; // 工程类别
    private Long specialtyType; // 专业分类--字典ct_specialty_type
    private Long projectLeave; // 项目分级(自定义档案)
    private String executeState; // 执行状态
    private String executeStateName; // 执行状态名称
    private String approvalPower; // 批准权限
    private Long redactDept; // 编制部门
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planRedactDate; // 计划编制时间
    private String planRedactDateStr; //计划编制时间字符串
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date redactFinishDate; // 编制完成时间
    private String redactFinishDateStr; //编制完成时间字符串
    private String orgExpertExamine; // 组织专家审查要求（Y：是，N：否）
    private String consTimeFrame; // 施工时段

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishConsSchemeDate; // 完成施工方案时间
    private String finishConsSchemeDateStr; //完成施工方案时间字符串
    private Long projectTrait; // 分部分项工程特征--字典ct_project_trait
    private String keyPointExplain; // 专项施工方案关注重点
    private String outsideCode;//外部编码
    private Long locationCode;//区域定位码
    private Long mgrp;//机组

    private List<String> consTimeFrameList; // 施工时段数组

    private Map<String, Long> totalMap;//各个类型施工方案编制计划的数量

    private String specialTypeName;//专业分类字典查询后名称

    private String consSchemeTypeName; //施工方案类别名称

    private String projectTraitName; //分部分项工程特征名称
    private String compilationUnit; //编制单位
    private String reviewRequirements; //评审要求
    private String projectRange; //超过一定规模的危险性较大的分部分项工程范围
    private String memo; //备注
    private String subItemName; //分部分项工程名称

    public String getPlanRedactDateStr() {
        return planRedactDateStr;
    }

    public void setPlanRedactDateStr(String planRedactDateStr) {
        this.planRedactDateStr = planRedactDateStr;
    }

    public String getRedactFinishDateStr() {
        return redactFinishDateStr;
    }

    public void setRedactFinishDateStr(String redactFinishDateStr) {
        this.redactFinishDateStr = redactFinishDateStr;
    }

    public String getFinishConsSchemeDateStr() {
        return finishConsSchemeDateStr;
    }

    public void setFinishConsSchemeDateStr(String finishConsSchemeDateStr) {
        this.finishConsSchemeDateStr = finishConsSchemeDateStr;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getConsSchemeName() {
        return consSchemeName;
    }

    public void setConsSchemeName(String consSchemeName) {
        this.consSchemeName = consSchemeName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getConsSchemeType() {
        return consSchemeType;
    }

    @ReferDeserialTransfer
    public void setConsSchemeType(Long consSchemeType) {
        this.consSchemeType = consSchemeType;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }

    @ReferDeserialTransfer
    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getSpecialtyType() {
        return specialtyType;
    }

    @ReferDeserialTransfer
    public void setSpecialtyType(Long specialtyType) {
        this.specialtyType = specialtyType;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProjectLeave() {
        return projectLeave;
    }

    @ReferDeserialTransfer
    public void setProjectLeave(Long projectLeave) {
        this.projectLeave = projectLeave;
    }

    public String getExecuteState() {
        return executeState;
    }

    public void setExecuteState(String executeState) {
        this.executeState = executeState;
    }

    public String getExecuteStateName() {
        return executeStateName;
    }

    public void setExecuteStateName(String executeStateName) {
        this.executeStateName = executeStateName;
    }

    public String getApprovalPower() {
        return approvalPower;
    }

    public void setApprovalPower(String approvalPower) {
        this.approvalPower = approvalPower;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getRedactDept() {
        return redactDept;
    }

    @ReferDeserialTransfer
    public void setRedactDept(Long redactDept) {
        this.redactDept = redactDept;
    }

    public Date getPlanRedactDate() {
        return planRedactDate;
    }

    public void setPlanRedactDate(Date planRedactDate) {
        this.planRedactDate = planRedactDate;
    }

    public Date getRedactFinishDate() {
        return redactFinishDate;
    }

    public void setRedactFinishDate(Date redactFinishDate) {
        this.redactFinishDate = redactFinishDate;
    }

    public String getOrgExpertExamine() {
        return orgExpertExamine;
    }

    public void setOrgExpertExamine(String orgExpertExamine) {
        this.orgExpertExamine = orgExpertExamine;
    }

    public String getConsTimeFrame() {
        return consTimeFrame;
    }

    public void setConsTimeFrame(String consTimeFrame) {
        this.consTimeFrame = consTimeFrame;
    }

    public Date getFinishConsSchemeDate() {
        return finishConsSchemeDate;
    }

    public void setFinishConsSchemeDate(Date finishConsSchemeDate) {
        this.finishConsSchemeDate = finishConsSchemeDate;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProjectTrait() {
        return projectTrait;
    }

    @ReferDeserialTransfer
    public void setProjectTrait(Long projectTrait) {
        this.projectTrait = projectTrait;
    }

    public String getKeyPointExplain() {
        return keyPointExplain;
    }

    public void setKeyPointExplain(String keyPointExplain) {
        this.keyPointExplain = keyPointExplain;
    }

    public List<String> getConsTimeFrameList() {
        return consTimeFrameList;
    }

    public void setConsTimeFrameList(List<String> consTimeFrameList) {
        this.consTimeFrameList = consTimeFrameList;
    }

    public Map<String, Long> getTotalMap() {
        return totalMap;
    }

    public void setTotalMap(Map<String, Long> totalMap) {
        this.totalMap = totalMap;
    }

    public String getOutsideCode() {
        return outsideCode;
    }

    public void setOutsideCode(String outsideCode) {
        this.outsideCode = outsideCode;
    }

    @ReferSerialTransfer(referCode = "data-dictionary-category")
    public Long getLocationCode() {
        return locationCode;
    }
    @ReferDeserialTransfer
    public void setLocationCode(Long locationCode) {
        this.locationCode = locationCode;
    }
    @ReferSerialTransfer(referCode = "data-dictionary")
    public Long getMgrp() {
        return mgrp;
    }
    @ReferDeserialTransfer
    public void setMgrp(Long mgrp) {
        this.mgrp = mgrp;
    }

    public String getSpecialTypeName() {
        return specialTypeName;
    }

    public void setSpecialTypeName(String specialTypeName) {
        this.specialTypeName = specialTypeName;
    }

    public String getConsSchemeTypeName() {
        return consSchemeTypeName;
    }

    public void setConsSchemeTypeName(String consSchemeTypeName) {
        this.consSchemeTypeName = consSchemeTypeName;
    }

    public String getProjectTraitName() {
        return projectTraitName;
    }

    public void setProjectTraitName(String projectTraitName) {
        this.projectTraitName = projectTraitName;
    }

    public String getCompilationUnit() {
        return compilationUnit;
    }

    public void setCompilationUnit(String compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public String getReviewRequirements() {
        return reviewRequirements;
    }

    public void setReviewRequirements(String reviewRequirements) {
        this.reviewRequirements = reviewRequirements;
    }

    public String getProjectRange() {
        return projectRange;
    }

    public void setProjectRange(String projectRange) {
        this.projectRange = projectRange;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getSubItemName() {
        return subItemName;
    }

    public void setSubItemName(String subItemName) {
        this.subItemName = subItemName;
    }
}
