package com.ejianc.ztpcdata.api;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.ztpcdata.hystrix.ExternalHystrix;
import com.ejianc.ztpcdata.vo.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

@FeignClient(name = "ejc-ztpcdata-web", url = "${common.env.feign-client-url}", path = "ejc-ztpcdata-web", fallback = ExternalHystrix.class)
//@FeignClient(name = "ejc-ztpcdata-web", url = "http://127.0..0.1:8080", path = "ejc-ztpcdata-web", fallback = ExternalHystrix.class)
public interface IExternalApi {
    @PostMapping("/external/getButton")
    public CommonResponse<List<ButtonVO>> getButton(@RequestBody Map<String, Object> params);

    @PostMapping("/external/getButtonCount")
    public CommonResponse<Integer> getButtonCount();

    @PostMapping("/external/getFileId")
    public CommonResponse<List<AttachmentVO>> getFileId(@RequestBody Map<String, Object> params);

    @PostMapping("/external/getByBizKey")
    public CommonResponse<List<ActRuTaskVO>> getByBizKey(@RequestParam("businessKey") String businessKey);

    @PostMapping("/external/getMyPageInfo")
    public CommonResponse<List<IdeModuleVO>> getMyPageInfo(@RequestParam("appId") String appId, @RequestParam("code") String code);

    @PostMapping("/external/getOrgIdByOrgCode")
    public CommonResponse<List<Long>> getOrgIdByOrgCode(@RequestParam("orgCode") String orgCode);

    @PostMapping("/external/getMapProjLocal")
    public CommonResponse<List<Map<String, Object>>> getMapProjLocal();

    @PostMapping("/external/queryAllDept")
    public CommonResponse<List<Map<String, Object>>> queryAllDept();

    @PostMapping("/external/queryAllDeptCondition")
    public CommonResponse<List<Map<String, Object>>> queryAllDeptCondition(@RequestParam("orgId") String orgId);

    @PostMapping("/external/getMapAllEmployee")
    public CommonResponse<List<Map<String, Object>>> getMapAllEmployee();

    @PostMapping("/external/getAttachmentBySourceIdAndSourceType")
    public CommonResponse<List<Map<String, Object>>> getAttachmentBySourceIdAndSourceType(@RequestParam("sourceId")Long sourceId,@RequestParam("sourceType")String sourceType);

    @PostMapping("/external/getOrgList")
    public CommonResponse<List<OrgVO>> getOrgList(@RequestParam("orgType")Integer orgType,@RequestParam("projectState")Integer projectState,@RequestParam("parentOrgId")Long parentOrgId);

    @PostMapping("/external/getEmployeeByName")
    CommonResponse<List<EmployeeVO>> getEmployeeByName(@RequestBody List<String> names);

    @PostMapping("/external/querySupplierByName")
    CommonResponse<List<SupplierVO>> querySupplierByName(@RequestParam("name")String name);
}
