package com.ejianc.idmdata.orgcenter.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.foundation.sync.vo.SyncEmployeeAndUserVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.idmdata.orgcenter.bean.IdmDeptEntity;
import com.ejianc.idmdata.orgcenter.bean.IdmEmployeeEntity;
import com.ejianc.idmdata.orgcenter.bean.IdmOrgEntity;
import com.ejianc.idmdata.orgcenter.service.IIdmDeptService;
import com.ejianc.idmdata.orgcenter.service.IIdmEmployeeService;
import com.ejianc.idmdata.orgcenter.service.IIdmOrgService;
import com.ejianc.idmdata.orgcenter.util.DateUtils;
import com.ejianc.idmdata.orgcenter.util.HttpClientUtil;
import com.ejianc.idmdata.orgcenter.util.SynDataBuilder;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.idmdata.orgcenter.mapper.IdmJobMapper;
import com.ejianc.idmdata.orgcenter.bean.IdmJobEntity;
import com.ejianc.idmdata.orgcenter.service.IIdmJobService;

import java.util.Date;

/**
 * 任职表
 * 
 * @author generator
 * 
 */
@Service("idmJobService")
public class IdmJobServiceImpl extends BaseServiceImpl<IdmJobMapper, IdmJobEntity> implements IIdmJobService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IIdmOrgService orgService;

    @Autowired
    private IIdmDeptService deptService;

    @Autowired
    private IIdmJobService jobService;

    @Autowired
    private IIdmEmployeeService employeeService;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private com.ejianc.foundation.sync.controller.api.SynEmpApi SynEmpApi;

    private long INTERVAL_TIME = 10000;//接口请求间隔时间
    private String job_url_param = "P-O62g0930";//兼职李璐同步参数
    private String user_code_param = "P-VQk2r027";//接口用户名
    private String password_param = "P-947I0928";//接口密码

    @Override
    public CommonResponse<String> synIdmJob(String type, String queryDESC1) {
        int totalPages = 1;//初始化查询页数为1

        CommonResponse<ParamRegisterSetVO> urlParam = paramConfigApi.getByCode(job_url_param);
        CommonResponse<ParamRegisterSetVO> userCodeParam = paramConfigApi.getByCode(user_code_param);
        CommonResponse<ParamRegisterSetVO> passWordParam = paramConfigApi.getByCode(password_param);

        String url = "";
        String userCode = "";
        String pwd = "";

        if(StringUtils.isBlank(urlParam.getData().getValueData()) ||
                StringUtils.isBlank(userCodeParam.getData().getValueData()) ||
                StringUtils.isBlank(passWordParam.getData().getValueData())){
            return CommonResponse.error("获取参数为空！");
        }else{
            url = urlParam.getData().getValueData();
            userCode = userCodeParam.getData().getValueData();
            pwd = passWordParam.getData().getValueData();
        }

        int addNum = 0;
        int updateNum = 0;
        for (int i = 1; i <= totalPages; i++) {
            String json = SynDataBuilder.getReqJson(i + "", type,"",queryDESC1);
            logger.info(i + "同步兼职记录查询参数为：" + json);

            try {
                if (i > 1) {
                    Thread.sleep(INTERVAL_TIME);
                }
            } catch (InterruptedException e) {

            }

            String returnStr = HttpClientUtil.doPostJson(url, json, userCode, pwd);
            if (returnStr == null || "".equals(returnStr)) {
                return CommonResponse.error("调用主数据接口失败！");
            }
            JSONObject returnJson = JSONObject.parseObject(returnStr);
            JSONObject esb = (JSONObject) returnJson.get("ESB");
            String status = esb.get("STATUS").toString();
            if (!"S".equals(status)) {
                return CommonResponse.error("调用主数据接口失败！");
            }
            JSONObject data = esb.getJSONObject("DATA");
            JSONObject splitPage = data.getJSONObject("SPLITPAGE");
            totalPages = splitPage.getInteger("TOTALPAGES");//总页数

            JSONObject dataInfos = data.getJSONObject("DATAINFOS");
            JSONArray dataInfoArr = dataInfos.getJSONArray("DATAINFO");

            /**========开始同步处理========**/
            QueryWrapper<IdmJobEntity> idmJobQuery1 = null;
            QueryWrapper<IdmDeptEntity> queryDeptWrapper1 = null;
            QueryWrapper<IdmOrgEntity> orgWrapper2 = null;
            IdmJobEntity idmJobEntity = null;
            IdmDeptEntity deptEntity = null;
            IdmOrgEntity orgEntity = null;
            IdmEmployeeEntity employeeEntity = null;

            for (Object obj : dataInfoArr) {
                JSONObject dataInfo = (JSONObject) obj;

                //查询系统中是否已经存在
                idmJobQuery1 = new QueryWrapper<>();
                idmJobQuery1.eq("source_id", dataInfo.getString("CODE") + "|"+dataInfo.getString("DESC1"));
                idmJobEntity = jobService.getOne(idmJobQuery1, false);

                if(idmJobEntity == null){
                    logger.info("任职记录："+dataInfo.getString("DESC1") + dataInfo.getString("DESC7") +"未查询到信息，故新增");
                    idmJobEntity = new IdmJobEntity();

                    //先查部门，部门不存在，再查组织
                    queryDeptWrapper1 = new QueryWrapper<>();
                    queryDeptWrapper1.eq("dr", 0);
                    queryDeptWrapper1.eq("source_id", dataInfo.getString("DESC7"));//部门
                    deptEntity = deptService.getOne(queryDeptWrapper1);

                    if(deptEntity == null) {
                        orgWrapper2 = new QueryWrapper<>();
                        orgWrapper2.eq("dr", 0);
                        orgWrapper2.eq("source_id", dataInfo.getString("DESC7"));//部门
                        orgEntity = orgService.getOne(orgWrapper2);
                    }
                    if(deptEntity != null) {
                        idmJobEntity.setDeptId(deptEntity.getId());//部门id
                        idmJobEntity.setOrgId(deptEntity.getOrgId());//组织d
                        idmJobEntity.setSourceDeptId(dataInfo.getString("DESC7"));//来源部门
                    }else{
                        idmJobEntity.setOrgId(orgEntity != null ? orgEntity.getId() : null);
                        idmJobEntity.setSourceOrgId(dataInfo.getString("DESC7"));
                    }

                    //查找人员
                    QueryWrapper<IdmEmployeeEntity> queryEmployeeWrapper = new QueryWrapper<>();
                    queryEmployeeWrapper.eq("dr", 0);
                    queryEmployeeWrapper.eq("code", dataInfo.getString("DESC1"));//集团编码
                    employeeEntity = employeeService.getOne(queryEmployeeWrapper);

                    if(employeeEntity == null){
                        logger.info(dataInfo.getString("DESC1") + "未找到人员信息!");
                        continue;
                    }

                    idmJobEntity.setEmployeeId(employeeEntity.getId());//人员id
                    if("主任职".equals(dataInfo.getString("DESC11"))){
                        idmJobEntity.setProperty(1);//主职
                    }else{
                        idmJobEntity.setProperty(0);//兼职
                    }

                    idmJobEntity.setJobStartTime(DateUtils.createDate(dataInfo.getString("DESC14")));//开始任职时间
                    if(StringUtils.isEmpty(dataInfo.getString("DESC15"))){
                        idmJobEntity.setJobEndTime(null);//结束任职时间
                    }else{
                        idmJobEntity.setJobEndTime(DateUtils.createDate(dataInfo.getString("DESC15")));//结束任职时间
                    }
                    idmJobEntity.setCurState(0);
                    idmJobEntity.setSourceId(dataInfo.getString("CODE") + "|"+dataInfo.getString("DESC1"));//来源id,记录主数据Code集团编码+
                    addNum ++ ;
                }else{
                    logger.info("任职记录："+dataInfo.getString("DESC1") + dataInfo.getString("DESC7") +"---------更新");
                    Date startJobDate = DateUtils.createDate(dataInfo.getString("DESC14"));
                    Date endJobDate = DateUtils.createDate(dataInfo.getString("DESC15"));

                    if("主任职".equals(dataInfo.getString("DESC11"))){
                        idmJobEntity.setProperty(1);//主职
                    }else{
                        idmJobEntity.setProperty(0);//兼职
                    }

                    idmJobEntity.setJobStartTime(startJobDate);//开始任职时间
                    if(StringUtils.isEmpty(dataInfo.getString("DESC15"))){
                        idmJobEntity.setJobEndTime(null);//结束任职时间
                    }else{
                        idmJobEntity.setJobEndTime(endJobDate);//结束任职时间
                    }

                    if("是".equals(dataInfo.getString("DESC13"))){
                        idmJobEntity.setCurState(0);
                    }else{
                        idmJobEntity.setCurState(1);
                    }

                    //根据任职结束日期重置启用状态
                    Date nowDate = new Date();
                    if(endJobDate.before(nowDate)){//结束日期小于当前，设置为过期
                        idmJobEntity.setCurState(1);
                    }else{
                        idmJobEntity.setCurState(0);
                    }

                    updateNum ++;
                }
                jobService.saveOrUpdate(idmJobEntity,false);
            }
        }
        return CommonResponse.success("同步任职成功！新增" + addNum + "条，更新" + updateNum + "条");
    }
}
