package com.ejianc.foundation.sync.controller.api;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.sync.vo.SyncEmployeeAndUserVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.idmdata.orgcenter.bean.*;
import com.ejianc.idmdata.orgcenter.service.*;
import com.ejianc.idmdata.orgcenter.util.PasswordUtils;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.*;

@Service("SynEmpApi")
public class SynEmpApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

//	@Autowired
//	private ISyncService syncService;

	@Autowired
	private IIdmOrgService orgService;

	@Autowired
	private IIdmDeptService deptService;

	@Autowired
	private IIdmEmployeeService employeeService;

	@Autowired
	private IIdmUserService userService;

	@Autowired
	private IIdmJobService jobService;

	@Autowired
	private IIdmRoleUserRelationService roleUserRelationService;

	@Autowired
	private IIdmUserTenantRelationService userTenantRelationService;

	//同步人员（若人员为新增时同时生成一条任职记录，当人员的组织信息发生修改时，停用原先的任职记录信息并生成一条新的任职记录信息）和用户
	@PostMapping(value = "syncEmployeeAndUserList")
	public CommonResponse<String> syncEmployeeAndUser(@RequestBody SyncEmployeeAndUserVO syncVO) {
		EmployeeVO employeeVo = syncVO.getEmployee();
		UserVO userVo = syncVO.getUser();
		try{
			QueryWrapper<IdmUserEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("source_id", userVo.getUserCode());
			queryWrapper.apply("source_id is not null AND source_id <> '' ");

			IdmUserEntity userEntity = userService.getOne(queryWrapper);

			if(userEntity == null){
				QueryWrapper<IdmUserEntity> queryWrapper2 = new QueryWrapper<>();
				queryWrapper2.eq("user_mobile", userVo.getUserMobile());
				queryWrapper2.apply("user_mobile is not null AND user_mobile <> '' ");
				userEntity = userService.getOne(queryWrapper2);
			}

			if(userEntity == null){
				//保存用户
				logger.info("人员："+userVo.getUserName()+userVo.getUserMobile()+"未查询到信息，故新增");

				//先查部门，部门不存在，把人员挂在组织级
				QueryWrapper<IdmDeptEntity> queryDeptWrapper = new QueryWrapper<>();
				queryDeptWrapper.eq("dr", 0);
				queryDeptWrapper.eq("source_id", syncVO.getSourceOrgId());
				userVo.setSourceOrgId(syncVO.getSourceOrgId());
				IdmDeptEntity deptEntity = deptService.getOne(queryDeptWrapper);

				IdmOrgEntity orgEntity = null;
				if(deptEntity == null) {
					QueryWrapper<IdmOrgEntity> orgWrapper = new QueryWrapper<>();
					orgWrapper.eq("dr", 0);
					orgWrapper.eq("source_id", syncVO.getSourceOrgId());
					orgEntity = orgService.getOne(orgWrapper);
				}
				if(deptEntity != null) {
					userVo.setOrgId(deptEntity.getOrgId());
				}else{
					userVo.setOrgId(orgEntity != null ? orgEntity.getId():null);
				}

				Long pkId = IdWorker.getId();
				//新增用户
				userVo.setId(pkId);
				userVo.setTypeId(2); //普通用户
				userVo.setUserState(UserVO.USER_STATE_ACTIVE); //启用状态
				userVo.setDr(BaseVO.DR_UNDELETE);
				userVo.setWeixineeId(userVo.getUserCode());
				//生成默认密码
				PasswordUtils.setSalt(userVo);
				String shaPassword = PasswordUtils.encodePasswordUsingSHA("1q2w3e4r!@#");
				userVo.setPassword(shaPassword);
				userVo.setPassword(PasswordUtils.encodebyUserCode(userVo));
				userVo.setPwdStartTime(new Date());
				IdmUserEntity userSaveEntity = BeanMapper.map(userVo, IdmUserEntity.class);
				userService.saveOrUpdate(userSaveEntity, false);

				//新增人员
				if(deptEntity != null) {
					employeeVo.setOrgId(deptEntity.getOrgId());
					employeeVo.setDeptId(deptEntity.getId());
				}else{
					employeeVo.setOrgId(orgEntity != null ? orgEntity.getId():null);
				}
				employeeVo.setId(pkId);
				employeeVo.setState(1);
				employeeVo.setEmployeeType(1);//在职
				employeeVo.setUserId(userSaveEntity.getId());
				employeeVo.setUserId(pkId);
				IdmEmployeeEntity employeeEntity = BeanMapper.map(employeeVo, IdmEmployeeEntity.class);
				employeeService.saveOrUpdate(employeeEntity, false);

				//任职信息
				IdmJobEntity job = new IdmJobEntity();
				if(deptEntity != null) {
					//是部门
					job.setSourceDeptId(syncVO.getSourceOrgId());
				}else{
					//是组织
					job.setSourceOrgId(syncVO.getSourceOrgId());
				}
				job.setOrgId(employeeVo.getOrgId());
				job.setDeptId(employeeVo.getDeptId());
				job.setEmployeeId(employeeVo.getId());
				job.setProperty(1);
				job.setJobStartTime(null);
				job.setCurState(0);
				job.setSystemId(employeeVo.getSystemId());
				job.setSourceId(employeeVo.getCode());//来源id，对应集团人员编码
				jobService.saveOrUpdate(job,false);

				//生成用户租户关系表
				IdmUserTenantRelationEntity entity = new IdmUserTenantRelationEntity();
				entity.setUserId(userVo.getId());
				entity.setEmployeeId(employeeVo.getId());
				entity.setOrgId(employeeVo.getOrgId());
				entity.setTenantId(employeeVo.getTenantId());
				entity.setPostId(employeeVo.getTenantId());
				entity.setDeptId(employeeVo.getDeptId());
				entity.setMainSpaceFlag(1);//主空间
				entity.setTypeId(2);//普通用户
				entity.setState(1);//启用
				userTenantRelationService.saveOrUpdate(entity, false);

			}else{
				logger.info("人员："+userVo.getUserName()+userVo.getUserMobile()+"更新");
				/**更新用户**/
				QueryWrapper<IdmDeptEntity> queryDeptWrapper = new QueryWrapper<>();
				queryDeptWrapper.eq("dr", 0);
				queryDeptWrapper.eq("source_id", syncVO.getSourceOrgId());
				IdmDeptEntity deptEntity = deptService.getOne(queryDeptWrapper);

				IdmOrgEntity orgEntity = null;
				if(deptEntity == null) {
					QueryWrapper<IdmOrgEntity> orgWrapper = new QueryWrapper<>();
					orgWrapper.eq("dr", 0);
					orgWrapper.eq("source_id", syncVO.getSourceOrgId());
					orgEntity = orgService.getOne(orgWrapper);
				}
				if(deptEntity != null) {
					userEntity.setOrgId(deptEntity.getOrgId());
				}else{
					userEntity.setOrgId(orgEntity != null ? orgEntity.getId():null);
				}
				userEntity.setSourceOrgId(syncVO.getSourceOrgId());//部门或组织
				userEntity.setUserCode(userVo.getUserCode());
				userEntity.setUserName(userVo.getUserName());//用户名称
				userEntity.setUserMobile(userVo.getUserMobile());//手机号
				userEntity.setUserState(userVo.getUserState());//状态
//				//生成默认密码
//				PasswordUtils.setSalt(userVo);
//				String shaPassword = PasswordUtils.encodePasswordUsingSHA("1q2w3e4r!@#");
//				userVo.setPassword(shaPassword);
//
//				userEntity.setPassword(PasswordUtils.encodebyUserCode(userVo));
//				userEntity.setPwdStartTime(new Date());

				userService.saveOrUpdate(userEntity, false);

				/**更新人员**/
				QueryWrapper<IdmEmployeeEntity> queryEmployeeWrapper = new QueryWrapper<>();
				queryEmployeeWrapper.eq("dr", 0);
				queryEmployeeWrapper.eq("code", employeeVo.getCode());
				IdmEmployeeEntity employeeEntity = employeeService.getOne(queryEmployeeWrapper);
				if(employeeEntity == null){
					//再次根据人员查找
					QueryWrapper<IdmEmployeeEntity> queryEmployeeWrapper2 = new QueryWrapper<>();
					queryEmployeeWrapper2.eq("dr", 0);
					queryEmployeeWrapper2.eq("mobile_phone", employeeVo.getMobilePhone());
					employeeEntity = employeeService.getOne(queryEmployeeWrapper2);
				}
				employeeEntity.setCode(employeeVo.getCode());
				employeeEntity.setName(employeeVo.getName());
				employeeEntity.setIdcard(employeeVo.getIdcard());
				employeeEntity.setBirthday(employeeVo.getBirthday());
				employeeEntity.setSex(employeeVo.getSex());
				employeeEntity.setWorkTime(employeeVo.getWorkTime());
				employeeEntity.setMobilePhone(employeeVo.getMobilePhone());
				employeeEntity.setOtherPhone(employeeVo.getOtherPhone());
				employeeEntity.setSourceId(employeeVo.getCode());//来源id，对应集团人员编码
				employeeEntity.setState(employeeVo.getState());
				//新的部门和组织
				if(deptEntity != null) {
					employeeVo.setOrgId(deptEntity.getOrgId());
					employeeVo.setDeptId(deptEntity.getId());
				}else{
					employeeVo.setOrgId(orgEntity != null ? orgEntity.getId():null);
				}
				employeeService.saveOrUpdate(employeeEntity, false);

				/**更新主职的任职记录**/
				QueryWrapper<IdmJobEntity> queryJobWrapper = new QueryWrapper<>();
				queryJobWrapper.eq("dr", 0);
				queryJobWrapper.eq("property", "1");//主职
				queryJobWrapper.eq("employee_id", employeeEntity.getId());

				IdmJobEntity jobEntity = jobService.getOne(queryJobWrapper);
				if(jobEntity == null){
					//主职记录为空，不处理
				}else{
					if(deptEntity != null) {
						jobEntity.setOrgId(deptEntity.getOrgId());
						jobEntity.setDeptId(deptEntity.getId());
					}else{
						jobEntity.setOrgId(orgEntity != null ? orgEntity.getId():null);
					}
					jobService.saveOrUpdate(jobEntity);
				}

				/**用户租户关系表不用更新**/
			}
		}catch (Exception e){
			logger.info("人员："+userVo.getUserName()+userVo.getUserMobile()+"同步失败--------------->");
			logger.info(JSON.toJSONString(syncVO));
			return CommonResponse.error("人员、用户信息同步失败--------------->");
		}
		return CommonResponse.success("保存人员、用户信息成功！");

	}

}
