package com.ejianc.idmdata.orgcenter.controller;

import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.idmdata.orgcenter.service.IIdmJobService;
import com.ejianc.idmdata.orgcenter.service.IShareService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;

/**
 * 任职记录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("share")
public class IShareController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IShareService shareService;

    /**
     * @Description shelfGoods 定时同步物料分类
     */
    @RequestMapping(value = "/synShareMaterialCategory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> synShareMaterialCategory(HttpServletRequest request) {
        String type = request.getParameter("type");
        if(StringUtils.isEmpty(type)){
            return CommonResponse.error("请求param中缺少参数type");
        }
        String CODE = request.getParameter("CODE");
        logger.info("com.ejianc.idmdata.orgcenter.controller.IShareController.synShareMaterialCategory开始同步物料分类" );
        CommonResponse<String> stringCommonResponse = shareService.synShareMaterialCategory(type, CODE);
        return stringCommonResponse;
    }

    /**
     * @Description shelfGoods 定时同步物料
     */
    @RequestMapping(value = "/synShareMaterial", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> synShareMaterial(HttpServletRequest request) {
        String type = request.getParameter("type");
        if(StringUtils.isEmpty(type)){
            return CommonResponse.error("请求param中缺少参数type");
        }
        String CODE = request.getParameter("CODE");
        logger.info("com.ejianc.idmdata.orgcenter.controller.IShareController.synShareMaterial开始同步物料" );
        CommonResponse<String> stringCommonResponse = shareService.synShareMaterial(type, CODE);
        return stringCommonResponse;
    }

    /**
     * @Description shelfGoods 定时同步供应商
     */
    @RequestMapping(value = "/synShareSupplier", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> synShareSupplier(HttpServletRequest request) {
        String type = request.getParameter("type");
        if(StringUtils.isEmpty(type)){
            return CommonResponse.error("请求param中缺少参数type");
        }
        String CODE = request.getParameter("CODE");
        String startPage = request.getParameter("startPage");
        String endPage = request.getParameter("endPage");
        if(startPage == null || "".equals(startPage)){
            startPage = "0";
            endPage = "0";
        }
        logger.info("com.ejianc.idmdata.orgcenter.controller.IShareController.synShareSupplier开始同步供应商" );
        CommonResponse<String> stringCommonResponse = shareService.synShareSupplier(type, CODE,Integer.parseInt(startPage) ,Integer.parseInt(endPage));
        return stringCommonResponse;
    }

    /**
     * 根据供应商编码获取供应商银行账号
     * @param queryCode 供应商Code
     */
    @RequestMapping(value = "/getSupplierBankAccount", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BankAccountVO> getSupplierBankAccount(@RequestParam(value = "queryCode") String queryCode) {
        CommonResponse<BankAccountVO> commonResponse = shareService.getSupplierBankAccount("all", queryCode);
        return commonResponse;
    }

}
