package com.ejianc.idmdata.orgcenter.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.SyncMaterialCategoryParam;
import com.ejianc.foundation.share.vo.SyncMaterialParam;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.idmdata.orgcenter.bean.IdmUserEntity;
import com.ejianc.idmdata.orgcenter.mapper.IdmUserMapper;
import com.ejianc.idmdata.orgcenter.service.IShareService;
import com.ejianc.ztpcdata.util.HttpClientUtil;
import com.ejianc.ztpcdata.util.SynDataBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 任职表
 * 
 * @author generator
 * 
 */
@Service("shareService")
public class IShareServiceImpl extends BaseServiceImpl<IdmUserMapper, IdmUserEntity> implements IShareService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IShareMaterialApi shareMaterialApi;

    @Autowired
    private IShareSupplierApi shareSupplierApi;

    private long INTERVAL_TIME = 3000;//接口请求间隔时间
    private String material_url_param = "P-Z9oJ2031";//接口url参数
    private String supplier_url_param = "P-fy5Du633";//接口url参数
    private String user_code_param = "P-VQk2r027";//接口用户名
    private String password_param = "P-947I0928";//接口密码
    private String supplier_bank_account_url_param = "P-Tcws5035";//接口url参数


    @Override
    public CommonResponse<String> synShareMaterialCategory(String type, String queryCode) {
        int totalPages = 1;//初始化查询页数为1

        CommonResponse<ParamRegisterSetVO> urlParam = paramConfigApi.getByCode(material_url_param);
        CommonResponse<ParamRegisterSetVO> userCodeParam = paramConfigApi.getByCode(user_code_param);
        CommonResponse<ParamRegisterSetVO> passWordParam = paramConfigApi.getByCode(password_param);

        String url = "";
        String userCode = "";
        String pwd = "";

        if(urlParam.getCode() == 1 || userCodeParam.getCode() == 1 || passWordParam.getCode() == 1){
            logger.info("主数据同步-物料分类获取参数失败！");
            return CommonResponse.error("获取参数失败！");
        }else{
            url = urlParam.getData().getValueData();
            userCode = userCodeParam.getData().getValueData();
            pwd = passWordParam.getData().getValueData();
        }

        List<SyncMaterialCategoryParam> jsonList = new ArrayList();
        for (int i = 1; i <= totalPages; i++) {
            String json = SynDataBuilder.getReqJson(i + "",null, type,queryCode,"");
            logger.info(i + "同步物料分类查询参数为：" + json);

            try {
                if (i > 1) {
                    Thread.sleep(INTERVAL_TIME);
                }
            } catch (InterruptedException e) {

            }

            String returnStr = HttpClientUtil.doPostJson(url, json, userCode, pwd);
            if (returnStr == null || "".equals(returnStr)) {
                return CommonResponse.error("调用主数据接口失败！");
            }
            JSONObject returnJson = JSONObject.parseObject(returnStr);
            JSONObject esb = (JSONObject) returnJson.get("ESB");
            if(esb.get("RESULT") != null && !"".equals(esb.get("RESULT").toString()) && "E".equals(esb.get("RESULT").toString())){
                return CommonResponse.error("调用主数据【物料分类】接口失败！");
            }
            if("S".equals(esb.getString("RESULT")) && "没有查询到数据！".equals(esb.getString("DESC")) ){
                return CommonResponse.error("未查询到物料分类");
            }
            JSONObject data = esb.getJSONObject("DATA");
            JSONObject splitPage = data.getJSONObject("SPLITPAGE");
            totalPages = splitPage.getInteger("TOTALPAGES");//总页数
//            totalPages = 1;//总页数

            JSONObject dataInfos = data.getJSONObject("DATAINFOS");
            JSONArray dataInfoArr = dataInfos.getJSONArray("DATAINFO");

            SyncMaterialCategoryParam materialCategoryVO = null;
            for (Object obj : dataInfoArr) {
                JSONObject dataInfo = (JSONObject) obj;

                String code = dataInfo.getString("CODE");
                if (code.length() > 6) {
                    //编码小于6位的是分类，大于6位的是编码
                    continue;
                }

                materialCategoryVO = new SyncMaterialCategoryParam();
                materialCategoryVO.setId(dataInfo.getString("DESC13"));
                materialCategoryVO.setCode(dataInfo.getString("CODE"));
                materialCategoryVO.setName(dataInfo.getString("DESC1"));
                materialCategoryVO.setSystemCode("ZHUSHUJU");

                //上级编码
                String desc13 = dataInfo.getString("DESC13");
                if(code.length() == 2){
                    //两位为1级目录
                    materialCategoryVO.setParentId(null);
                }else{
                    String subCode = desc13.substring(0, desc13.length() - 3);
                    materialCategoryVO.setParentId(subCode);
                }

                //操作类型的值：1增改2删除
                String desc19 = dataInfo.getString("DESC19");
                String DESC12 = dataInfo.getString("DESC12");
                //1:启用/0:停用
                if("2".equals(desc19) || "停用".equals(DESC12)){
                    materialCategoryVO.setEnabled(0);
                }else{
                    materialCategoryVO.setEnabled(1);
                }

                jsonList.add(materialCategoryVO);
            }
        }
         List<SyncMaterialCategoryParam> collect = jsonList.stream().sorted(Comparator.comparing(SyncMaterialCategoryParam::getCode))
                .collect(Collectors.toList());
        CommonResponse<String> stringCommonResponse = shareMaterialApi.syncMaterialCategory(collect);
        return stringCommonResponse;
    }

    @Override
    public CommonResponse<String> synShareMaterial(String type, String queryCode) {
        int totalPages = 1;//初始化查询页数为1

        CommonResponse<ParamRegisterSetVO> urlParam = paramConfigApi.getByCode(material_url_param);
        CommonResponse<ParamRegisterSetVO> userCodeParam = paramConfigApi.getByCode(user_code_param);
        CommonResponse<ParamRegisterSetVO> passWordParam = paramConfigApi.getByCode(password_param);

        String url = "";
        String userCode = "";
        String pwd = "";

        if(urlParam.getCode() == 1 || userCodeParam.getCode() == 1 || passWordParam.getCode() == 1){
            logger.info("主数据同步-物料获取参数失败！");
            return CommonResponse.error("获取参数失败！");
        }else{
            url = urlParam.getData().getValueData();
            userCode = userCodeParam.getData().getValueData();
            pwd = passWordParam.getData().getValueData();
        }

        List<SyncMaterialParam> jsonList = new ArrayList();
        for (int i = 1; i <= totalPages; i++) {
            String json = SynDataBuilder.getReqJson(i + "",null, type,queryCode,"");
            logger.info(i + "同步物料查询参数为：" + json);

            try {
                if (i > 1) {
                    Thread.sleep(INTERVAL_TIME);
                }
            } catch (InterruptedException e) {

            }

            String returnStr = HttpClientUtil.doPostJson(url, json, userCode, pwd);
            if (returnStr == null || "".equals(returnStr)) {
                return CommonResponse.error("调用主数据接口失败！");
            }
            JSONObject returnJson = JSONObject.parseObject(returnStr);
            JSONObject esb = (JSONObject) returnJson.get("ESB");
            if(esb.get("RESULT") != null && !"".equals(esb.get("RESULT").toString()) && "E".equals(esb.get("RESULT").toString())){
                return CommonResponse.error("调用主数据【物料】接口失败！");
            }
            if("S".equals(esb.getString("RESULT")) && "没有查询到数据！".equals(esb.getString("DESC")) ){
                return CommonResponse.error("未查询到物料");
            }
            JSONObject data = esb.getJSONObject("DATA");
            JSONObject splitPage = data.getJSONObject("SPLITPAGE");
            totalPages = splitPage.getInteger("TOTALPAGES");//总页数
//            totalPages = 1;//总页数

            JSONObject dataInfos = data.getJSONObject("DATAINFOS");
            JSONArray dataInfoArr = dataInfos.getJSONArray("DATAINFO");

            SyncMaterialParam materialParamVO = null;
            for (Object obj : dataInfoArr) {
                JSONObject dataInfo = (JSONObject) obj;

                String code = dataInfo.getString("CODE");
                if (code.length() <= 6) {
                    //编码小于6位的是分类，大于6位的是编码
                    continue;
                }

                materialParamVO = new SyncMaterialParam();
                materialParamVO.setId(dataInfo.getString("DESC13"));
                materialParamVO.setCode(dataInfo.getString("CODE"));
                materialParamVO.setName(dataInfo.getString("DESC1"));
                materialParamVO.setSpec(dataInfo.getString("DESC4"));//规格
                materialParamVO.setModel(dataInfo.getString("DESC5"));//型号
                materialParamVO.setDef1(dataInfo.getString("DESC6"));//材质
                materialParamVO.setUnitName(dataInfo.getString("DESC7"));//计量单位

                String desc13 = dataInfo.getString("DESC13");
                String subCode = desc13.substring(0, 8);
                materialParamVO.setCategoryId(subCode);//物料分类

                //操作类型的值：1增改2删除
                String desc19 = dataInfo.getString("DESC19");
                String DESC12 = dataInfo.getString("DESC12");
                //1:启用/0:停用
                if("2".equals(desc19) || "停用".equals(DESC12)){
                    materialParamVO.setEnabled(0);
                }else{
                    materialParamVO.setEnabled(1);
                }
                jsonList.add(materialParamVO);
            }
        }
        CommonResponse<String> stringCommonResponse = shareMaterialApi.syncMaterial(jsonList);
        return stringCommonResponse;
    }

    /**
     * @param type  all：全部，add：增量
     * @param queryCode
     * @param startPage 指定开始的页数
     * @param endPage   指定结束的页数
     * @return
     */
    @Override
    public CommonResponse<String> synShareSupplier(String type, String queryCode,int startPage,int endPage) {
        int totalPages = 1;//初始化查询页数为1
        if(startPage > 0){
            totalPages = endPage;
        }else{
            startPage = 1;//开始页数
        }

        CommonResponse<ParamRegisterSetVO> urlParam = paramConfigApi.getByCode(supplier_url_param);
        CommonResponse<ParamRegisterSetVO> userCodeParam = paramConfigApi.getByCode(user_code_param);
        CommonResponse<ParamRegisterSetVO> passWordParam = paramConfigApi.getByCode(password_param);

        String url = "";
        String userCode = "";
        String pwd = "";

        if(urlParam.getCode() == 1 || userCodeParam.getCode() == 1 || passWordParam.getCode() == 1){
            logger.info("主数据同步-供应商获取参数失败！");
            return CommonResponse.error("获取参数失败！");
        }else{
            url = urlParam.getData().getValueData();
            userCode = userCodeParam.getData().getValueData();
            pwd = passWordParam.getData().getValueData();
        }

        List<SupplierVO> jsonList = new ArrayList();
        for (int i = startPage; i <= totalPages; i++) {
            String json = SynDataBuilder.getSupplierReqJson(i + "","200", type,queryCode,"");
            logger.info(i + "次同步供应商查询参数为：" + json);

            try {
                if (i > 1) {
                    Thread.sleep(INTERVAL_TIME);
                }
            } catch (InterruptedException e) {

            }

            String returnStr = HttpClientUtil.doPostJson(url, json, userCode, pwd);
            if (returnStr == null || "".equals(returnStr)) {
                return CommonResponse.error("调用主数据接口失败！");
            }
            JSONObject returnJson = JSONObject.parseObject(returnStr);
            JSONObject esb = (JSONObject) returnJson.get("ESB");
            if(esb.get("RESULT") != null && !"".equals(esb.get("RESULT").toString()) && "E".equals(esb.get("RESULT").toString())){
                return CommonResponse.error("调用主数据【供应商】接口失败！");
            }
            if("S".equals(esb.getString("RESULT")) && "没有查询到数据！".equals(esb.getString("DESC")) ){
                return CommonResponse.error("未查询到供应商");
            }
            JSONObject data = esb.getJSONObject("DATA");
            JSONObject splitPage = data.getJSONObject("SPLITPAGE");
            if(endPage == 0){
                totalPages = splitPage.getInteger("TOTALPAGES");//总页数
            }else{
                totalPages = endPage;//指定查询分页
            }

            JSONObject dataInfos = data.getJSONObject("DATAINFOS");
            JSONArray dataInfoArr = dataInfos.getJSONArray("DATAINFO");

            SupplierVO supplierVO = null;
            for (Object obj : dataInfoArr) {
                JSONObject dataInfo = (JSONObject) obj;

                supplierVO = new SupplierVO();
                supplierVO.setCode(dataInfo.getString("CODE"));
                supplierVO.setName(dataInfo.getString("DESC1"));
                supplierVO.setEnabled(1);
                supplierVO.setAddress(dataInfo.getString("DESC12") + " " + dataInfo.getString("DESC21"));//详细地址
                supplierVO.setLegal(dataInfo.getString("DESC13"));//法人代表
                supplierVO.setLegalPhone(dataInfo.getString("DESC22"));//法人电话
                supplierVO.setBusinessPerson(dataInfo.getString("DESC13"));//业务代表
                supplierVO.setBusinessPhone(dataInfo.getString("DESC22"));//业务代表电话
                supplierVO.setTaxPayerIdentifier(dataInfo.getString("DESC7"));//纳税识别号
                supplierVO.setGroupInOrOut("out");//集团内外
                supplierVO.setEnterpriseNature(1470585738831314945L);//企业性质
                supplierVO.setEnterpriseNatureName("其他");

                supplierVO.setRegisteredCapital(null);//注册资金
//                String desc17 = dataInfo.getString("DESC17");
//                if(desc17 == null || "".equals(desc17)){
//                    supplierVO.setRegisteredCapital(null);//注册资金
//                }else{
//                    try{
//                        supplierVO.setRegisteredCapital(new BigDecimal(dataInfo.getString("DESC17")));//注册资金
//                    }catch (NumberFormatException e){
//                        logger.info(dataInfo.getString("CODE") + "--->" + dataInfo.getString("DESC17") );
//                        e.printStackTrace();
//                    }
//                }

                supplierVO.setSupplyType("material,equipment,revolvMaterial,labor,major,consult,other");
                supplierVO.setSupplyTypeName("物资供应商,设备供应商,周转材供应商,劳务供应商,专业供应商,咨询供应商,其他供应商,");
                supplierVO.setComeFrom("自行准入");
                supplierVO.setInsideOrg(false);
                supplierVO.setBillState(0);
                supplierVO.setSupplierFlag(3);//客商属性，1-供应商，2-客户，3-客商

                String desc10 = dataInfo.getString("DESC10");
                if("个人".equals(desc10)){
                    supplierVO.setPersonal("p");//个人：p，企业：e
                }else{
                    supplierVO.setPersonal("e");//个人：p，企业：e
                }


                String desc3 = dataInfo.getString("DESC3");
                if("境内组织".equals(desc3)){
                    supplierVO.setInOrOut(1);//国内外：1国内，2国外
                    supplierVO.setRegisterCountryId(493873812443236045L);
                    supplierVO.setRegisterCountryName("中国");
                    supplierVO.setAreaName(dataInfo.getString("DESC12") + " " + dataInfo.getString("DESC21"));
                }else{
                    supplierVO.setInOrOut(2);//国内外：1国内，2国外
                }

                String desc24 = dataInfo.getString("DESC24");
                if("启用".equals(desc24)){
                    supplierVO.setEnabled(1);
                }else{
                    supplierVO.setEnabled(0);
                }

                jsonList.add(supplierVO);

            }
        }
        CommonResponse<String> stringCommonResponse = shareSupplierApi.syncSupplier(jsonList);
        return stringCommonResponse;
    }

    @Override
    public CommonResponse<BankAccountVO> getSupplierBankAccount(String type, String queryCode) {
        CommonResponse<ParamRegisterSetVO> urlParam = paramConfigApi.getByCode(supplier_bank_account_url_param);
        CommonResponse<ParamRegisterSetVO> userCodeParam = paramConfigApi.getByCode(user_code_param);
        CommonResponse<ParamRegisterSetVO> passWordParam = paramConfigApi.getByCode(password_param);

        String url = "";
        String userCode = "";
        String pwd = "";

        if(urlParam.getCode() == 1 || userCodeParam.getCode() == 1 || passWordParam.getCode() == 1){
            logger.info("主数据同步-【供应商银行账号】获取参数失败！");
            return CommonResponse.error("主数据同步-【供应商银行账号】获取参数失败！");
        }else{
            url = urlParam.getData().getValueData();
            userCode = userCodeParam.getData().getValueData();
            pwd = passWordParam.getData().getValueData();
        }

        String json = SynDataBuilder.getSupplierBankReqJson(1 + "", null, type, "", queryCode);
        logger.info( "同步【供应商银行账号】查询参数为：" + json);

        String returnStr = HttpClientUtil.doPostJson(url, json, userCode, pwd);
        if (returnStr == null || "".equals(returnStr)) {
            return CommonResponse.error("调用主数据【供应商银行账号】接口失败！");
        }
        JSONObject returnJson = JSONObject.parseObject(returnStr);
        JSONObject esb = (JSONObject) returnJson.get("ESB");
        if(esb.get("RESULT") != null && !"".equals(esb.get("RESULT").toString()) && "E".equals(esb.get("RESULT").toString())){
            return CommonResponse.error("调用主数据【供应商银行账号】接口失败！");
        }
        if("S".equals(esb.getString("RESULT")) && "没有查询到数据！".equals(esb.getString("DESC")) ){
            return CommonResponse.error("未查询到供应商银行账号");
        }
        JSONObject data = esb.getJSONObject("DATA");

        JSONObject dataInfos = data.getJSONObject("DATAINFOS");
        JSONArray dataInfoArr = dataInfos.getJSONArray("DATAINFO");

        BankAccountVO bankAccountVO = null;
        for (Object obj : dataInfoArr) {
            JSONObject dataInfo = (JSONObject) obj;
            bankAccountVO = new BankAccountVO();
            bankAccountVO.setBankCode(dataInfo.getString("DESC3"));//银行账户的值
            bankAccountVO.setBankName(dataInfo.getString("DESC5"));//所属银行的值
            break;
        }
        if(bankAccountVO == null){
            return CommonResponse.error("未查询到供应商银行账号");
        }else{
            return CommonResponse.success(bankAccountVO);
        }
    }
}
