package com.ejianc.idmdata.orgcenter.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.foundation.sync.vo.SyncEmployeeAndUserVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.idmdata.orgcenter.bean.IdmDeptEntity;
import com.ejianc.idmdata.orgcenter.bean.IdmOrgEntity;
import com.ejianc.idmdata.orgcenter.mapper.IdmOrgMapper;
import com.ejianc.idmdata.orgcenter.service.IIdmDeptService;
import com.ejianc.idmdata.orgcenter.service.IIdmOrgService;
import com.ejianc.ztpcdata.util.Constants;
import com.ejianc.ztpcdata.util.DateUtils;
import com.ejianc.ztpcdata.util.HttpClientUtil;
import com.ejianc.ztpcdata.util.SynDataBuilder;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.regex.Pattern;
import com.ejianc.foundation.sync.controller.api.SynEmpApi;

/**
 * 组织
 * 
 * @author generator
 * 
 */
@Service("idmOrgService")
public class IdmOrgServiceImpl extends BaseServiceImpl<IdmOrgMapper, IdmOrgEntity> implements IIdmOrgService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IIdmOrgService orgService;

    @Autowired
    private IIdmDeptService deptService;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private SynEmpApi SynEmpApi;

    private long INTERVAL_TIME = 10000;//接口请求间隔时间
    private String org_url_param = "P-5o29Xh26";//组织同步参数
    private String dept_url_param = "P-5o29Xh26";//部门同步参数
    private String emp_url_param = "P-w9lm3229";//人员同步参数
    private String user_code_param = "P-VQk2r027";//接口用户名
    private String password_param = "P-947I0928";//接口密码
    /**
     * @param type all：查询全量的，add查询增量的
     * @return
     */
    @Override
    public CommonResponse<String> synIdmOrg( String type,String queryCode) {
        int totalPages = 1;//初始化查询页数为1

        CommonResponse<ParamRegisterSetVO> urlParam = paramConfigApi.getByCode(org_url_param);
        CommonResponse<ParamRegisterSetVO> userCodeParam = paramConfigApi.getByCode(user_code_param);
        CommonResponse<ParamRegisterSetVO> passWordParam = paramConfigApi.getByCode(password_param);

        String url = "";
        String userCode = "";
        String pwd = "";
        if(urlParam.getCode() == 1 || userCodeParam.getCode() == 1 || passWordParam.getCode() == 1){
            logger.info("主数据同步-组织获取参数失败！");
            return CommonResponse.error("获取参数失败！");
        }else{
            url = urlParam.getData().getValueData();
            userCode = userCodeParam.getData().getValueData();
            pwd = passWordParam.getData().getValueData();
        }

        int addNum = 0;
        int updateNum = 0;
        int errorNum = 0;

        for (int i = 1; i <= totalPages; i++) {
            String json = SynDataBuilder.getReqJson(i+"",null,type,queryCode,"");
            logger.info( i + "同步组织查询参数为："+json);

            try {
                if(i > 1){
                    Thread.sleep(INTERVAL_TIME);
                }
            }catch (InterruptedException e){

            }

            String returnStr = HttpClientUtil.doPostJson(url,json,userCode,pwd);
            if(returnStr == null || "".equals(returnStr)){
                return CommonResponse.error("调用主数据接口失败！");
            }
            JSONObject returnJson = JSONObject.parseObject(returnStr);
            JSONObject esb = (JSONObject) returnJson.get("ESB");
            String status = esb.get("STATUS").toString();
            if(!"S".equals(status)){
                return CommonResponse.error("调用主数据接口失败！");
            }
            JSONObject data = esb.getJSONObject("DATA");
            JSONObject splitPage = data.getJSONObject("SPLITPAGE");
            totalPages = splitPage.getInteger("TOTALPAGES");//总页数
            JSONObject dataInfos = data.getJSONObject("DATAINFOS");
            JSONArray dataInfoArr = dataInfos.getJSONArray("DATAINFO");

            for (Object obj : dataInfoArr) {
                JSONObject dataInfo = (JSONObject) obj;
                String code = dataInfo.getString("CODE");//组织code，唯一值
                String desc6 = dataInfo.getString("DESC6");//所属单位编码的值
                String desc28 = dataInfo.getString("DESC28");//机构类型
                String desc1 = dataInfo.getString("DESC1");//组织名称

                if(Constants.ORG_GROUP.equals(code)){
                    //如果是集团，跳出不处理
                    continue;
                }else if(Constants.ORG_FINANCE_SHARE.equals(code) || Constants.ORG_FUNDING_SHARE.equals(code)){
                    //财务共享服务中心、资金中心，跳出不处理
                    continue;
                }else if(Constants.ORG_FINANCE_SHARE.equals(desc6) || Constants.ORG_FUNDING_SHARE.equals(desc6)){
                    //财务共享服务中心、资金中心，跳出不处理
                    continue;
                }else if("部门".equals(desc28)){
                    //机构类型为部门的忽略
                    continue;
                }else if("".equals(desc28)){
                    //机构类型为空的忽略
                    continue;
                }else if(desc1.contains("工区") || desc1.contains("区域项目")){
                    //工区、区域项目实质为部门，不做组织处理
                    continue;
                }

                //根据source_id查询系统中是够已经存在
                QueryWrapper<IdmOrgEntity> query = new QueryWrapper<>();
                query.eq("source_id", dataInfo.getString("CODE"));
                query.eq("dr", 0);

                IdmOrgEntity orgEntity = orgService.getOne(query);
                if(orgEntity == null){
                    //不存在，做新增操作
                    orgEntity = new IdmOrgEntity();
                    long id = IdWorker.getId();
                    orgEntity.setId(id);
                    orgEntity.setRowState("add");
                }else{
                    //存在，做更新操作
                    orgEntity.setRowState("edit");
                }
                orgEntity.setCode(dataInfo.getString("CODE"));//组织机构编码的值
                orgEntity.setName(dataInfo.getString("DESC1"));//组织机构名称的值
//                orgEntity.setShortName(dataInfo.getString("DESC1"));//简称
                orgEntity.setSourceId(dataInfo.getString("CODE"));//来源id
                orgEntity.setEnterpriseId(999999L);//企业ID

                String[] codes = dataInfo.getString("CODE").split("-");
                if(codes.length > 1){
                    Pattern pattern = Pattern.compile("[0-9]*");
                    boolean matches = pattern.matcher(codes[1]).matches();
                    if(matches){
                        orgEntity.setSequence(new Long(codes[1]).intValue());
                    }else{
                        orgEntity.setSequence(null);
                    }
                }else{
                    Pattern pattern = Pattern.compile("[0-9]*");
                    boolean matches = pattern.matcher(codes[0]).matches();
                    if(matches){
                        orgEntity.setSequence(new Long(codes[0]).intValue());
                    }else{
                        orgEntity.setSequence(null);
                    }
                }

                orgEntity.setState(dataInfo.getInteger("DESC31"));//启用状态，1启用、0停用

                if(Constants.ORG_01201002.equals(desc6)){
                    //直营下面的同步为经理部
                    orgEntity.setOrgType(3);
                }else if("分公司".equals(desc28) || "子公司".equals(desc28)){
                    orgEntity.setOrgType(2);//分子公司
                }else if("虚拟组织".equals(desc28) || "单位".equals(desc28)){
                    orgEntity.setOrgType(4);//虚拟组织
                }else if("项目".equals(desc28)){
                    orgEntity.setOrgType(3);//经理部
                }

                //处理上级字段
                String parentCode = dataInfo.getString("PARENTCODE");
                QueryWrapper<IdmOrgEntity> queryParent = new QueryWrapper<>();
                queryParent.eq("code", parentCode);
                IdmOrgEntity parentEntity = orgService.getOne(queryParent);

                if(parentEntity == null){
                    logger.info( "同步组织error:"+dataInfo.getString("CODE") + "在系统中未找到上级组织"+parentCode);
                    errorNum ++;
                    continue;
                }else{
                    orgEntity.setParentId(parentEntity.getId());
                    orgEntity.setInnerCode(parentEntity.getInnerCode() + "|" + orgEntity.getId());
                }

                if("add".equals(orgEntity.getRowState())){
                    addNum ++;
                }else if("edit".equals(orgEntity.getRowState())){
                    updateNum ++;
                }

                orgService.saveOrUpdate(orgEntity,false);
            }
        }

        return CommonResponse.success("同步组织成功！新增" + addNum + "条，更新" + updateNum + "条,未找到上级组织" + errorNum + "条");
    }

    @Override
    public CommonResponse<String> synIdmDept(String type,String queryCode) {
        int totalPages = 1;//初始化查询页数为1

        CommonResponse<ParamRegisterSetVO> urlParam = paramConfigApi.getByCode(dept_url_param);
        CommonResponse<ParamRegisterSetVO> userCodeParam = paramConfigApi.getByCode(user_code_param);
        CommonResponse<ParamRegisterSetVO> passWordParam = paramConfigApi.getByCode(password_param);

        String url = "";
        String userCode = "";
        String pwd = "";
        if(urlParam.getCode() == 1 || userCodeParam.getCode() == 1 || passWordParam.getCode() == 1){
            logger.info("主数据同步-组织获取参数失败！");
            return CommonResponse.error("获取参数失败！");
        }else{
            url = urlParam.getData().getValueData();
            userCode = userCodeParam.getData().getValueData();
            pwd = passWordParam.getData().getValueData();
        }
        int addNum = 0;
        int updateNum = 0;
        int errorNum = 0;

        //先把所有的数据查询出来，为了后续溯源上级组织。主数据接口只能分页拿到
        HashMap<String,JSONObject> deptMap = new HashMap();
        for (int i = 1; i <= totalPages; i++) {
            String json = SynDataBuilder.getReqJson(i+"",null,type,queryCode,"");
            logger.info( "主数据同步-部门------"+i + "次同步部门查询参数为："+json);
            try {
                if(i > 1){
                    Thread.sleep(INTERVAL_TIME);
                }
            }catch (InterruptedException e){

            }

            String returnStr = HttpClientUtil.doPostJson(url,json,userCode,pwd);
//            logger.info( "初始化部门数据------"+i + "次同步部门返回信息："+returnStr);

            if(returnStr == null || "".equals(returnStr)){
                return CommonResponse.error("调用主数据接口失败！");
            }

            JSONObject returnJson = JSONObject.parseObject(returnStr);
            JSONObject esb = (JSONObject) returnJson.get("ESB");
            String status = esb.get("STATUS").toString();
            if(!"S".equals(status)){
                return CommonResponse.error("调用主数据接口失败！");
            }
            JSONObject data = esb.getJSONObject("DATA");
            JSONObject splitPage = data.getJSONObject("SPLITPAGE");
            totalPages = splitPage.getInteger("TOTALPAGES");//总页数
            JSONObject dataInfos = data.getJSONObject("DATAINFOS");
            JSONArray dataInfoArr = dataInfos.getJSONArray("DATAINFO");

            for (Object obj : dataInfoArr) {
                JSONObject dataInfo = (JSONObject) obj;

                String desc1 = dataInfo.getString("DESC1");//组织名称
                String parentDesc = dataInfo.getString("PARENTDESC");//上级组织
                if(desc1.contains("工区") || desc1.contains("区域项目")){
                    //工区和区域项目当做部门处理
                    dataInfo.put("DESC28","部门");
                }else if(parentDesc.contains("工区") || parentDesc.contains("区域项目")){
                    //上级为工区和区域项目当做部门处理
                    dataInfo.put("DESC28","部门");
                }

                String code = dataInfo.getString("CODE");//组织code，唯一值
                deptMap.put(code,dataInfo);
            }
        }

        //再去同步部门
        for (int i = 1; i <= totalPages; i++) {
            String json = SynDataBuilder.getReqJson(i+"",null,type,queryCode,"");
            logger.info( i + "次同步部门查询参数为："+json);

            try {
                if(i > 1){
                    Thread.sleep(INTERVAL_TIME);
                }
            }catch (InterruptedException e){

            }

            String returnStr = HttpClientUtil.doPostJson(url,json,userCode,pwd);
//            logger.info( i + "次同步部门返回信息："+returnStr);

            JSONObject returnJson = JSONObject.parseObject(returnStr);
            JSONObject esb = (JSONObject) returnJson.get("ESB");
            String status = esb.get("STATUS").toString();
            if(!"S".equals(status)){
                return CommonResponse.error("调用主数据接口失败！");
            }
            JSONObject data = esb.getJSONObject("DATA");
            JSONObject splitPage = data.getJSONObject("SPLITPAGE");
            totalPages = splitPage.getInteger("TOTALPAGES");//总页数
            JSONObject dataInfos = data.getJSONObject("DATAINFOS");
            JSONArray dataInfoArr = dataInfos.getJSONArray("DATAINFO");

            for (Object obj : dataInfoArr) {
                JSONObject dataInfo = (JSONObject) obj;
                logger.info( "开始同步部门----------"+dataInfo.toString());
                String code = dataInfo.getString("CODE");//组织code，唯一值
                String desc6 = dataInfo.getString("DESC6");//所属单位编码的值
                String desc28 = dataInfo.getString("DESC28");//机构类型
                String desc1 = dataInfo.getString("DESC1");//组织名称
                String parentDesc = dataInfo.getString("PARENTDESC");//上级组织

                if(Constants.ORG_GROUP.equals(code)){
                    //如果是集团，跳出不处理
                    continue;
                }else if(Constants.ORG_FINANCE_SHARE.equals(code) || Constants.ORG_FUNDING_SHARE.equals(code)){
                    //财务共享服务中心、资金中心，跳出不处理
                    continue;
                }else if(Constants.ORG_FINANCE_SHARE.equals(desc6) || Constants.ORG_FUNDING_SHARE.equals(desc6)){
                    //财务共享服务中心、资金中心，跳出不处理
                    continue;
                }else if(desc1.contains("工区") || desc1.contains("区域项目")){
                    //工区和区域项目当做部门处理
                    desc28 = "部门";
                }else if(parentDesc.contains("工区") || parentDesc.contains("区域项目")){
                    //上级为工区和区域项目当做部门处理
                    desc28 = "部门";
                }else if(!"部门".equals(desc28)){
                    //机构类型不为部门的忽略
                    continue;
                }else if("".equals(desc28)){
                    //机构类型为空的忽略
                    continue;
                }

                //根据source_id查询系统中是够已经存在
                QueryWrapper<IdmDeptEntity> query = new QueryWrapper<>();
                query.eq("source_id", dataInfo.getString("CODE"));
                query.eq("dr", 0);

                IdmDeptEntity deptEntity = deptService.getOne(query);
                if(deptEntity == null){
                    //不存在，做新增操作
                    deptEntity = new IdmDeptEntity();
                    long id = IdWorker.getId();
                    deptEntity.setId(id);
                    deptEntity.setRowState("add");
                }else{
                    //存在，做更新操作
                    deptEntity.setRowState("edit");
                }
                deptEntity.setCode(dataInfo.getString("CODE"));//组织机构编码的值
                deptEntity.setName(dataInfo.getString("DESC1"));//组织机构名称的值
//                deptEntity.setShortName(dataInfo.getString("DESC1"));//简称
                deptEntity.setSourceId(dataInfo.getString("CODE"));//来源id

                String[] codes = dataInfo.getString("CODE").split("-");
                if(codes.length > 1){
                    Pattern pattern = Pattern.compile("[0-9]*");
                    boolean matches = pattern.matcher(codes[1]).matches();
                    if(matches){
                        deptEntity.setSequence(new Long(codes[1]).intValue());
                    }else{
                        deptEntity.setSequence(null);
                    }
                }else{
                    Pattern pattern = Pattern.compile("[0-9]*");
                    boolean matches = pattern.matcher(codes[0]).matches();
                    if(matches){
                        deptEntity.setSequence(new Long(codes[0]).intValue());
                    }else{
                        deptEntity.setSequence(null);
                    }
                }

                deptEntity.setState(dataInfo.getInteger("DESC31"));//启用状态，1启用、0停用
                deptEntity.setType(1);//类型

                //处理所属组织
                boolean flag = true ;
                String orgCode = dataInfo.getString("PARENTCODE");
                if(deptMap.get(orgCode) == null || "".equals(deptMap.get(orgCode).toString())){
                    //有遇到上级停用了接口拿不到数据，下级还是生效的
                    logger.info( "----------上级部门未找到"+orgCode);
                    continue;
                }
                while (flag){
                    JSONObject jsonObject = deptMap.get(orgCode);
                    if(jsonObject == null){
                        flag = false;
                    }else if( !"".equals(jsonObject.getString("DESC28")) && !"部门".equals(jsonObject.getString("DESC28"))){
                        orgCode = jsonObject.getString("CODE");
                        flag = false;
                    }else{
                        orgCode = jsonObject.getString("PARENTCODE");
                    }
                }
                QueryWrapper<IdmOrgEntity> queryOrg = new QueryWrapper<>();
                queryOrg.eq("code", orgCode);
                IdmOrgEntity orgEntity = orgService.getOne(queryOrg);
                deptEntity.setOrgId(orgEntity.getId());

                //处理上级
                String parentCode = dataInfo.getString("PARENTCODE");
                if(parentCode.equals(orgCode)){
                    //如果parentCode和所属组织code一致，说明都是组织下的一级部门
                }else{
                    QueryWrapper<IdmDeptEntity> queryParent = new QueryWrapper<>();
                    queryParent.eq("code", parentCode);
                    IdmDeptEntity ParentEntity = deptService.getOne(queryParent);

                    if(ParentEntity == null){
                        //todo 父级组织不存在异常处理
                        logger.info( dataInfo.getString("CODE") + "在系统中未找到上级组织"+parentCode);
                        errorNum ++;
                        continue;
                    }else{
                        deptEntity.setPid(ParentEntity.getId());
                    }
                }

                if("add".equals(deptEntity.getRowState())){
                    addNum ++;
                }else if("edit".equals(deptEntity.getRowState())){
                    updateNum ++;
                }

                deptService.saveOrUpdate(deptEntity,false);
            }
        }

        return CommonResponse.success("同步部门成功！新增" + addNum + "条，更新" + updateNum + "条,未找到上级部门" + errorNum + "条");
    }

    @Override
    public CommonResponse<String> synIdmEmp(String type,String queryCode) {
        int totalPages = 1;//初始化查询页数为1

        CommonResponse<ParamRegisterSetVO> urlParam = paramConfigApi.getByCode(emp_url_param);
        CommonResponse<ParamRegisterSetVO> userCodeParam = paramConfigApi.getByCode(user_code_param);
        CommonResponse<ParamRegisterSetVO> passWordParam = paramConfigApi.getByCode(password_param);

        String url = "";
        String userCode = "";
        String pwd = "";

        if(urlParam.getCode() == 1 || userCodeParam.getCode() == 1 || passWordParam.getCode() == 1){
            logger.info("主数据同步-组织获取参数失败！");
            return CommonResponse.error("获取参数失败！");
        }else{
            url = urlParam.getData().getValueData();
            userCode = userCodeParam.getData().getValueData();
            pwd = passWordParam.getData().getValueData();
        }

        int addNum = 0;
        int updateNum = 0;
        int errorNum = 0;
        for (int i = 1; i <= totalPages; i++) {
            String json = SynDataBuilder.getReqJson(i + "",null, type,queryCode,"");
            logger.info(i + "同步人员查询参数为：" + json);

            try {
                if (i > 1) {
                    Thread.sleep(INTERVAL_TIME);
                }
            } catch (InterruptedException e) {

            }

            String returnStr = HttpClientUtil.doPostJson(url, json, userCode, pwd);
            if (returnStr == null || "".equals(returnStr)) {
                return CommonResponse.error("调用主数据接口失败！");
            }
            JSONObject returnJson = JSONObject.parseObject(returnStr);
            JSONObject esb = (JSONObject) returnJson.get("ESB");
            String status = esb.get("STATUS").toString();
            if (!"S".equals(status)) {
                return CommonResponse.error("调用主数据接口失败！");
            }
            JSONObject data = esb.getJSONObject("DATA");
            JSONObject splitPage = data.getJSONObject("SPLITPAGE");
            totalPages = splitPage.getInteger("TOTALPAGES");//总页数

            JSONObject dataInfos = data.getJSONObject("DATAINFOS");
            JSONArray dataInfoArr = dataInfos.getJSONArray("DATAINFO");

            for (Object obj : dataInfoArr) {
                JSONObject dataInfo = (JSONObject) obj;

                //组装用户
                if(StringUtils.isEmpty(dataInfo.getString("DESC32"))){
                    continue;
                }

                UserVO userVo = new UserVO();
                userVo.setSourceId(dataInfo.getString("DESC32"));//来源id，对应自有工号
                userVo.setUserCode(dataInfo.getString("DESC32"));//登录用户编码,对应自有工号
                userVo.setUserName(dataInfo.getString("DESC1"));//用户名称
                userVo.setUserMobile(dataInfo.getString("DESC22"));//手机号
                if("男".equals(dataInfo.getString("DESC5"))){
                    userVo.setSex("1"); //性别
                }else if("女".equals(dataInfo.getString("DESC5"))){
                    userVo.setSex("2");
                }

                //组装人员
                EmployeeVO employeeVo = new EmployeeVO();
                employeeVo.setCode(dataInfo.getString("CODE"));//员工编码——集团人员编码
                employeeVo.setName(userVo.getUserName());//员工名称
                employeeVo.setSex(Integer.parseInt(userVo.getSex()));//性别
                employeeVo.setMobilePhone(userVo.getUserMobile());//手机号
                employeeVo.setIdcard(dataInfo.getString("DESC11"));//身份证
                employeeVo.setWorkTime(DateUtils.createDate(dataInfo.getString("DESC16")));//入职日期

                if("启用".equals(dataInfo.getString("DESC29"))){
                    userVo.setUserState(UserVO.USER_STATE_ACTIVE); //启用状态
                    employeeVo.setState(UserVO.USER_STATE_ACTIVE);
                }else{
                    userVo.setUserState(UserVO.USER_STATE_INACTIVE); //停用状态
                    employeeVo.setState(UserVO.USER_STATE_INACTIVE);
                }

                //组装SyncEmployeeAndUserVO
                SyncEmployeeAndUserVO syncVO = new SyncEmployeeAndUserVO();
                syncVO.setSourceOrgId(dataInfo.getString("CATEGORYCODE"));//来源组织
                syncVO.setUser(userVo);
                syncVO.setEmployee(employeeVo);

                SynEmpApi.syncEmployeeAndUser(syncVO);
            }
        }
        return CommonResponse.success("人员同步成功！666");
    }

}
