package com.ejianc.idmdata.orgcenter.controller;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.idmdata.orgcenter.service.IExternalService;
import com.ejianc.idmdata.orgcenter.vo.ActRuTaskVO;
import com.ejianc.idmdata.orgcenter.vo.AttachmentVO;
import com.ejianc.idmdata.orgcenter.vo.ButtonVO;
import com.ejianc.idmdata.orgcenter.vo.IdeModuleVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("external")
public class ExternalController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IExternalService externalService;

    @PostMapping("/getButton")
    @ResponseBody
    public CommonResponse<List<ButtonVO>> getButton(@RequestBody Map<String, Object> params) {
        return CommonResponse.success(externalService.getButton(params));
    }

    @PostMapping("/getButtonCount")
    @ResponseBody
    public CommonResponse<Integer> getButtonCount() {
        return CommonResponse.success(externalService.getButtonCount());
    }

    @PostMapping("/getFileId")
    @ResponseBody
    public CommonResponse<List<AttachmentVO>> getFileId(@RequestBody Map<String, Object> params) {
        return CommonResponse.success(externalService.getFileId(params));
    }

    @PostMapping("/getByBizKey")
    @ResponseBody
    public CommonResponse<List<ActRuTaskVO>> getByBizKey(String businessKey) {
        return CommonResponse.success(externalService.getByBizKey(businessKey));
    }

    @PostMapping("/getMyPageInfo")
    @ResponseBody
    public CommonResponse<List<IdeModuleVO>> getMyPageInfo(String appId, String code) {
        return CommonResponse.success(externalService.getMyPageInfo(appId, code));
    }

    @PostMapping("/getOrgIdByOrgCode")
    @ResponseBody
    public CommonResponse<List<Long>> getOrgIdByOrgCode(String orgCode) {
        return CommonResponse.success(externalService.getOrgIdByOrgCode(orgCode));
    }

    @PostMapping("/getMapProjLocal")
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> getMapProjLocal() {
        return CommonResponse.success(externalService.getMapProjLocal());
    }

    @PostMapping("/queryAllDept")
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryAllDept() {
        return CommonResponse.success(externalService.queryAllDept());
    }
}
