/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.idmdata.orgcenter.controller;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.idmdata.orgcenter.service.IExternalService;
import com.ejianc.idmdata.orgcenter.vo.ActRuTaskVO;
import com.ejianc.idmdata.orgcenter.vo.AttachmentVO;
import com.ejianc.idmdata.orgcenter.vo.ButtonVO;
import com.ejianc.idmdata.orgcenter.vo.IdeModuleVO;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"external"})
public class ExternalController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IExternalService externalService;

    @PostMapping(value={"/getButton"})
    @ResponseBody
    public CommonResponse<List<ButtonVO>> getButton(@RequestBody Map<String, Object> params) {
        return CommonResponse.success(this.externalService.getButton(params));
    }

    @PostMapping(value={"/getButtonCount"})
    @ResponseBody
    public CommonResponse<Integer> getButtonCount() {
        return CommonResponse.success((Object)this.externalService.getButtonCount());
    }

    @PostMapping(value={"/getFileId"})
    @ResponseBody
    public CommonResponse<List<AttachmentVO>> getFileId(@RequestBody Map<String, Object> params) {
        return CommonResponse.success(this.externalService.getFileId(params));
    }

    @PostMapping(value={"/getByBizKey"})
    @ResponseBody
    public CommonResponse<List<ActRuTaskVO>> getByBizKey(String businessKey) {
        return CommonResponse.success(this.externalService.getByBizKey(businessKey));
    }

    @PostMapping(value={"/getMyPageInfo"})
    @ResponseBody
    public CommonResponse<List<IdeModuleVO>> getMyPageInfo(String appId, String code) {
        return CommonResponse.success(this.externalService.getMyPageInfo(appId, code));
    }

    @PostMapping(value={"/getOrgIdByOrgCode"})
    @ResponseBody
    public CommonResponse<List<Long>> getOrgIdByOrgCode(String orgCode) {
        return CommonResponse.success(this.externalService.getOrgIdByOrgCode(orgCode));
    }

    @PostMapping(value={"/getMapProjLocal"})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> getMapProjLocal() {
        return CommonResponse.success(this.externalService.getMapProjLocal());
    }

    @PostMapping(value={"/queryAllDept"})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryAllDept() {
        return CommonResponse.success(this.externalService.queryAllDept());
    }

    @PostMapping(value={"/queryAllDeptCondition"})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryAllDeptCondition(String orgId) {
        return CommonResponse.success(this.externalService.queryAllDeptCondition(orgId));
    }

    @PostMapping(value={"/getMapAllEmployee"})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> getMapAllEmployee() {
        return CommonResponse.success(this.externalService.getMapAllEmployee());
    }

    @PostMapping(value={"/getAttachmentBySourceIdAndSourceType"})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> getAttachmentBySourceIdAndSourceType(Long sourceId, String sourceType) {
        return CommonResponse.success(this.externalService.getAttachmentBySourceIdAndSourceType(sourceId, sourceType));
    }
}

