package com.ejianc.idmdata.orgcenter.service.impl;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.idmdata.orgcenter.mapper.ExternalMapper;
import com.ejianc.idmdata.orgcenter.service.IExternalService;
import com.ejianc.idmdata.orgcenter.vo.ActRuTaskVO;
import com.ejianc.idmdata.orgcenter.vo.AttachmentVO;
import com.ejianc.idmdata.orgcenter.vo.ButtonVO;
import com.ejianc.idmdata.orgcenter.vo.IdeModuleVO;
import com.ejianc.ztpcdata.vo.EmployeeVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service("externalService")
public class ExternalServiceImpl implements IExternalService {

    @Autowired
    private ExternalMapper externalMapper;


    @Override
    public List<ButtonVO> getButton(Map<String, Object> params){
        return externalMapper.selectButton(params);
    }

    @Override
    public int getButtonCount() {
        return externalMapper.selectButtonCount();
    }

    @Override
    public List<AttachmentVO> getFileId(Map<String, Object> params) {
        return externalMapper.selectBySourceId(params);
    }

    @Override
    public List<ActRuTaskVO> getByBizKey(String businessKey) {
        return externalMapper.selectByBizKey(businessKey);
    }

    @Override
    public List<IdeModuleVO> getMyPageInfo(String appId, String code) {
        return externalMapper.selectMyPageInfo(appId, code);
    }

    @Override
    public List<Long> getOrgIdByOrgCode(String orgCode) {
        return externalMapper.selectOrgIdByOrgCode(orgCode);
    }

    @Override
    public List<Map<String, Object>> getMapProjLocal() {
        return externalMapper.queryMapProjLocal();
    }

    @Override
    public List<Map<String, Object>> queryAllDept() {
        return externalMapper.queryMapAllDept();
    }

    @Override
    public List<Map<String, Object>> queryAllDeptCondition(String orgId) {
        return externalMapper.queryAllDeptCondition(orgId);
    }

    @Override
    public List<Map<String, Object>> getMapAllEmployee() {
        return externalMapper.queryMapAllEmployee();
    }

    @Override
    public List<Map<String, Object>> getAttachmentBySourceIdAndSourceType(Long sourceId, String sourceType) {
        return externalMapper.getAttachmentBySourceIdAndSourceType(sourceId,sourceType);
    }

    @Override
    public List<OrgVO> getOrgList(Integer orgType, Integer projectState, Long parentOrgId) {
        return externalMapper.getOrgList(orgType,projectState,parentOrgId);
    }

    @Override
    public List<EmployeeVO> getEmployeeByName(List<String> names) {
        return externalMapper.getEmployeeByName(names);
    }

    @Override
    public List<SupplierVO> querySupplierByName(String name) {
        return externalMapper.querySupplierByName(name);
    }
    @Override
    public List<SupplierVO> querySupplierByIds(String ids) {
        return externalMapper.querySupplierByIds(ids);
    }
}
