package com.ejianc.idmdata.orgcenter.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.sync.vo.SyncEmployeeAndUserVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.idmdata.orgcenter.bean.*;
import com.ejianc.idmdata.orgcenter.mapper.IdmEmployeeMapper;
import com.ejianc.idmdata.orgcenter.service.*;
import com.ejianc.ztpcdata.util.PasswordUtils;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 人员
 * 
 * @author generator
 * 
 */
@Service("idmEmployeeService")
public class IdmEmployeeServiceImpl extends BaseServiceImpl<IdmEmployeeMapper, IdmEmployeeEntity> implements IIdmEmployeeService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IIdmOrgService orgService;

    @Autowired
    private IIdmDeptService deptService;

    @Autowired
    private IIdmEmployeeService employeeService;

    @Autowired
    private IIdmUserService userService;

    @Autowired
    private IIdmJobService jobService;

    @Override
    public CommonResponse<String> syncEmployeeAndUserList(List<SyncEmployeeAndUserVO> employeeAndUserVOs) {
        for(SyncEmployeeAndUserVO syncVO : employeeAndUserVOs){
            try{
                EmployeeVO employeeVo = syncVO.getEmployee();
                UserVO userVo = syncVO.getUser();
                logger.info("=================");
                logger.info(JSON.toJSONString(syncVO));
                if("3".equals(syncVO.getType())){
                    //删除用户
                }else if("1".equals(syncVO.getType())){
                    QueryWrapper<IdmUserEntity> queryUserWrapper = new QueryWrapper<>();
                    queryUserWrapper.eq("dr", 0);
                    queryUserWrapper.eq("source_id", userVo.getSourceId());
                    IdmUserEntity userCheckEntity = userService.getOne(queryUserWrapper);
                    if(userCheckEntity!=null){
                        logger.info("++++++++++");
                        logger.info("人员："+userVo.getUserName()+"已存在");
                        continue;
                    }

                    QueryWrapper<IdmDeptEntity> queryWrapper = new QueryWrapper<>();
                    queryWrapper.eq("dr", 0);
                    queryWrapper.eq("source_id", syncVO.getSourceOrgId());
                    IdmDeptEntity deptEntity = deptService.getOne(queryWrapper);
                    IdmOrgEntity orgEntity = null;
                    if(deptEntity == null) {
                        QueryWrapper<IdmOrgEntity> orgWrapper = new QueryWrapper<>();
                        orgWrapper.eq("dr", 0);
                        orgWrapper.eq("source_id", syncVO.getSourceOrgId());
                        orgEntity = orgService.getOne(orgWrapper);
                    }
                    if(deptEntity != null) {
                        userVo.setOrgId(deptEntity.getOrgId());
                    }else{
                        userVo.setOrgId(orgEntity != null ? orgEntity.getId():null);
                    }

                    Long pkId = IdWorker.getId();
                    //新增用户
                    userVo.setId(pkId);
                    userVo.setTypeId(2); //普通用户
                    userVo.setUserState(UserVO.USER_STATE_ACTIVE); //启用状态
                    userVo.setDr(BaseVO.DR_UNDELETE);
                    //生成默认密码
                    PasswordUtils.setSalt(userVo);
                    String shaPassword = PasswordUtils.encodePasswordUsingSHA("sdbj_ejc_2020");
                    userVo.setPassword(shaPassword);
                    userVo.setPassword(PasswordUtils.encodebyUserCode(userVo));
                    userVo.setPwdStartTime(new Date());
                    IdmUserEntity userEntity = BeanMapper.map(userVo, IdmUserEntity.class);
                    userService.saveOrUpdate(userEntity, false);

                    //新增人员
                    if(deptEntity != null) {
                        employeeVo.setOrgId(deptEntity.getOrgId());
                        employeeVo.setDeptId(deptEntity.getId());
                    }else{
                        employeeVo.setOrgId(orgEntity != null ? orgEntity.getId():null);
                    }
                    employeeVo.setId(pkId);
                    employeeVo.setState(1);
                    employeeVo.setEmployeeType(1);//在职
                    employeeVo.setUserId(userEntity.getId());
                    employeeVo.setUserId(pkId);
                    IdmEmployeeEntity employeeEntity = BeanMapper.map(employeeVo, IdmEmployeeEntity.class);
                    employeeService.saveOrUpdate(employeeEntity, false);

                    //任职信息
                    IdmJobEntity job = new IdmJobEntity();
                    job.setOrgId(employeeVo.getOrgId());
                    job.setDeptId(employeeVo.getDeptId());
                    job.setEmployeeId(employeeVo.getId());
                    job.setProperty(1);
                    job.setJobStartTime(new Date());
                    job.setCurState(0);
                    job.setSystemId(employeeVo.getSystemId());
                    jobService.saveOrUpdate(job,false);

                }else {
                    QueryWrapper<IdmDeptEntity> queryDeptWrapper = new QueryWrapper<>();
                    queryDeptWrapper.eq("dr", 0);
                    queryDeptWrapper.eq("source_id", syncVO.getSourceOrgId());
                    IdmDeptEntity deptEntity = deptService.getOne(queryDeptWrapper);
                    IdmOrgEntity orgEntity = null;
                    if(deptEntity == null) {
                        QueryWrapper<IdmOrgEntity> orgWrapper = new QueryWrapper<>();
                        orgWrapper.eq("dr", 0);
                        orgWrapper.eq("source_id", syncVO.getSourceOrgId());
                        orgEntity = orgService.getOne(orgWrapper);
                    }
                    if(deptEntity != null) {
                        userVo.setOrgId(deptEntity.getOrgId());
                    }else{
                        userVo.setOrgId(orgEntity != null ? orgEntity.getId():null);
                    }
                    //保存用户
                    QueryWrapper<IdmUserEntity> queryWrapper = new QueryWrapper<>();
                    queryWrapper.eq("dr", 0);
                    queryWrapper.eq("source_id", userVo.getSourceId());
                    IdmUserEntity userEntity = userService.getOne(queryWrapper);
                    if(userEntity == null){
                        logger.info("人员："+userVo.getUserName()+"未查询到信息");
                        continue;
//						throw new BusinessException("人员："+userVo.getUserName()+"未查询到信息");
                    }
//							employeeEntity.setCode(vo.getCode());//若修改编码需要修改密码，
                    userEntity.setUserName(userVo.getUserName());
                    userEntity.setSex(Integer.valueOf(userVo.getSex()));
                    userEntity.setRegistTime(userVo.getRegistTime());
                    userEntity.setUserMobile(userVo.getUserMobile());
                    userEntity.setUserEmail(userVo.getUserEmail());
                    userEntity.setOrgId(userVo.getOrgId());
                    userEntity.setQqId(userVo.getQqId());
                    userService.saveOrUpdate(userEntity, false);

                    //新增人员
                    if(deptEntity != null) {
                        employeeVo.setOrgId(deptEntity.getOrgId());
                        employeeVo.setDeptId(deptEntity.getId());
                    }else{
                        employeeVo.setOrgId(orgEntity != null ? orgEntity.getId():null);
                    }
                    //保存
                    QueryWrapper<IdmEmployeeEntity> queryEmployeeWrapper = new QueryWrapper<>();
                    queryEmployeeWrapper.eq("dr", 0);
                    queryEmployeeWrapper.eq("source_id", employeeVo.getSourceId());
                    IdmEmployeeEntity employeeEntity = employeeService.getOne(queryEmployeeWrapper);
                    if(employeeEntity == null){
                        logger.info("人员："+userVo.getUserName()+"未查询到信息");
                        continue;
//						return CommonResponse.error("人员："+employeeVo.getName()+"未查询到信息");
                    }
                    List<IdmJobEntity> saveJob = new ArrayList<>();//同步更新主职信息表
                    if(((employeeVo.getOrgId()!=null&&employeeEntity.getOrgId()==null)||
                            (employeeEntity.getOrgId()!=null&&employeeVo.getOrgId()==null)||
                            (employeeVo.getOrgId()!=null&&employeeEntity.getOrgId()!=null&&!employeeVo.getOrgId().equals(employeeEntity.getOrgId())))||(
                            (employeeVo.getDeptId()!=null&&employeeEntity.getDeptId()==null)||
                                    (employeeEntity.getDeptId()!=null&&employeeVo.getDeptId()==null)||
                                    (employeeVo.getDeptId()!=null&&employeeEntity.getDeptId()!=null&&!employeeVo.getDeptId().equals(employeeEntity.getDeptId()))
                    )){
                        //当用户的组织改变时，修改主职的信息(相当于调用)
                        QueryWrapper<IdmJobEntity> jobWrapper = new QueryWrapper<>();
                        jobWrapper.eq("dr", 0);
                        jobWrapper.eq("employee_id", employeeEntity.getId());
                        jobWrapper.eq("property", 1);//主职
                        jobWrapper.eq("cur_state", 0);//启用
                        IdmJobEntity jobEntity = jobService.getOne(jobWrapper, false);
                        //将原先的主职信息停用掉
                        if(jobEntity!=null){
                            jobEntity.setCurState(1);
                            jobEntity.setJobEndTime(new Date());
                            saveJob.add(jobEntity);
                        }
                        //新增一条新的记录

                        IdmJobEntity jobNewEntity = new IdmJobEntity();
                        jobNewEntity.setOrgId(employeeVo.getOrgId());
                        jobNewEntity.setDeptId(employeeVo.getDeptId());
                        jobNewEntity.setEmployeeId(employeeEntity.getId());
                        jobNewEntity.setProperty(1);
                        jobNewEntity.setJobStartTime(new Date());
                        jobNewEntity.setCurState(0);
                        jobNewEntity.setSystemId(employeeVo.getSystemId());
                        saveJob.add(jobNewEntity);
                    }
                    employeeEntity.setCode(employeeVo.getCode());
                    employeeEntity.setName(employeeVo.getName());
                    employeeEntity.setIdcard(employeeVo.getIdcard());
                    employeeEntity.setBirthday(employeeVo.getBirthday());
                    employeeEntity.setSex(employeeVo.getSex());
                    employeeEntity.setWorkTime(employeeVo.getWorkTime());
                    employeeEntity.setDeptId(employeeVo.getDeptId());
                    employeeEntity.setMobilePhone(employeeVo.getMobilePhone());
                    employeeEntity.setOtherPhone(employeeVo.getOtherPhone());
                    employeeEntity.setOrgId(employeeVo.getOrgId());
//						saveEmployeeList.add(BeanMapper.map(employeeEntity, EmployeeVO.class));
                    employeeService.saveOrUpdate(employeeEntity, false);
                    if(saveJob.size()>0){
                        //主职信息保存
                        jobService.saveOrUpdateBatch(saveJob, saveJob.size(),false);
                    }
                }
            }catch (Exception e){
                logger.info("人员、用户信息同步失败--------------->");
                logger.info(JSON.toJSONString(syncVO));
            }

        }
        return CommonResponse.success("保存人员、用户信息成功！");
    }
}
