package com.ejianc.business.ztpc.billcode.api;

import com.ejianc.business.ztpc.billcode.bean.DcDrwgrpInfoVO;
import com.ejianc.business.ztpc.billcode.bean.QueryDrwgrpParam;
import com.ejianc.business.ztpc.billcode.hystrix.DcDrwgrpInfoHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

@FeignClient(
        name = "ejc-ztpcdc-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-ztpcdc-web",
        fallback = DcDrwgrpInfoHystrix.class
)
public interface IDcDrwgrpInfoApi {

    @RequestMapping(value = "/dcDrwgrpInfo/queryListByProjectAndCodes")
    @ResponseBody
    public CommonResponse<List<DcDrwgrpInfoVO>> queryListByProjectAndCodes(@RequestBody QueryDrwgrpParam param);

    @RequestMapping(value = "/dcDrwgrpInfo/pushSettlementCenterByProjectAndCodes")
    @ResponseBody
    public CommonResponse<List<DcDrwgrpInfoVO>> pushSettlementCenterByProjectAndCodes(@RequestParam("projectId") Long projectId,@RequestParam("planId") Long planId,@RequestParam("codeList") List<String> codeList);
}
