package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.asset.bean.AssetOutDetailEntity;
import com.ejianc.business.asset.bean.AssetOutEntity;
import com.ejianc.business.asset.bean.AssetRecordEntity;
import com.ejianc.business.asset.service.IAssetRecordService;
import com.ejianc.business.asset.vo.AssetVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.asset.mapper.AssetMapper;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.service.IAssetService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 固定资产
 * 
 * @author generator
 * 
 */
@Service("assetService")
public class AssetServiceImpl extends BaseServiceImpl<AssetMapper, AssetEntity> implements IAssetService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAssetRecordService assetRecordService;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public void updateAssetRecord(List<Long> assetIdList, AssetOutEntity outEntity) {
        super.update(new UpdateWrapper<AssetEntity>().in("id", assetIdList).set("out_occupy_flag", 0)
                .set("project_id", outEntity.getInProjectId())
                .set("project_name", outEntity.getInProjectName())
                .set("project_code", outEntity.getInProjectCode())
                .set("org_id", outEntity.getInOrgId())
                .set("org_name", outEntity.getInOrgName())
        );
        List<AssetRecordEntity> assetRecordEntityList = new ArrayList<>();
        for (Long assetId : assetIdList) {
            AssetRecordEntity assetRecordEntity = new AssetRecordEntity();
            assetRecordEntity.setId(IdWorker.getId());
            assetRecordEntity.setAssetId(assetId);
            assetRecordEntity.setOutProjectId(outEntity.getProjectId());
            assetRecordEntity.setOutProjectName(outEntity.getProjectName());
            assetRecordEntity.setOutProjectCode(outEntity.getProjectCode());
            assetRecordEntity.setOutOrgId(outEntity.getOrgId());
            assetRecordEntity.setOutOrgName(outEntity.getOrgName());
            assetRecordEntity.setSourceBillId(outEntity.getId());
            assetRecordEntity.setSourceBillCode(outEntity.getBillCode());
            assetRecordEntity.setOutDate(outEntity.getOutDate());
            assetRecordEntityList.add(assetRecordEntity);
        }
        assetRecordService.saveOrUpdateBatch(assetRecordEntityList, assetRecordEntityList.size(), false);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {


        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);

            List<AssetVO> successList = new ArrayList<>();
            List<AssetVO> errorList = new ArrayList<>();

            if (result != null && result.size() > 0) {
                if (result.size() >= 1000) {
                    throw new BusinessException("文件数据不能超过1000行，超过请分批次多次导入");
                }

                CommonResponse<List<DefdocDetailVO>> defAssetTypeList = defdocApi.getDefDocByDefCode("zy-asset-type");
                logger.info("自定义档案资产类别查询使用时间----------->{}", new Date());

                CommonResponse<List<DefdocDetailVO>> defDepreciationList = defdocApi.getDefDocByDefCode("zydx-depreciation");
                logger.info("自定义档案折旧方法使用时间----------->{}", new Date());

                if (!defAssetTypeList.isSuccess()) {
                    return CommonResponse.error("导入失败，查询自定义档案资产类别失败，请重试！");
                }
                if (!defDepreciationList.isSuccess()) {
                    return CommonResponse.error("导入失败，查询自定义档案折旧方法失败，请重试！");
                }


                Map<String, ProjectRegisterVO> projectPoolSetVOMap = new HashMap<>();
                Map<String, OrgVO> orgVOMap = new HashMap<>();

                Map<String, DefdocDetailVO> defAssetTypeMap = defAssetTypeList.getData().stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));
                Map<String, DefdocDetailVO> defDepreciationMap = defDepreciationList.getData().stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));

                Long employeeId = sessionManager.getUserContext().getEmployeeId();
                String employeeName = null;
                CommonResponse<EmployeeVO> userData = employeeApi.getById(employeeId);
                if (userData.isSuccess()) {
                    employeeName = userData.getData().getName();
                }


                for (int i = 1; i < result.size(); i++) {
                    StringBuilder errorMessage = new StringBuilder();
                    List<String> datas = result.get(i);
                    AssetVO importVO = new AssetVO();


                    if (StringUtils.isNotBlank(datas.get(0))){
                        importVO.setBillCode(datas.get(0));
                    }else {
                        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode("ZY_ASSET", tenantId);
                        if(billCode.isSuccess()) {
                            importVO.setBillCode(billCode.getData());
                        }else{
                            throw new BusinessException("网络异常，调入单号生成失败，请稍后再试");
                        }
                    }
                    //固定资产名称
                    if (StringUtils.isBlank(datas.get(1))) {
                        errorMessage.append("[固定资产名称为必填项]");
                    } else {
                        importVO.setAssetName(datas.get(1));
                        if (datas.get(1).length() > 200) {
                            importVO.setErrorMessage("[固定资产名称长度为1~200字]");
                        }
                    }

                    //固定资产类别
                    if (StringUtils.isNotBlank(datas.get(2))) {
                        importVO.setAssetTypeName(datas.get(2));
                        if (datas.get(2).length() > 100) {
                            errorMessage.append("[填写固定资产类别长度为1~100字]");
                        } else {
                            if (defAssetTypeMap.get(datas.get(2)) == null) {
                                errorMessage.append("[自定义档案不存在当前固定资产类别]");
                            } else {
                                importVO.setAssetTypeId(defAssetTypeMap.get(datas.get(2)).getId());
                            }
                        }
                    }

                    //财务入账日期
                    if (StringUtils.isBlank(datas.get(4))) {
                        errorMessage.append("[财务入账日期为必填项]");
                    } else {
                        try {
                            importVO.setFinanceEntryDate(DateUtils.parseDate(datas.get(4), "YYYY-MM-dd"));
                        } catch (ParseException e) {
                            errorMessage.append("[财务入账日期填写格式错误，请填写 YYYY-MM-dd 类型的日期格式]");
                            e.printStackTrace();
                        }
                    }
                    importVO.setDepositPlace(datas.get(5));
                    importVO.setUseDept(datas.get(6));
                    importVO.setUsePerson(datas.get(7));
                    importVO.setSpec(datas.get(8));
                    importVO.setOrigin(datas.get(9));
                    importVO.setMaker(datas.get(10));
                    importVO.setTecCode(datas.get(11));

                    //折旧方法
                    if (StringUtils.isNotBlank(datas.get(12))) {
                        importVO.setDepreciationName(datas.get(12));
                        if (datas.get(12).length() > 100) {
                            errorMessage.append("[填写折旧方法长度为1~100字]");
                        } else {
                            if (defDepreciationMap.get(datas.get(12)) == null) {
                                errorMessage.append("[自定义档案不存在当前折旧方法]");
                            } else {
                                importVO.setDepreciationId(defDepreciationMap.get(datas.get(12)).getId());
                            }
                        }
                    }

                    //原币金额
                    if (StringUtils.isNotBlank(datas.get(13))) {
                        try {
                            importVO.setInitCoinMny(new BigDecimal(datas.get(13)));
                        } catch (Exception e) {
                            errorMessage.append("[原币金额必须为数字]");
                        }
                    }
                    //资产原值
                    if (StringUtils.isNotBlank(datas.get(14))) {
                        try {
                            importVO.setAssetInitMny(new BigDecimal(datas.get(14)));
                        } catch (Exception e) {
                            errorMessage.append("[资产原值必须为数字]");
                        }
                    }

                    importVO.setExpectUseTerm(datas.get(15));
                    importVO.setDepreciationTerm(datas.get(16));

                    //累计折旧
                    if (StringUtils.isNotBlank(datas.get(17))) {
                        try {
                            importVO.setTotalDepreciationMny(new BigDecimal(datas.get(17)));
                        } catch (Exception e) {
                            errorMessage.append("[累计折旧必须为数字]");
                        }
                    }
                    //预计净残值
                    if (StringUtils.isNotBlank(datas.get(18))) {
                        try {
                            importVO.setExpectSalvageMny(new BigDecimal(datas.get(18)));
                        } catch (Exception e) {
                            errorMessage.append("[预计净残值必须为数字]");
                        }
                    }
                    //净值
                    if (StringUtils.isNotBlank(datas.get(19))) {
                        try {
                            importVO.setNetMny(new BigDecimal(datas.get(19)));
                        } catch (Exception e) {
                            errorMessage.append("[净值必须为数字]");
                        }
                    }


                    //使用项目
                    if (StringUtils.isNotBlank(datas.get(20))) {
                        importVO.setProjectName(datas.get(20));
                        importVO.setDependOnProject(1);
                        if (datas.get(20).length() > 128) {
                            errorMessage.append("[填写使用项目长度为1~128字]");
                        } else {
                            if (projectPoolSetVOMap.get(datas.get(20)) != null) {
                                importVO.setProjectId(projectPoolSetVOMap.get(datas.get(20)).getId());
                                importVO.setProjectCode(projectPoolSetVOMap.get(datas.get(20)).getCode());
                                importVO.setOrgId(projectPoolSetVOMap.get(datas.get(20)).getProjectDepartmentId());

                            } else {
                                CommonResponse<ProjectRegisterVO> projectData = projectApi.getDataByName(datas.get(20));
                                if (!projectData.isSuccess()) {
                                    errorMessage.append("[项目池不存在当前使用项目的项目]");
                                } else {
                                    if (null != projectData.getData()) {
                                        projectPoolSetVOMap.put(datas.get(20), projectData.getData());
                                        importVO.setProjectId(projectPoolSetVOMap.get(datas.get(20)).getId());
                                        importVO.setProjectCode(projectPoolSetVOMap.get(datas.get(20)).getCode());
                                        importVO.setOrgId(projectPoolSetVOMap.get(datas.get(20)).getProjectDepartmentId());
                                    } else {
                                        errorMessage.append("[项目池不存在当前使用项目的项目]");
                                    }
                                }
                            }
                        }
                    }else {
                        importVO.setDependOnProject(0);
                    }

                    if (StringUtils.isBlank(datas.get(20)) && StringUtils.isBlank(datas.get(21))) {
                        errorMessage.append("[使用项目、使用组织需要有一个必填]");
                    }


                    //使用组织
                    if (StringUtils.isNotBlank(datas.get(21))) {
                        importVO.setOrgName(datas.get(21));
                        if (datas.get(21).length() > 128) {
                            errorMessage.append("[使用组织填写长度为1~128字]");
                        } else {
                            if (orgVOMap.get(datas.get(21)) != null) {
                                if (datas.get(20) != null && importVO.getOrgId() != null && importVO.getOrgId().longValue() != orgVOMap.get(datas.get(21)).getId()) {
                                    errorMessage.append("[项目池中当前所属组织和所属项目不符合]");
                                } else {
                                    importVO.setOrgId(orgVOMap.get(datas.get(21)).getId());
                                }
                            } else {
                                CommonResponse<OrgVO> orgData = iOrgApi.findByNameAndTenantId(datas.get(21), tenantId);
                                if (!orgData.isSuccess()) {
                                    errorMessage.append("[组织管理中不存在当前使用组织]");
                                } else {
                                    if (datas.get(20) != null && importVO.getOrgId() != null && importVO.getOrgId().longValue() != orgData.getData().getId()) {
                                        errorMessage.append("[项目池中当前所属组织和所属项目不符合]");
                                    } else {
                                        orgVOMap.put(datas.get(21), orgData.getData());
                                        importVO.setOrgId(orgVOMap.get(datas.get(21)).getId());
                                    }
                                }
                            }
                        }
                    }

                    //* 产权单位
                    if (StringUtils.isBlank(datas.get(22))) {
                        errorMessage.append("[产权单位为必填项]");
                    }else {
                        importVO.setPropertyOrgName(datas.get(22));
                        if (datas.get(22).length() > 128) {
                            errorMessage.append("[产权单位填写长度为1~128字]");
                        } else {
                            if (orgVOMap.get(datas.get(22)) != null) {
                                importVO.setPropertyOrgId(orgVOMap.get(datas.get(22)).getId());
                            } else {
                                CommonResponse<OrgVO> orgData = iOrgApi.findByNameAndTenantId(datas.get(22), tenantId);
                                if (!orgData.isSuccess()) {
                                    errorMessage.append("[组织管理中不存在该产权单位");
                                } else {
                                    orgVOMap.put(datas.get(22), orgData.getData());
                                    importVO.setPropertyOrgId(orgVOMap.get(datas.get(22)).getId());
                                }
                            }
                        }
                    }
                    //* 管理单位
                    if (StringUtils.isBlank(datas.get(23))) {
                        errorMessage.append("[管理单位为必填项]");
                    }else {
                        importVO.setManageOrgName(datas.get(23));
                        if (datas.get(23).length() > 128) {
                            errorMessage.append("[管理单位填写长度为1~128字]");
                        } else {
                            if (orgVOMap.get(datas.get(23)) != null) {
                                importVO.setManageOrgId(orgVOMap.get(datas.get(23)).getId());
                            } else {
                                CommonResponse<OrgVO> orgData = iOrgApi.findByNameAndTenantId(datas.get(23), tenantId);
                                if (!orgData.isSuccess()) {
                                    errorMessage.append("[组织管理中不存在该管理单位");
                                } else {
                                    orgVOMap.put(datas.get(23), orgData.getData());
                                    importVO.setManageOrgId(orgVOMap.get(datas.get(23)).getId());
                                }
                            }
                        }
                    }


                    //验收日期
                    if (StringUtils.isBlank(datas.get(24))) {
                        errorMessage.append("[验收日期为必填项]");
                    } else {
                        try {
                            importVO.setCheckDate(DateUtils.parseDate(datas.get(24), "YYYY-MM-dd"));
                        } catch (ParseException e) {
                            errorMessage.append("[验收日期填写格式错误，请填写 YYYY-MM-dd 类型的日期格式]");
                            e.printStackTrace();
                        }
                    }


                    importVO.setEmployeeId(employeeId);
                    importVO.setEmployeeName(employeeName);
                    importVO.setEquipmentState(1);
                    importVO.setOutOccupyFlag(0);
                    importVO.setAssetSourceType(2);
                    importVO.setId(IdWorker.getId());
                    if (StringUtils.isBlank(errorMessage)) {
                        //资产数量
                        if (StringUtils.isNotBlank(datas.get(3)) && Integer.valueOf(datas.get(3)) > 1) {
                            //大于1
                            for (int e = 0; e < Integer.valueOf(datas.get(3)); e++){
                                importVO.setId(IdWorker.getId());
                                successList.add(importVO);
                            }
                            continue;
                        }
                        successList.add(importVO);
                    } else {
                        importVO.setErrorMessage(String.valueOf(errorMessage));
                        errorList.add(importVO);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<AssetVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("导入的数据为空！");
        }

        List<String> billCodeList = importVOS.stream().filter(e -> null != e.getBillCode()).map(AssetVO::getBillCode).collect(Collectors.toList());
        List<AssetEntity> oldEntityList = super.list(new QueryWrapper<AssetEntity>().in("bill_code", billCodeList));
        if (CollectionUtils.isNotEmpty(billCodeList) && oldEntityList.size() > 0){
            List<String> oldBIllCode = oldEntityList.stream().map(AssetEntity::getBillCode).collect(Collectors.toList());
            throw new BusinessException("导入数据中有资产编号重复的数据" + JSONObject.toJSONString(oldBIllCode));
        }

        importVOS.forEach(e -> e.setId(IdWorker.getId()));
        List<AssetEntity> entityList = BeanMapper.mapList(importVOS, AssetEntity.class);
        super.saveOrUpdateBatch(entityList, entityList.size(), false);
        return "保存成功";
    }
}
