package com.ejianc.business.labprice.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.labprice.bean.LaborResultDetailEntity;
import com.ejianc.business.labprice.service.ILaborResultDetailService;
import com.ejianc.business.labprice.vo.LaborPicketageVO;
import com.ejianc.business.labprice.vo.LaborResultDetailVO;
import com.ejianc.business.othprice.bean.ResultDetailEntity;
import com.ejianc.business.othprice.bean.ResultEntity;
import com.ejianc.business.othprice.service.IResultDetailService;
import com.ejianc.business.othprice.service.IResultService;
import com.ejianc.business.othprice.vo.MaterialResultVO;
import com.ejianc.business.othprice.vo.PicketageVO;
import com.ejianc.business.othprice.vo.ResultDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.labprice.bean.LaborResultEntity;
import com.ejianc.business.labprice.service.ILaborResultService;
import com.ejianc.business.labprice.vo.LaborResultVO;

/**
 * 定标结果
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("laborResult")
public class LaborResultController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialApi materialApi;
    private static final String BILL_CODE = "ZYDX_LABOR_RESULT";

    @Autowired
    private ILaborResultService service;

    @Autowired
    private ILaborResultDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LaborResultVO> saveOrUpdate(@RequestBody LaborResultVO saveOrUpdateVO) {
    	LaborResultEntity entity = BeanMapper.map(saveOrUpdateVO, LaborResultEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	LaborResultVO vo = BeanMapper.map(entity, LaborResultVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @ApiOperation("查询中标供应商列表")
    @RequestMapping(value = "/querySupplierList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<LaborResultVO>> querySupplierList(@RequestParam Long picketageId) {
        LambdaQueryWrapper<LaborResultEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(LaborResultEntity::getPicketageId, picketageId);
        List<LaborResultEntity> list = service.list(wrapper);
        List<LaborResultVO> materialResultVOS = BeanMapper.mapList(list, LaborResultVO.class);
        return CommonResponse.success("查询中标供应商列表！", materialResultVOS);
    }
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LaborResultVO> queryDetail(Long id) {
    	LaborResultEntity entity = service.selectById(id);
    	LaborResultVO vo = BeanMapper.map(entity, LaborResultVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetailByCon", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LaborResultVO> queryDetailByCon(@RequestBody LaborResultVO materialResultVO) {
        LambdaQueryWrapper<LaborResultEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(LaborResultEntity::getPicketageId, materialResultVO.getPicketageId());
        lambdaQueryWrapper.eq(LaborResultEntity::getSupplierId, materialResultVO.getSupplierId());
        List<LaborResultEntity> list = service.list(lambdaQueryWrapper);
        LaborResultVO vo = null;
        if (CollectionUtils.isNotEmpty(list)) {
            vo = BeanMapper.map(list.get(0), LaborResultVO.class);
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @ApiOperation("查询中标结果列表通过定标单")
    @RequestMapping(value = "/queryListByPicketage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<LaborResultVO>> queryListByPicketage(@RequestBody LaborPicketageVO picketageVO) {
        LambdaQueryWrapper<LaborResultEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(LaborResultEntity::getPicketageId, picketageVO.getId());
        List<LaborResultEntity> list = service.list(lambdaQueryWrapper);
        return CommonResponse.success("查询详情数据成功！", BeanMapper.mapList(list, LaborResultVO.class));
    }
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LaborResultVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (LaborResultVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(LaborResultVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LaborResultVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<LaborResultEntity> page = service.queryPage(param,false);
        IPage<LaborResultVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), LaborResultVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<LaborResultEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("LaborResult-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refLaborResultData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LaborResultVO>> refLaborResultData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("purchaseSubject");
        param.getFuzzyFields().add("purchaseTypeName");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("orgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);

            if (_con.containsKey("orgId")) {
                param.getComplexParams().add(getPageQueryParam(_con.getLong("orgId")));
            }
            if (_con.containsKey("supplierId") && _con.getLong("supplierId") != null) {
                param.getParams().put("supplierId", new Parameter(QueryParam.EQ, _con.getLong("supplierId")));
            }
            if (_con.containsKey("pricingType")) {
                String pricingType = _con.getString("pricingType");
                param.getParams().put("pricingType", new Parameter(QueryParam.IN, Arrays.asList(pricingType.split(",")) ));
            }
            if (_con.containsKey("purchaseType")) {
                param.getParams().put("purchaseType", new Parameter(QueryParam.EQ, _con.getInteger("purchaseType")));
            }

        }

        IPage<LaborResultEntity> page = service.queryPage(param, false);
        IPage<LaborResultVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LaborResultVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse<List<OrgVO>> childOrgResp = iOrgApi.findChildrenByParentId(orgId);
        CommonResponse<List<OrgVO>> parentOrgResp = iOrgApi.findParentsByOrgId(orgId);
        if (!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("合同分页列表查询失败, 查询组织信息失败！");
        }

        List<Long> parentOrgIds = new ArrayList<>();
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentOrgIds.addAll(parentOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentOrgIds.remove(orgId);

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("org_id", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c2);

        if (CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic(ComplexParam.OR);
            c3.getParams().put("purchase_type", new Parameter(QueryParam.EQ, 2));
            c3.getParams().put("org_id", new Parameter(QueryParam.IN, parentOrgIds));
            c1.getComplexParams().add(c3);
        }
        return c1;
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refResultDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LaborResultDetailVO>> refResultDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("detailName");
        param.getFuzzyFields().add("detailCode");
        param.getFuzzyFields().add("model");
        param.getFuzzyFields().add("unit");
        LaborResultEntity entity = new LaborResultEntity();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (!_con.containsKey("pid")) {
                return CommonResponse.error("查询条件定标结果单Id【pid】不能为空");
            }
            param.getParams().put("pid", new Parameter(QueryParam.EQ, _con.getLong("pid")));
            entity = service.selectById(_con.getLong("pid"));
        }

        IPage<LaborResultDetailEntity> page = detailService.queryPage(param, false);
        IPage<LaborResultDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<LaborResultDetailVO> list = BeanMapper.mapList(page.getRecords(), LaborResultDetailVO.class);
        pageData.setRecords(list);

        page.setTotal(page.getTotal());
        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
