package com.ejianc.business.sub.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sub.bean.SubSettleEntity;
import com.ejianc.business.sub.vo.SubSettleDetailVO;
import com.ejianc.business.sub.vo.SubSettleVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 分包过程结算表 Mapper 接口
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@Mapper
public interface SubSettleMapper extends BaseCrudMapper<SubSettleEntity> {

    List<SubSettleVO> querySubSettleVOList(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    List<SubSettleDetailVO> getSumSettleNumInfo(@Param(Constants.WRAPPER) QueryWrapper wrapper);

    List<SubSettleDetailVO> querySettleDetailHistory(SubSettleDetailVO settleDetailVO);

    List<SubSettleDetailVO> querySettleDetailList(SubSettleDetailVO settleDetailVO);

    String querySettleDetailSum(SubSettleDetailVO sd);
}
