/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.plan.service.IMaterialMasterPlanSubService;
import com.ejianc.business.plan.vo.MaterialMasterPlanVO;
import com.ejianc.business.plan.vo.PlanControlSubVO;
import com.ejianc.business.plan.vo.PlanControlVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="materialMasterPlanService")
public class MaterialMasterPlanServiceImpl
extends BaseServiceImpl<MaterialMasterPlanMapper, MaterialMasterPlanEntity>
implements IMaterialMasterPlanService {
    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;
    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;
    private static final String PARAM_TOTAL_MNY = "P-ne9e9741";
    private static final String PARAM_NUM = "P-uFOcn644";
    private static final String PARAM_TAX_MNY = "P-14dTg745";
    @Autowired
    private IMaterialMasterPlanSubService materialMasterPlanSubService;
    @Autowired
    private IParamConfigApi paramConfigApi;

    @Override
    public MaterialMasterPlanVO queryByCode(String planCode) {
        MaterialMasterPlanVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"plan_code", (Object)planCode);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        MaterialMasterPlanEntity entity = (MaterialMasterPlanEntity)((Object)this.materialMasterPlanMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (MaterialMasterPlanVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialMasterPlanVO.class));
        }
        return resp;
    }

    @Override
    public MaterialMasterPlanVO queryByProjectId(Long projectId) {
        MaterialMasterPlanVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        MaterialMasterPlanEntity entity = (MaterialMasterPlanEntity)((Object)this.materialMasterPlanMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (MaterialMasterPlanVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialMasterPlanVO.class));
        }
        return resp;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MaterialMasterPlanEntity saveOrUpdateMasterPlan(MaterialMasterPlanEntity saveEntity) {
        if (null != saveEntity.getId()) {
            this.materialMasterPlanSubMapper.delByPlanId(saveEntity.getId());
        }
        super.saveOrUpdate((Object)saveEntity, false);
        return saveEntity;
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public ParamsCheckVO checkParams(PlanControlVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap paramsCheckVOMap = new HashMap();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        List<PlanControlSubVO> materialSubList = vo.getPlanControlSubVOList();
        if (CollectionUtils.isNotEmpty(materialSubList)) {
            List list = materialSubList.stream().map(PlanControlSubVO::getMaterialId).collect(Collectors.toList());
        }
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }
}

