package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.material.mapper.StoreTopMapper;
import com.ejianc.business.material.service.IStoreTopService;
import com.ejianc.business.material.vo.ConstructionStoreVo;
import com.ejianc.business.material.vo.StoreDataVo;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class StoreTopServiceImpl implements IStoreTopService {

    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private StoreTopMapper storeTopMapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     *  materialTop10 ：前10个物料
     *  projectTop5 ：该物料的材料消耗金额前5的项目；
     *  contractTop :
     *          avgPrice 项目均价
     *          minPrice 最低价
     *          maxPrice 最高价
     *  公司均价：storeTopCompany
     *  项目均价：
     *
     * @param constructionStoreVo
     * @return
     */
    @Override
    public CommonResponse<JSONObject> storeTop(ConstructionStoreVo constructionStoreVo) {
        JSONObject jsonObject = new JSONObject();
        return CommonResponse.success(jsonObject);
    }

    /**
     * 根据当前物料查询金额前5的项目
     * @param orgIds
     * @param materialId
     * @param json
     * @return
     */
    private JSONObject queryProjectTop(String orgIds, Long materialId, JSONObject json) {
        List<JSONObject> projectTop = storeTopMapper.constructionStoreTopProject(orgIds, materialId);
        if (CollectionUtils.isNotEmpty(projectTop)) {
            List<Object> projectId = projectTop.stream().map(e -> e.get("projectId")).collect(Collectors.toList());
            String projectIds = "(" + String.join(",", projectId.stream().map(Object::toString).collect(Collectors.toList())) + ")";
            List<JSONObject> contractTop = storeTopMapper.constructionStoreTopContract(projectIds, materialId,orgIds);
            Map<Object, JSONObject> contractTopData = new HashMap<>();
            if (CollectionUtils.isNotEmpty(contractTop)) {
                contractTopData= contractTop.stream().collect(Collectors.toMap(e -> e.get("projectId"), e -> e));
            }
            for (JSONObject js : projectTop) {
                js.put("contractTop", contractTopData.get(js.get("projectId")) == null ? JSONObject.parseObject("{\"avgPrice\":0,\"minPrice\":0,\"maxPrice\":0}") : contractTopData.get(js.get("projectId")));
            }
            json.put("projectTop5", projectTop);

        } else {
            json.put("projectTop5", null);
        }
        //公司均价
        Long tenantId = InvocationInfoProxy.getTenantid();
        BigDecimal companyTop = storeTopMapper.constructionStoreTopContractCompany(tenantId, materialId);
        json.put("storeTopCompany", companyTop == null ? 0 : companyTop);
        return json;
    }
    @Override
    public CommonResponse<JSONObject> storeData(ConstructionStoreVo constructionStoreVo) {
        //获取对应的orgIds
        JSONObject jsonObject = new JSONObject();
        if (null==constructionStoreVo.getPlanSort()){
            constructionStoreVo.setPlanSort("desc");
        }
        if (null==constructionStoreVo.getInStoreSort()){
            constructionStoreVo.setInStoreSort("desc");
        }
        if (null==constructionStoreVo.getInStoreSort()){
            constructionStoreVo.setInStoreSort("desc");
        }
        return CommonResponse.success(jsonObject);
    }


}
