/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contract")
public class ContractBpmService
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IContractService contractService;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(billId));
        CommonResponse response = this.projectApi.saveContractMny(contractEntity.getProjectId(), contractEntity.getContractTaxMny(), contractEntity.getContractMny(), billId);
        this.logger.info("\u5408\u540c\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\uff0cbillId:{},state:{},billTypeCode:{}\uff0cProjectId:{},ContractTaxMny:{},ContractMny:{},\u63a8\u9001\u54cd\u5e94\uff1a{}", new Object[]{billId, state, billTypeCode, contractEntity.getProjectId(), contractEntity.getContractTaxMny(), contractEntity.getContractMny(), JSONObject.toJSONString((Object)response)});
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }
}

