package com.ejianc.business.income.controller;


import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.income.service.IClaimDetailService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ImportTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * <p>
 * 签证洽商索赔-清单 前端控制器
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@RestController
@RequestMapping("/claim/detail")
public class ClaimDetailController {
    @Autowired
    private IClaimDetailService claimDetailService;
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "claim-detail-import.xlsx", "变更签证洽商索赔清单导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return claimDetailService.excelImport(request,response);
    }
}
