package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.*;
import com.ejianc.business.cost.service.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("projectTargetcostChange") 
public class ProjectTargetcostChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IProjectTargetcostService service;
	@Autowired
	private IProjectTargetcostRecordService recordService;
	@Autowired
	private IProjectTargetcostChangeService changeService;
	@Autowired
	private IPrjcontractCostsService prjcontractCostsService;
	@Autowired
	private IEngdepartRespcostService engdepartRespcostService;
	@Autowired
	private IAttachmentApi attachmentApi;

	private static final String SOURCETYPE = "projectTargetcost";//合同
	private static final String CHANGE_SOURCETYPE = "projectTargetcostChange";//合同变更
	private static final String RECORD_SOURCETYPE = "projectTargetcostRecord";//合同记录


	private static final String BILLTYPE_CODE = "EJCBT202502000002";//项目目标成本

	private static final String CHANGE_BILLTYPE_CODE = "EJCBT202502000003";//项目目标成本

	private static final String RECORD_BILLTYPE_CODE = "EJCBT202502000015";//项目目标成本
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};
	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前合同信息、变更信息
		ProjectTargetcostChangeEntity changeEntity = changeService.selectById(billId);
		ProjectTargetcostEntity targetcostEntity = service.selectById(changeEntity.getTaskcostId());

//		changeService.saveOrUpdate(changeEntity, false);

		//获取历史版本条数
		QueryWrapper<ProjectTargetcostRecordEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("taskcost_id", targetcostEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordService.count(recordWrapper);
		//2、生成历史版本
		//2.1、生成合同信息
		ProjectTargetcostRecordEntity recordEntity = BeanMapper.map(targetcostEntity, ProjectTargetcostRecordEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordEntity);
		recordEntity.setBillState(null);
		recordEntity.setTaskcostId(targetcostEntity.getId());
		recordEntity.setId(recordId);
		recordEntity.setChangeReason(changeEntity.getChangeReason());
		recordEntity.setCodeVersion(changeEntity.getCodeVersion());

		List<ProjectTargetcostDetailEntity> projectTargetcostDetailList = targetcostEntity.getProjectTargetcostDetailList();
		Map<Long, ProjectTargetcostDetailEntity> oldDetailMap = new HashMap<>();
		if(projectTargetcostDetailList!=null&&projectTargetcostDetailList.size()>0){
			for(ProjectTargetcostDetailEntity entity : projectTargetcostDetailList){
				oldDetailMap.put(entity.getId(), entity);
			}
			Map<String, Long> map = new HashMap<>();
			List<ProjectTargetcostRecordDetailEntity> recordIncontractSubcontracteList = new ArrayList<>();

			for(ProjectTargetcostDetailEntity entity : projectTargetcostDetailList){
				ProjectTargetcostRecordDetailEntity reEntity = BeanMapper.map(entity, ProjectTargetcostRecordDetailEntity.class);
				reEntity.setTargetcostId(entity.getId());
				this.clearBaseData(reEntity);
				reEntity.setId(IdWorker.getId());
				reEntity.setTargetcostRecordId(recordId);
				map.put(entity.getCode(), reEntity.getId());
				recordIncontractSubcontracteList.add(reEntity);
//				entity.setRowState("del");
			}
			recordIncontractSubcontracteList.forEach(item -> {
				if(item.getCode().indexOf(".")!=-1){
					String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
					item.setPid(map.get(code));
				}
			});
			recordEntity.setProjectTargetcostRecordDetailList(recordIncontractSubcontracteList);
		}
		//复制合同附件信息到记录中
		attachmentApi.copyFilesFromSourceBillToTargetBill(targetcostEntity.getId().toString(), BILLTYPE_CODE, SOURCETYPE, recordId.toString(), RECORD_BILLTYPE_CODE, RECORD_SOURCETYPE);
		recordService.saveOrUpdate(recordEntity, false);
		logger.info("---------生成合同信息完成--------");
		//3、修改当前合同信息
		ProjectTargetcostEntity newEntity = BeanMapper.map(changeEntity, ProjectTargetcostEntity.class);
		newEntity.setChangeState("3");//状态改为已变更
		newEntity.setChangeId(null);
		newEntity.setBillState(targetcostEntity.getBillState());
		newEntity.setId(targetcostEntity.getId());
		newEntity.setCreateTime(targetcostEntity.getCreateTime());
		newEntity.setCreateUserCode(targetcostEntity.getCreateUserCode());
		newEntity.setTenantId(targetcostEntity.getTenantId());
		newEntity.setVersion(targetcostEntity.getVersion());
		//子表

		List<ProjectTargetcostDetailEntity> saveDetailEntity = new ArrayList<>();

		List<ProjectTargetcostChangeDetailEntity> projectTargetcostChangeDetailList = changeEntity.getProjectTargetcostChangeDetailList();
		if(projectTargetcostChangeDetailList!=null&&projectTargetcostChangeDetailList.size()>0){
			Map<String, Long> map = new HashMap<>();
			List<ProjectTargetcostDetailEntity> projectTargetcostDetailEntity = new ArrayList<>();
			List<Long> exitIds = new ArrayList<>();
			for(ProjectTargetcostChangeDetailEntity entity : projectTargetcostChangeDetailList){
				if(entity.getTargetcostDetailId()!=null){
					exitIds.add(entity.getTargetcostDetailId());
				}
				if(entity.getTargetcostDetailId()!=null && oldDetailMap.get(entity.getTargetcostDetailId())!=null){
					ProjectTargetcostDetailEntity dEntity = oldDetailMap.get(entity.getTargetcostDetailId());
					dEntity.setAmount(entity.getAmount());
					dEntity.setRemark(entity.getRemark());
					dEntity.setRowState("edit");
					map.put(entity.getCode(), dEntity.getId());
					projectTargetcostDetailEntity.add(dEntity);
					saveDetailEntity.add(dEntity);
				}else{
					//变更新增的数据
					ProjectTargetcostDetailEntity dEntity = BeanMapper.map(entity, ProjectTargetcostDetailEntity.class);
					this.clearBaseData(dEntity);
					dEntity.setId(IdWorker.getId());
					dEntity.setTargetcostId(recordId);
					dEntity.setRowState("add");
					map.put(entity.getCode(), dEntity.getId());
					projectTargetcostDetailEntity.add(dEntity);
					saveDetailEntity.add(dEntity);
				}
			}

			projectTargetcostDetailEntity.forEach(item -> {
				if(item.getCode().indexOf(".")!=-1){
					String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
					item.setPid(map.get(code));
				}
			});

			//处理删除数据
			if(projectTargetcostDetailList!=null&&projectTargetcostDetailList.size()>0) {
				for (ProjectTargetcostDetailEntity entity : projectTargetcostDetailList) {
					if(!exitIds.contains(entity.getId())){
						entity.setRowState("del");
						projectTargetcostDetailEntity.add(entity);
					}
				}
			}
			newEntity.setProjectTargetcostDetailList(projectTargetcostDetailEntity);
		}
		service.saveOrUpdate(newEntity, false);
		//复制合同附件信息到记录中
		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), CHANGE_BILLTYPE_CODE, CHANGE_SOURCETYPE, targetcostEntity.getId().toString(), BILLTYPE_CODE, SOURCETYPE);


		ProjectTargetcostEntity new1Entity = BeanMapper.map(newEntity, ProjectTargetcostEntity.class);
		new1Entity.setProjectTargetcostDetailList(saveDetailEntity);
		//推送生成工程部责任成本
		engdepartRespcostService.generate(new1Entity);
		//推送生成项目合同造价表
		prjcontractCostsService.generate(new1Entity);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("变更单不允许弃审");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
