package com.ejianc.business.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * <p>
 * 甲方报量-工程量明细
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@TableName("ejc_zypms_income_quote_detail")
public class QuoteDetailEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 甲方报量主键
     */
    @TableField("quote_id")
    private Long quoteId;

    /**
     * 清单编号
     */
    @TableField("code")
    private String code;

    /**
     * parent_id
     */
    @TableField("parent_id")
    private Long parentId;

    /**
     * 序号
     */
    @TableField("detail_index")
    private String detailIndex;

    /**
     * 是否末级
     */
    @TableField("leaf_flag")
    private Boolean leafFlag;

    /**
     * 来源主键（合同清单）
     */
    @TableField("contract_detail_id")
    private Long contractDetailId;

    /**
     * 来源主键（产值报量）
     */
    @TableField("production_detail_id")
    private Long productionDetailId;

    /**
     * 来源主键（产值报量主表）
     */
    @TableField("production_id")
    private Long productionId;

    /**
     * 清单名称
     */
    @TableField("name")
    private String name;

    /**
     * 计量单位
     */
    @TableField("unit")
    private String unit;

    /**
     * 工程量
     */
    @TableField("num")
    private BigDecimal num;

    /**
     * 综合单价
     */
    @TableField("price")
    private BigDecimal price;

    /**
     * 产值完成量
     */
    @TableField("finish_num")
    private BigDecimal finishNum;

    /**
     * 本期完成产值
     */
    @TableField("quote_num")
    private BigDecimal quoteNum;

    /**
     * 本期结算金额
     */
    @TableField("quote_mny")
    private BigDecimal quoteMny;

    /**
     * 来源，1-合同内，2-合同外
     */
    @TableField("source_type")
    private Integer sourceType;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;
    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;

    /**
     * 累计甲方报量(不含本期)
     */
    @TableField("sum_quote_num")
    private BigDecimal sumQuoteNum;

    /**
     * 累计甲方报量(含本期)
     */
    @TableField("sum_quote_num_endthis")
    private BigDecimal sumQuoteNumEndthis;
    @TableField("detail_mny")
    private BigDecimal detailMny;

    /**
     * 剩余工程量
     */
    @TableField("surplus_num")
    private BigDecimal surplusNum;
    @TableField("proportion_report")
    private BigDecimal proportionReport;//本次报量比例

    public BigDecimal getProportionReport() {
        return proportionReport;
    }

    public void setProportionReport(BigDecimal proportionReport) {
        this.proportionReport = proportionReport;
    }

    public BigDecimal getSumQuoteNum() {
        return sumQuoteNum;
    }

    public void setSumQuoteNum(BigDecimal sumQuoteNum) {
        this.sumQuoteNum = sumQuoteNum;
    }

    public BigDecimal getSumQuoteNumEndthis() {
        return sumQuoteNumEndthis;
    }

    public void setSumQuoteNumEndthis(BigDecimal sumQuoteNumEndthis) {
        this.sumQuoteNumEndthis = sumQuoteNumEndthis;
    }

    public BigDecimal getSurplusNum() {
        return surplusNum;
    }

    public void setSurplusNum(BigDecimal surplusNum) {
        this.surplusNum = surplusNum;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public Long getQuoteId() {
        return quoteId;
    }

    public void setQuoteId(Long quoteId) {
        this.quoteId = quoteId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }

    public Long getProductionDetailId() {
        return productionDetailId;
    }

    public void setProductionDetailId(Long productionDetailId) {
        this.productionDetailId = productionDetailId;
    }

    public Long getProductionId() {
        return productionId;
    }

    public void setProductionId(Long productionId) {
        this.productionId = productionId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getFinishNum() {
        return finishNum;
    }

    public void setFinishNum(BigDecimal finishNum) {
        this.finishNum = finishNum;
    }

    public BigDecimal getQuoteNum() {
        return quoteNum;
    }

    public void setQuoteNum(BigDecimal quoteNum) {
        this.quoteNum = quoteNum;
    }

    public BigDecimal getQuoteMny() {
        return quoteMny;
    }

    public void setQuoteMny(BigDecimal quoteMny) {
        this.quoteMny = quoteMny;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @Override
    public String toString() {
        return "QuoteDetailEntity{" +
                "quoteId=" + quoteId +
                ", code=" + code +
                ", parentId=" + parentId +
                ", detailIndex=" + detailIndex +
                ", leafFlag=" + leafFlag +
                ", contractDetailId=" + contractDetailId +
                ", productionDetailId=" + productionDetailId +
                ", productionId=" + productionId +
                ", name=" + name +
                ", unit=" + unit +
                ", num=" + num +
                ", price=" + price +
                ", finishNum=" + finishNum +
                ", quoteNum=" + quoteNum +
                ", quoteMny=" + quoteMny +
                ", sourceType=" + sourceType +
                ", memo=" + memo +
                "}";
    }

    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
}
