package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.asset.vo.AssetOutDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 固定资产调出
 * 
 * @author generator
 * 
 */
public class AssetOutVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 单据编号
    private Integer dependOnProject; // 是否属于项目: 默认为true
    private String projectName; // 出库项目名称
    private String projectCode; // 出库项目编码
    private Long projectId; // 出库项目id
    private Long orgId; // 出库组织id
    private String orgName; // 出库组织名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate; // 调出日期
    private BigDecimal outMny; // 调出金额
    private Long employeeId; // 经办人
    private String employeeName; // 经办人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate; // 编制日期
    private String memo; // 备注
    private Integer inDependOnProject; // 是否属于项目: 默认为true
    private String inProjectName; // 调入项目名称
    private String inProjectCode; // 调入项目编码
    private Long inProjectId; // 调入项目id
    private Long inOrgId; // 调入组织id
    private String inOrgName; // 调入组织名称
    private Long receivePersonId; // 通知接收人
    private String receivePersonName; // 通知接收人
    private String receiveState; // 调入组织收料状态 1-待收料 2-已收料 3-已退回
    private String receiveStateName; // 调入组织收料状态 1-待收料 2-已收料 3-已退回

    private String billStateName; //单据编码名称
    
    private List<AssetOutDetailVO> detailList = new ArrayList<>(); // 固定资产调出-子实体

    public String getReceiveStateName() {
        return receiveStateName;
    }

    public void setReceiveStateName(String receiveStateName) {
        this.receiveStateName = receiveStateName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(Integer dependOnProject) {
        this.dependOnProject = dependOnProject;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getInDependOnProject() {
        return inDependOnProject;
    }

    public void setInDependOnProject(Integer inDependOnProject) {
        this.inDependOnProject = inDependOnProject;
    }
    public String getInProjectName() {
        return inProjectName;
    }

    public void setInProjectName(String inProjectName) {
        this.inProjectName = inProjectName;
    }
    public String getInProjectCode() {
        return inProjectCode;
    }

    public void setInProjectCode(String inProjectCode) {
        this.inProjectCode = inProjectCode;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getInProjectId() {
        return inProjectId;
    }
    @ReferDeserialTransfer
    public void setInProjectId(Long inProjectId) {
        this.inProjectId = inProjectId;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getInOrgId() {
        return inOrgId;
    }
    @ReferDeserialTransfer
    public void setInOrgId(Long inOrgId) {
        this.inOrgId = inOrgId;
    }
    public String getInOrgName() {
        return inOrgName;
    }

    public void setInOrgName(String inOrgName) {
        this.inOrgName = inOrgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getReceivePersonId() {
        return receivePersonId;
    }
    @ReferDeserialTransfer
    public void setReceivePersonId(Long receivePersonId) {
        this.receivePersonId = receivePersonId;
    }
    public String getReceivePersonName() {
        return receivePersonName;
    }

    public void setReceivePersonName(String receivePersonName) {
        this.receivePersonName = receivePersonName;
    }
    public String getReceiveState() {
        return receiveState;
    }

    public void setReceiveState(String receiveState) {
        this.receiveState = receiveState;
    }

    public List<AssetOutDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<AssetOutDetailVO> detailList) {
        this.detailList = detailList;
    }
}
