package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/8 采购询比价 子表
 * @Description ComparePriceSubEntity
 */

@TableName("ejc_material_compare_price_sub")
public class ComparePriceSubEntity  extends BaseEntity {
    /**
     * 主表id
     */
    @TableField(value = "pid")
    private Long pid;

    /**
     * 物资分类名称
     */
    @TableField(value = "material_type_name")
    private String materialTypeName;


    /**
     * 物资分类id
     */
    @TableField(value = "material_type_id")
    private Long materialTypeId;

    /**
     * 物资名称
     */
    @TableField(value = "material_name")
    private String materialName;

    /**
     * 物资id
     */
    @TableField(value = "material_id")
    private Long materialId;

    /**
     * 规格型号
     */
    @TableField(value = "model")
    private String model;

    /**
     * 计量单位
     */
    @TableField(value = "unit")
    private String unit;

    /**
     * 数量
     */
    @TableField(value = "num")
    private BigDecimal num;

    /**
     * 品牌
     */
    @TableField(value = "supplier_name")
    private String supplierName;

    /**
     * 物资来源类型：1-物料档案，2-用料申请
     */
    @TableField(value = "source_type")
    private String sourceType;


    @TableField(exist = false)
    private List<ComparePriceSelectedSupplierEntity> supplierEntities = new ArrayList<>();

    /**
     * 物资编码
     */
    @TableField(value = "material_code")
    private String materialCode;

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public List<ComparePriceSelectedSupplierEntity> getSupplierEntities() {
        return supplierEntities;
    }

    public void setSupplierEntities(List<ComparePriceSelectedSupplierEntity> supplierEntities) {
        this.supplierEntities = supplierEntities;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
}
