package com.ejianc.business.othprice.controller;

import com.ejianc.business.othprice.common.vo.InquiryCommonVO;
import com.ejianc.business.othprice.service.OthInquiryCommonService;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;

/**
 * @description: 询价公共服务
 * @author songlx
 * @date 2023/2/8
 * @version 1.0
 */
@Controller
@RequestMapping("othInquiryCommon")
@Api(value = "询价公共服务", tags = {"询价公共服务"})
public class OthInquiryCommonController implements Serializable {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private OthInquiryCommonService inquiryCommonService;


    /**
     * @description: 查询询价详情-供应商报价,材料定标数据
     *
     * @param id
     * @param inquiryState
     * @param inquiryType
     * @param picketageFlag 是否是定标节点,是的话查询中标信息,不是只查报价信息
     * @return {@link CommonResponse<>}
     * @author songlx
     * @date: 2023/2/8
     */
    @ApiOperation("查询各个阶段的询价详情")
    @RequestMapping(value = "/queryDetailByInquiry", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InquiryCommonVO> queryDetailByInquiry(@RequestParam Long id, @RequestParam Integer inquiryState, @RequestParam String inquiryType, @RequestParam(required = false) Boolean picketageFlag) {
        InquiryCommonVO vo = inquiryCommonService.queryDetailByInquiry(id, inquiryState, inquiryType, picketageFlag);
        return CommonResponse.success("查询详情数据成功！", vo);
    }



//    /**
//     * @description: 根据询价id或者定标id查询合同签订列表
//     *
//     * @param id 询价ID
//     * @param picketageId 定标ID
//     * @param inquiryState 询价状态 {@link com.ejianc.business.bidprice.consts.InquiryStateEnum}
//     * @param inquiryType 询价类型  {@link com.ejianc.business.bidprice.consts.InquiryTypeConsts}
//     * @return {@link CommonResponse< JSONObject>}
//     * @author songlx
//     * @date: 2023/2/14
//     */
//    @ApiOperation("查询询价的合同列表")
//    @RequestMapping(value = "/queryContractListByInquiry", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<JSONObject> queryContractListByInquiry(@RequestParam(required = false) Long id, @RequestParam(required = false) Long picketageId, @RequestParam(required = false) Integer inquiryState, @RequestParam String inquiryType) {
//        JSONObject obj = inquiryCommonService.queryContractListByInquiry(id, picketageId, inquiryState, inquiryType);
//        return CommonResponse.success("查询询价的合同列表成功！", obj);
//    }



}
