package com.ejianc.business.cost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.cost.vo.ProjectTargetcostDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 项目目标成本
 * 
 * @author generator
 * 
 */
public class ProjectTargetcostVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String changeState; // 变更状态
    private Long changeId; // 变更单据
    private Integer billState; // 单据审批状态
    private String billCode; // 单据编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long projectDepartmentId; // 项目部id
    private Long orgId; // 组织ID
    private String projectProperty; // 项目属性
    private Long respcostId; // 工程部责任成本ID
    private BigDecimal allocateContractMny; // 分配合同额
    private BigDecimal respcostTotal; // 工程部责任成本总额
    private String pubUnitName; // 发包单位名称
    private String contractUnitName; // 承包单位名称
    private BigDecimal contractTaxMny; // 含税合同额
    private BigDecimal contractMny; // 不含税合同额
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 项目开工时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishDate; // 项目完工时间
    private String address; // 施工地点
    private Long establishmentOrgId; // 编制单位ID
    private String establishmentOrgName; // 编制单位名称
    private Long establishmentUserId; // 编制人ID
    private String establishmentUserName; // 编制人名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date establishmentDate; // 编制日期
    private BigDecimal targetcostTotal; // 目标成本总额
    private BigDecimal prjcostGrossProfit; // 项目毛利润
    private String prjcostRate; // 项目毛利率
    private String remark; // 备注
    
    private List<ProjectTargetcostDetailVO> projectTargetcostDetailList = new ArrayList<>(); // 项目目标成本明细
    private List<ProjectTargetcostRecordVO> recordList = new ArrayList<>(); //
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    @ReferSerialTransfer(referCode="zydx-engdepartRespcost")
    public Long getRespcostId() {
        return respcostId;
    }

    @ReferDeserialTransfer
    public void setRespcostId(Long respcostId) {
        this.respcostId = respcostId;
    }
    public BigDecimal getRespcostTotal() {
        return respcostTotal;
    }

    public void setRespcostTotal(BigDecimal respcostTotal) {
        this.respcostTotal = respcostTotal;
    }
    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }
    public String getContractUnitName() {
        return contractUnitName;
    }

    public void setContractUnitName(String contractUnitName) {
        this.contractUnitName = contractUnitName;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getEstablishmentOrgId() {
        return establishmentOrgId;
    }

    @ReferDeserialTransfer
    public void setEstablishmentOrgId(Long establishmentOrgId) {
        this.establishmentOrgId = establishmentOrgId;
    }
    public String getEstablishmentOrgName() {
        return establishmentOrgName;
    }

    public void setEstablishmentOrgName(String establishmentOrgName) {
        this.establishmentOrgName = establishmentOrgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEstablishmentUserId() {
        return establishmentUserId;
    }

    @ReferDeserialTransfer
    public void setEstablishmentUserId(Long establishmentUserId) {
        this.establishmentUserId = establishmentUserId;
    }
    public String getEstablishmentUserName() {
        return establishmentUserName;
    }

    public void setEstablishmentUserName(String establishmentUserName) {
        this.establishmentUserName = establishmentUserName;
    }
    public Date getEstablishmentDate() {
        return establishmentDate;
    }

    public void setEstablishmentDate(Date establishmentDate) {
        this.establishmentDate = establishmentDate;
    }
    public BigDecimal getTargetcostTotal() {
        return targetcostTotal;
    }

    public void setTargetcostTotal(BigDecimal targetcostTotal) {
        this.targetcostTotal = targetcostTotal;
    }
    public BigDecimal getPrjcostGrossProfit() {
        return prjcostGrossProfit;
    }

    public void setPrjcostGrossProfit(BigDecimal prjcostGrossProfit) {
        this.prjcostGrossProfit = prjcostGrossProfit;
    }
    public String getPrjcostRate() {
        return prjcostRate;
    }

    public void setPrjcostRate(String prjcostRate) {
        this.prjcostRate = prjcostRate;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    
     public List<ProjectTargetcostDetailVO> getProjectTargetcostDetailList() {
        return projectTargetcostDetailList;
     }

     public void setProjectTargetcostDetailList(List<ProjectTargetcostDetailVO> projectTargetcostDetailList) {
        this.projectTargetcostDetailList = projectTargetcostDetailList;
     }

    public List<ProjectTargetcostRecordVO> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<ProjectTargetcostRecordVO> recordList) {
        this.recordList = recordList;
    }

    public String getProjectProperty() {
        return projectProperty;
    }

    public void setProjectProperty(String projectProperty) {
        this.projectProperty = projectProperty;
    }

    public BigDecimal getAllocateContractMny() {
        return allocateContractMny;
    }

    public void setAllocateContractMny(BigDecimal allocateContractMny) {
        this.allocateContractMny = allocateContractMny;
    }
}
