package com.ejianc.business.income.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class MonthUtil {
    /**
     * 加月份
     *
     * @param sdf
     * @param m
     * @param len
     * @return
     */
    public static String monthAdd(SimpleDateFormat sdf, String m, Integer len) {
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(sdf.parse(m));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        cal.add(Calendar.MONTH, len);
        return sdf.format(cal.getTime());
    }

    /**
     * 加月份
     *
     * @param m
     * @param len
     * @return
     */
    public static Date monthAdd(Date m, Integer len) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(m);
        cal.add(Calendar.MONTH, len);
        return cal.getTime();
    }

    /**
     * 比较日期大小,如2020-10-23格式
     *
     * @param t1
     * @param t2
     * @return
     */
    public static int compareTime(String t1, String t2) {
        int trr1 = Integer.parseInt(t1.replaceAll("-", ""));
        int trr2 = Integer.parseInt(t2.replaceAll("-", ""));
        if (trr1 > trr2) {
            return 1;
        } else if (trr1 < trr2) {
            return -1;
        }
        return 0;
    }

    /**
     * 获取两个月份之间的月份集合，包含首尾
     *
     * @param t1
     * @param t2
     * @return
     */
    public static List<String> getMonthList(String t1, String t2) {
        List<String> monthList = new ArrayList<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String flag = t1;
        for (int i = 1; compareTime(flag, t2) <= 0; i++) {
            monthList.add(flag);
            flag = monthAdd(sdf, t1, i);
        }
        return monthList;
    }

}
